/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.source;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.source.SourceV2_1;
import gov.nih.nlm.kss.util.CompareUtil;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class Source
extends SourceV2_1
implements Serializable,
Xmlizable,
KSComparable {
    private static String UNKNOWN = "UNKNOWN";
    private String vcui;
    private String rcui;
    private String vsab;
    private String family;
    private String version;
    private String mstart;
    private String mend;
    private String imeta;
    private String rmeta;
    private String slc;
    private String scc;
    private int tfr;
    private int cfr;
    private String cxty;
    private Vector ttyl;
    private Vector atnl;
    private String lat;
    private String cenc;
    private boolean curver;
    private boolean sabin;
    private String scit;

    public Source() {
        super("", "", "");
    }

    public Source(String sab, String name, String nickName) {
        super(sab, name, nickName);
        this.vsab = sab;
        this.vcui = "";
        this.rcui = "";
        this.family = "";
        this.version = "";
        this.mstart = "";
        this.mend = "";
        this.imeta = "";
        this.rmeta = "";
        this.slc = "";
        this.scc = "";
        this.tfr = 0;
        this.cfr = 0;
        this.cxty = "";
        this.ttyl = new Vector();
        this.atnl = new Vector();
        this.lat = "";
        this.cenc = "";
        this.curver = true;
        this.sabin = true;
        this.scit = "";
    }

    public Source(Source src) {
        super(src.getSAB(), src.getName(), src.getNickName());
        this.vcui = src.getVCUI();
        this.rcui = src.getRCUI();
        this.vsab = src.getVSAB();
        this.family = src.getFamily();
        this.version = src.getVersion();
        this.mstart = src.getMetaStart();
        this.mend = src.getMetaEnd();
        this.imeta = src.getInsert();
        this.rmeta = src.getRemove();
        this.slc = src.getLicenseContact();
        this.scc = src.getContentContact();
        this.tfr = src.getTermFrequency();
        this.cfr = src.getCUIFrequency();
        this.cxty = src.getContext();
        this.ttyl = new Vector();
        Vector ttl = src.getTermTypeList();
        Iterator iter = ttl.iterator();
        while (iter.hasNext()) {
            this.ttyl.add(iter.next());
        }
        this.atnl = new Vector();
        Vector atn = src.getAttrNameList();
        iter = atn.iterator();
        while (iter.hasNext()) {
            this.atnl.add(iter.next());
        }
        this.lat = src.getLanguage();
        this.cenc = src.getCharEncode();
        this.curver = src.getCurrentVersion();
        this.sabin = src.getSabin();
        this.scit = src.getSCIT();
    }

    public Source(Element source, Namespace namespace) throws XMLException {
        super("", "", "");
        Element latChild;
        List atns;
        List ttys;
        Element vcuiChild = source.getChild("vcui", namespace);
        this.vcui = vcuiChild == null ? UNKNOWN : XMLInterpreter.extractString(vcuiChild);
        Element rcuiChild = source.getChild("rcui", namespace);
        this.rcui = rcuiChild == null ? UNKNOWN : XMLInterpreter.extractString(rcuiChild);
        Element sabChild = source.getChild("sab", namespace);
        if (sabChild == null) {
            throw new XMLException("No source abbreviation <sab> found");
        }
        this.setSAB(XMLInterpreter.extractString(sabChild));
        Element vsabChild = source.getChild("vsab", namespace);
        this.vsab = vsabChild == null ? UNKNOWN : XMLInterpreter.extractString(vsabChild);
        Element nameChild = source.getChild("name", namespace);
        if (nameChild == null) {
            throw new XMLException("No source long name <name> found");
        }
        this.setName(XMLInterpreter.extractString(nameChild));
        Element nickNameChild = source.getChild("nickname", namespace);
        if (nickNameChild == null) {
            throw new XMLException("No source short name <nickname> found");
        }
        this.setNickName(XMLInterpreter.extractString(nickNameChild));
        Element familyChild = source.getChild("family", namespace);
        this.family = familyChild == null ? UNKNOWN : XMLInterpreter.extractString(familyChild);
        Element versionChild = source.getChild("version", namespace);
        this.version = versionChild == null ? UNKNOWN : XMLInterpreter.extractString(versionChild);
        Element mstartChild = source.getChild("mstart", namespace);
        this.mstart = mstartChild == null ? UNKNOWN : XMLInterpreter.extractString(mstartChild);
        Element mendChild = source.getChild("mend", namespace);
        this.mend = mendChild == null ? UNKNOWN : XMLInterpreter.extractString(mendChild);
        Element imetaChild = source.getChild("imeta", namespace);
        this.imeta = imetaChild == null ? UNKNOWN : XMLInterpreter.extractString(imetaChild);
        Element rmetaChild = source.getChild("rmeta", namespace);
        this.rmeta = rmetaChild == null ? UNKNOWN : XMLInterpreter.extractString(rmetaChild);
        Element slcChild = source.getChild("slc", namespace);
        this.slc = slcChild == null ? UNKNOWN : XMLInterpreter.extractString(slcChild);
        Element sccChild = source.getChild("scc", namespace);
        this.scc = sccChild == null ? UNKNOWN : XMLInterpreter.extractString(sccChild);
        Element tfrChild = source.getChild("tfr", namespace);
        if (tfrChild == null) {
            this.tfr = 0;
        } else {
            String tfrs = XMLInterpreter.extractString(tfrChild);
            Integer tf = new Integer(tfrs);
            this.tfr = tf;
        }
        Element cfrChild = source.getChild("cfr", namespace);
        if (cfrChild == null) {
            this.cfr = 0;
        } else {
            String cfrs = XMLInterpreter.extractString(cfrChild);
            Integer cf = new Integer(cfrs);
            this.cfr = cf;
        }
        Element cxtyChild = source.getChild("cxty", namespace);
        this.cxty = cxtyChild == null ? UNKNOWN : XMLInterpreter.extractString(cxtyChild);
        Element ttylChild = source.getChild("ttyl", namespace);
        this.ttyl = new Vector();
        if (ttylChild != null && (ttys = ttylChild.getChildren("tty", namespace)) != null) {
            int i = 0;
            while (i < ttys.size()) {
                Element tty = (Element)ttys.get(i);
                String t = XMLInterpreter.extractString(tty);
                this.ttyl.add(t);
                ++i;
            }
        }
        Element atnlChild = source.getChild("atnl", namespace);
        this.atnl = new Vector();
        if (atnlChild != null && (atns = atnlChild.getChildren("atn", namespace)) != null) {
            int i = 0;
            while (i < atns.size()) {
                Element atn = (Element)atns.get(i);
                String a = XMLInterpreter.extractString(atn);
                this.atnl.add(a);
                ++i;
            }
        }
        this.lat = (latChild = source.getChild("lat", namespace)) == null ? UNKNOWN : XMLInterpreter.extractString(latChild);
        Element cencChild = source.getChild("cenc", namespace);
        this.cenc = cencChild == null ? UNKNOWN : XMLInterpreter.extractString(cencChild);
        Element curverChild = source.getChild("curver", namespace);
        this.curver = curverChild != null;
        Element sabinChild = source.getChild("sabin", namespace);
        this.sabin = sabinChild != null;
        Element scitChild = source.getChild("scit", namespace);
        this.scit = scitChild == null ? "" : XMLInterpreter.extractString(scitChild);
    }

    public static Source getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals("sourceDef")) {
                throw new XMLException("sourceDef must be the name of the first element");
            }
            return new Source(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setVCUI(String vcui) {
        this.vcui = vcui;
    }

    public String getVCUI() {
        return this.vcui;
    }

    public void setRCUI(String rcui) {
        this.rcui = rcui;
    }

    public String getRCUI() {
        return this.rcui;
    }

    public void setVSAB(String vsab) {
        this.vsab = vsab;
    }

    public String getVSAB() {
        return this.vsab;
    }

    public void setRSAB(String rsab) {
        this.setSAB(rsab);
    }

    public String getRSAB() {
        return this.getSAB();
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public String getFamily() {
        return this.family;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setMetaStart(String mstart) {
        this.mstart = mstart;
    }

    public String getMetaStart() {
        return this.mstart;
    }

    public void setMetaEnd(String mend) {
        this.mend = mend;
    }

    public String getMetaEnd() {
        return this.mend;
    }

    public void setInsert(String imeta) {
        this.imeta = imeta;
    }

    public String getInsert() {
        return this.imeta;
    }

    public void setRemove(String rmeta) {
        this.rmeta = rmeta;
    }

    public String getRemove() {
        return this.rmeta;
    }

    public void setLicenseContact(String slc) {
        this.slc = slc;
    }

    public String getLicenseContact() {
        return this.slc;
    }

    public void setContentContact(String scc) {
        this.scc = scc;
    }

    public String getContentContact() {
        return this.scc;
    }

    public void setTermFrequency(int tfr) {
        this.tfr = tfr;
    }

    public int getTermFrequency() {
        return this.tfr;
    }

    public void setCUIFrequency(int cfr) {
        this.cfr = cfr;
    }

    public int getCUIFrequency() {
        return this.cfr;
    }

    public void setContext(String cxty) {
        this.cxty = cxty;
    }

    public String getContext() {
        return this.cxty;
    }

    public void addTermType(String tty) {
        if (this.ttyl == null) {
            this.ttyl = new Vector();
        }
        this.ttyl.add(tty);
    }

    public void setTermTypeList(Vector ttyl) {
        this.ttyl = new Vector();
        Iterator iter = ttyl.iterator();
        while (iter.hasNext()) {
            this.ttyl.add(iter.next());
        }
    }

    public Vector getTermTypeList() {
        return this.ttyl;
    }

    public void addAttrName(String atn) {
        if (this.atnl == null) {
            this.atnl = new Vector();
        }
        this.atnl.add(atn);
    }

    public void setAttrNameList(Vector atnl) {
        this.atnl = new Vector();
        Iterator iter = atnl.iterator();
        while (iter.hasNext()) {
            this.atnl.add(iter.next());
        }
    }

    public Vector getAttrNameList() {
        return this.atnl;
    }

    public void setLanguage(String lat) {
        this.lat = lat;
    }

    public String getLanguage() {
        return this.lat;
    }

    public void setCharEncode(String cenc) {
        this.cenc = cenc;
    }

    public String getCharEncode() {
        return this.cenc;
    }

    public void setCurrentVersion(boolean curver) {
        this.curver = curver;
    }

    public boolean getCurrentVersion() {
        return this.curver;
    }

    public void setSabin(boolean sabin) {
        this.sabin = sabin;
    }

    public boolean getSabin() {
        return this.sabin;
    }

    public void setSCIT(String scit) {
        this.scit = scit;
    }

    public String getSCIT() {
        return this.scit;
    }

    private static void writeSource(StringBuffer xml, Source src) {
        Vector atnl;
        Vector ttyl;
        String tab0 = "\t";
        String tab1 = "\t\t";
        String tab2 = "\t\t    ";
        xml.append(tab0);
        xml.append("<sourceDef>\n");
        xml.append(tab1);
        xml.append("<vcui>");
        xml.append(Str.escape(src.getVCUI()));
        xml.append("</vcui>\n");
        xml.append(tab1);
        xml.append("<rcui>");
        xml.append(Str.escape(src.getRCUI()));
        xml.append("</rcui>\n");
        xml.append(tab1);
        xml.append("<vsab>");
        xml.append(Str.escape(src.getVSAB()));
        xml.append("</vsab>\n");
        xml.append(tab1);
        xml.append("<sab>");
        xml.append(Str.escape(src.getRSAB()));
        xml.append("</sab>\n");
        xml.append(tab1);
        xml.append("<name>");
        xml.append(Str.escape(src.getName()));
        xml.append("</name>\n");
        xml.append(tab1);
        xml.append("<nickname>");
        xml.append(Str.escape(src.getNickName()));
        xml.append("</nickname>\n");
        xml.append(tab1);
        xml.append("<family>");
        xml.append(Str.escape(src.getFamily()));
        xml.append("</family>\n");
        String val = src.getVersion();
        if (val != null && !val.equals(UNKNOWN) && !val.equals("")) {
            xml.append(tab1);
            xml.append("<version>");
            xml.append(Str.escape(val));
            xml.append("</version>\n");
        }
        if ((val = src.getMetaStart()) != null && !val.equals(UNKNOWN) && !val.equals("")) {
            xml.append(tab1);
            xml.append("<mstart>");
            xml.append(Str.escape(val));
            xml.append("</mstart>\n");
        }
        if ((val = src.getMetaEnd()) != null && !val.equals(UNKNOWN) && !val.equals("")) {
            xml.append(tab1);
            xml.append("<mend>");
            xml.append(Str.escape(val));
            xml.append("</mend>\n");
        }
        if ((val = src.getInsert()) != null && !val.equals(UNKNOWN) && !val.equals("")) {
            xml.append(tab1);
            xml.append("<imeta>");
            xml.append(Str.escape(val));
            xml.append("</imeta>\n");
        }
        if ((val = src.getRemove()) != null && !val.equals(UNKNOWN) && !val.equals("")) {
            xml.append(tab1);
            xml.append("<rmeta>");
            xml.append(Str.escape(val));
            xml.append("</rmeta>\n");
        }
        if ((val = src.getLicenseContact()) != null && !val.equals(UNKNOWN) && !val.equals("")) {
            xml.append(tab1);
            xml.append("<slc>");
            xml.append(Str.escape(val));
            xml.append("</slc>\n");
        }
        if ((val = src.getContentContact()) != null && !val.equals(UNKNOWN) && !val.equals("")) {
            xml.append(tab1);
            xml.append("<scc>");
            xml.append(Str.escape(val));
            xml.append("</scc>\n");
        }
        xml.append(tab1);
        xml.append("<tfr>");
        xml.append(src.getTermFrequency());
        xml.append("</tfr>\n");
        xml.append(tab1);
        xml.append("<cfr>");
        xml.append(src.getCUIFrequency());
        xml.append("</cfr>\n");
        val = src.getContext();
        if (val != null && !val.equals(UNKNOWN) && !val.equals("")) {
            xml.append(tab1);
            xml.append("<cxty>");
            xml.append(Str.escape(val));
            xml.append("</cxty>\n");
        }
        if ((ttyl = src.getTermTypeList()) != null && ttyl.size() > 0) {
            xml.append(tab1);
            xml.append("<ttyl>");
            Iterator iter = ttyl.iterator();
            if (iter.hasNext()) {
                xml.append("\n");
            }
            while (iter.hasNext()) {
                xml.append(tab2);
                xml.append("<tty>");
                xml.append(Str.escape((String)iter.next()));
                xml.append("</tty>\n");
            }
            xml.append(tab1);
            xml.append("</ttyl>\n");
        }
        if ((atnl = src.getAttrNameList()) != null && atnl.size() > 0) {
            xml.append(tab1);
            xml.append("<atnl>");
            Iterator iter = atnl.iterator();
            if (iter.hasNext()) {
                xml.append("\n");
            }
            while (iter.hasNext()) {
                xml.append(tab2);
                xml.append("<atn>");
                xml.append(Str.escape((String)iter.next()));
                xml.append("</atn>\n");
            }
            xml.append(tab1);
            xml.append("</atnl>\n");
        }
        if ((val = src.getLanguage()) != null && !val.equals(UNKNOWN)) {
            xml.append(tab1);
            xml.append("<lat>");
            xml.append(Str.escape(val));
            xml.append("</lat>\n");
        }
        if ((val = src.getCharEncode()) != null && !val.equals(UNKNOWN)) {
            xml.append(tab1);
            xml.append("<cenc>");
            xml.append(Str.escape(val));
            xml.append("</cenc>\n");
        }
        if (src.getCurrentVersion()) {
            xml.append(tab1);
            xml.append("<curver/>\n");
        }
        if (src.getSabin()) {
            xml.append(tab1);
            xml.append("<sabin/>\n");
        }
        if ((val = src.getSCIT()) != null && !val.equals(UNKNOWN) && !val.equals("")) {
            xml.append(tab1);
            xml.append("<scit>");
            xml.append(Str.escape(val));
            xml.append("</scit>\n");
        }
        xml.append(tab0);
        xml.append("</sourceDef>\n");
    }

    public String xmlize() {
        StringBuffer buffer = new StringBuffer(2500);
        this.xmlize(buffer);
        return buffer.toString();
    }

    public void xmlize(StringBuffer xml) {
        Source.writeSource(xml, this);
    }

    private static void main(String[] args) {
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        if (out == null) {
            return this.doCompare(comp, out, false);
        }
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String str;
        if (!(c instanceof Source)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        Source comp = (Source)c;
        StringBuffer buf = new StringBuffer(2500);
        boolean ret = this.doCompare((KSComparable)comp, buf, equalsFlag);
        if (out != null && !(str = buf.toString().trim()).equals("")) {
            out.println(buf.toString().trim());
        }
        return ret;
    }

    private boolean doCompare(KSComparable c, StringBuffer buf, boolean equalsFlag) {
        if (!c.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        Source comp = (Source)c;
        boolean ret = true;
        ret = Source.compareVals(ret, buf, "VersionedCUI", this.vcui, comp.getVCUI());
        ret = Source.compareVals(ret, buf, "RootCUI", this.rcui, comp.getRCUI());
        String lsab = this.vsab;
        String csab = comp.getVSAB();
        if (!equalsFlag) {
            lsab = CompareUtil.logicalEquivSAB(lsab);
            csab = CompareUtil.logicalEquivSAB(csab);
        }
        ret = Source.compareVals(ret, buf, "VersionedSAB", lsab, csab);
        ret = Source.compareVals(ret, buf, "RootSAB", this.getRSAB(), comp.getRSAB());
        ret = Source.compareVals(ret, buf, "Name", this.getName(), comp.getName());
        ret = Source.compareVals(ret, buf, "NickName", this.getNickName(), comp.getNickName());
        ret = Source.compareVals(ret, buf, "Family", this.family, comp.getFamily());
        ret = Source.compareVals(ret, buf, "Version", this.version, comp.getVersion());
        ret = Source.compareVals(ret, buf, "MetaStart", this.mstart, comp.getMetaStart());
        ret = Source.compareVals(ret, buf, "MetaEnd", this.mend, comp.getMetaEnd());
        ret = Source.compareVals(ret, buf, "InsertVersion", this.imeta, comp.getInsert());
        ret = Source.compareVals(ret, buf, "RemoveVersion", this.rmeta, comp.getRemove());
        ret = Source.compareVals(ret, buf, "LicenseContact", this.slc, comp.getLicenseContact());
        ret = Source.compareVals(ret, buf, "ContentContact", this.scc, comp.getContentContact());
        if (this.tfr != comp.getTermFrequency()) {
            buf.append("this->TermFrequency");
            buf.append("='");
            buf.append(this.tfr);
            buf.append("' is different from '");
            buf.append(comp.getTermFrequency());
            buf.append("'\n");
            ret = false;
        }
        if (this.cfr != comp.getCUIFrequency()) {
            buf.append("this->CUIFrequency");
            buf.append("='");
            buf.append(this.cfr);
            buf.append("' is different from '");
            buf.append(comp.getCUIFrequency());
            buf.append("'\n");
            ret = false;
        }
        ret = Source.compareVals(ret, buf, "Context", this.cxty, comp.getContext());
        ret = Source.compareList(ret, buf, "TermTypeList", this.ttyl, comp.getTermTypeList());
        ret = Source.compareList(ret, buf, "AttributeNameList", this.atnl, comp.getAttrNameList());
        ret = Source.compareVals(ret, buf, "Language", this.lat, comp.getLanguage());
        ret = Source.compareVals(ret, buf, "CharEncode", this.cenc, comp.getCharEncode());
        if (equalsFlag) {
            if (this.curver != comp.getCurrentVersion()) {
                ret = false;
            }
            if (this.sabin != comp.getSabin()) {
                ret = false;
            }
            ret = Source.compareVals(ret, buf, "SourceCitation", this.scit, comp.getSCIT());
        }
        return ret;
    }

    private static boolean compareVals(boolean ret, StringBuffer buf, String fieldName, String thisVal, String compVal) {
        if (!Str.compareStr(thisVal, compVal)) {
            buf.append("this->");
            buf.append(fieldName);
            buf.append("='");
            buf.append(thisVal);
            buf.append("' is different from '");
            buf.append(compVal);
            buf.append("'\n");
            return false;
        }
        return ret;
    }

    private static boolean compareList(boolean ret, StringBuffer buf, String fieldName, Vector thisVal, Vector comp) {
        if (comp.size() != thisVal.size()) {
            if (buf != null) {
                buf.append("Vector sizes are different");
            }
            return false;
        }
        Hashtable compht = Source.convert(comp);
        Enumeration compkeys = compht.keys();
        Hashtable thisht = Source.convert(thisVal);
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            String exp = (String)thisht.get(compkey);
            if (exp == null) {
                if (buf != null) {
                    String missing = (String)compht.get(compkey);
                    buf.append("Release missing from this instance: ");
                    buf.append(missing);
                }
                return false;
            }
            String exp2 = (String)compht.get(compkey);
            if (!exp.equals(exp2)) {
                return false;
            }
            thisht.remove(compkey);
        }
        Enumeration thiskeys = thisht.keys();
        while (thiskeys.hasMoreElements()) {
            if (buf != null) {
                String newone = (String)thisht.get((String)thiskeys.nextElement());
                buf.append("Added to instance: ");
                buf.append(newone);
            }
            ret = false;
        }
        return ret;
    }

    private static Hashtable convert(Vector vector) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            String exp = (String)iter.next();
            table.put(exp, exp);
        }
        return table;
    }

    public String getKey() {
        return this.vsab + this.getSAB();
    }
}

