/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.source;

import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.meta.source.Source;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class SourceVector
extends KSVector {
    public static final String XmlName = "SourceListing";
    public static final String XmlStructure = "1.0";

    public SourceVector(Vector srcs) {
        super(srcs, XmlName, XmlStructure);
    }

    public SourceVector(SourceVector srcs) {
        super(srcs, XmlName, XmlStructure);
    }

    public SourceVector() {
        super(XmlName, XmlStructure);
    }

    public SourceVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        String childName = "sourceDef";
        List sources = root.getChildren(childName, namespace);
        if (sources == null || sources.size() == 0) {
            return;
        }
        int i = 0;
        while (i < sources.size()) {
            Element src = (Element)sources.get(i);
            Source source = new Source(src, namespace);
            if (source == null) {
                throw new XMLException("Invalid source definition");
            }
            this.add(source);
            ++i;
        }
    }

    public static SourceVector getInstance(String xml) {
        SourceVector aev = null;
        try {
            aev = new SourceVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.meta.source.SourceVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            SourceVector vec = SourceVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No sources read");
                return;
            }
            System.out.println("Number of sources: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                Source src = (Source)iter.next();
                System.out.println("SOURCE:-----------");
                out.println(src.xmlize());
                System.out.println("END:-----------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

