/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.sem.rels;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.KSObject;
import gov.nih.nlm.kss.models.sem.units.HierSemanticRelation;
import gov.nih.nlm.kss.models.sem.units.HierSemanticType;
import gov.nih.nlm.kss.util.XMLException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class AssociativeRelation
extends KSObject {
    private HierSemanticType lhs;
    private HierSemanticRelation relation;
    private HierSemanticType rhs;
    private int linkStatus;
    public static final String XmlName = "assocRelation";
    public static final String XmlStructure = "1.0";

    public AssociativeRelation() {
        super(XmlName, XmlStructure);
        this.lhs = null;
        this.rhs = null;
        this.relation = null;
        this.linkStatus = 0;
    }

    public AssociativeRelation(HierSemanticType lhs, HierSemanticRelation rel, HierSemanticType rhs, int ls) {
        super(XmlName, XmlStructure);
        this.lhs = null;
        this.rhs = null;
        this.relation = null;
        this.linkStatus = ls;
        if (ls != 0 && ls != 1 && ls != 2) {
            this.linkStatus = 0;
        }
    }

    public AssociativeRelation(Element root, Namespace namespace) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(root, namespace);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        super.parse(root, namespace);
        Element lhsChild = root.getChild("lhs", namespace);
        if (lhsChild == null) {
            throw new XMLException("No semantic triplet <lhs> found");
        }
        Element lhsstChild = lhsChild.getChild("semType", namespace);
        if (lhsstChild == null) {
            throw new XMLException("Invalid semantic triplet <lhs> found");
        }
        this.lhs = new HierSemanticType(lhsstChild, namespace);
        Element rhsChild = root.getChild("rhs", namespace);
        if (rhsChild == null) {
            throw new XMLException("No semantic triplet <rhs> found");
        }
        Element rhsstChild = rhsChild.getChild("semType", namespace);
        if (rhsstChild == null) {
            throw new XMLException("Invalid semantic triplet <rhs> found");
        }
        this.rhs = new HierSemanticType(rhsstChild, namespace);
        Element relChild = root.getChild("rel", namespace);
        if (relChild == null) {
            throw new XMLException("No semantic triplet <rel> found");
        }
        Element relsrChild = relChild.getChild("semRel", namespace);
        if (relsrChild == null) {
            throw new XMLException("Invalid semantic triplet <rel> found");
        }
        this.relation = new HierSemanticRelation(relsrChild, namespace);
        Element lsChild = root.getChild("defined", namespace);
        if (lsChild != null) {
            this.linkStatus = 0;
        } else {
            lsChild = root.getChild("blocked", namespace);
            if (lsChild != null) {
                this.linkStatus = 1;
            } else {
                lsChild = root.getChild("dni", namespace);
                if (lsChild != null) {
                    this.linkStatus = 2;
                } else {
                    throw new XMLException("No semantic triplet link status found");
                }
            }
        }
    }

    public static AssociativeRelation getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("assocRelation must be the name of the first element");
            }
            return new AssociativeRelation(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public HierSemanticType getLHS() {
        return this.lhs;
    }

    public void setLHS(HierSemanticType lhs) {
        this.lhs = lhs;
    }

    public HierSemanticType getRHS() {
        return this.rhs;
    }

    public void setRHS(HierSemanticType rhs) {
        this.rhs = rhs;
    }

    public HierSemanticRelation getRelation() {
        return this.relation;
    }

    public void setRelation(HierSemanticRelation rel) {
        this.relation = rel;
    }

    public int getLinkStatus() {
        return this.linkStatus;
    }

    public void setLinkStatus(int ls) {
        if (ls != 0 && ls != 1 && ls != 2) {
            ls = 0;
        }
        this.linkStatus = ls;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("");
        out.println("LHS Semantic Type:");
        this.lhs.output();
        out.println("Semantic Relation:");
        this.relation.output();
        out.println("RHS Semantic Type:");
        this.rhs.output();
        String ls = "Defined";
        switch (this.linkStatus) {
            case 1: {
                ls = "Blocked";
                break;
            }
            case 2: {
                ls = "DNI";
            }
        }
        out.println("Link Status: " + ls);
    }

    public String xmlize() {
        return this.xmlize(false);
    }

    public void writeContents(StringBuffer xml) {
        String tab0 = "      ";
        String tab = "         ";
        xml.append(tab);
        xml.append("<lhs>\n");
        if (this.lhs != null) {
            this.lhs.xmlize(xml, 2);
        }
        xml.append(tab);
        xml.append("</lhs>\n");
        xml.append(tab);
        xml.append("<rel>\n");
        if (this.relation != null) {
            this.relation.xmlize(xml, 2);
        }
        xml.append(tab);
        xml.append("</rel>\n");
        xml.append(tab);
        xml.append("<rhs>\n");
        if (this.rhs != null) {
            this.rhs.xmlize(xml, 2);
        }
        xml.append(tab);
        xml.append("</rhs>\n");
        xml.ensureCapacity(xml.length() + 100);
        String st = "<defined/>\n";
        switch (this.linkStatus) {
            case 1: {
                st = "<blocked/>\n";
                break;
            }
            case 2: {
                st = "<dni/>\n";
            }
        }
        xml.append(tab);
        xml.append(st);
    }

    protected boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof AssociativeRelation)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        boolean ret = super.doCompare(c, out, equalsFlag);
        if (!ret & this.performanceMode()) {
            return ret;
        }
        AssociativeRelation comp = (AssociativeRelation)c;
        HierSemanticType st = comp.getLHS();
        if (equalsFlag) {
            if (!this.lhs.equals(st)) {
                if (out != null) {
                    out.println("this->LHS= is different from the comparison instance");
                }
                ret = false;
            }
        } else if (!this.lhs.equivalent(st)) {
            if (out != null) {
                out.println("this->LHS= is different from the comparison instance");
            }
            ret = false;
        }
        st = comp.getRHS();
        if (equalsFlag) {
            if (!this.rhs.equals(st)) {
                if (out != null) {
                    out.println("this->RHS= is different from the comparison instance");
                }
                ret = false;
            }
        } else if (!this.rhs.equivalent(st)) {
            if (out != null) {
                out.println("this->RHS= is different from the comparison instance");
            }
            ret = false;
        }
        HierSemanticRelation rel = comp.getRelation();
        if (equalsFlag) {
            if (!this.relation.equals(rel)) {
                if (out != null) {
                    out.println("this->Relation= is different from the comparison instance");
                }
                ret = false;
            }
        } else if (!this.relation.equivalent(rel)) {
            if (out != null) {
                out.println("this->Relation= is different from the comparison instance");
            }
            ret = false;
        }
        if (this.linkStatus != comp.getLinkStatus()) {
            if (out != null) {
                out.println("this->LinkStatus='" + this.linkStatus + "' is different from '" + comp.getLinkStatus() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.lhs.getKey() + "-" + this.relation.getKey() + "-" + this.rhs.getKey();
    }
}

