/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.sem.rels;

import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.sem.rels.AssociativeRelation;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class AssociativeRelationVector
extends KSVector {
    public static final String XmlName = "AssociativeRelationCollection";
    public static final String XmlStructure = "1.0";

    public AssociativeRelationVector(Vector rels) {
        super(rels, XmlName, XmlStructure);
    }

    public AssociativeRelationVector(AssociativeRelationVector rels) {
        super(rels, XmlName, XmlStructure);
    }

    public AssociativeRelationVector() {
        super(XmlName, XmlStructure);
    }

    public AssociativeRelationVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        String childName = "assocRelation";
        List triplets = root.getChildren(childName, namespace);
        if (triplets == null || triplets.size() == 0) {
            return;
        }
        int i = 0;
        while (i < triplets.size()) {
            Element rel = (Element)triplets.get(i);
            AssociativeRelation relation = new AssociativeRelation(rel, namespace);
            if (relation == null) {
                throw new XMLException("Invalid relation definition");
            }
            this.add(relation);
            ++i;
        }
    }

    public static AssociativeRelationVector getInstance(String xml) {
        AssociativeRelationVector aev = null;
        try {
            aev = new AssociativeRelationVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    public String xmlize(String release) {
        String oldRel = this.getRelease();
        this.setRelease(release);
        String xml = this.xmlize();
        this.setRelease(oldRel);
        return xml;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.sem.rels.AssociativeRelationVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            AssociativeRelationVector vec = AssociativeRelationVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No triplets read");
                return;
            }
            System.out.println("Number of triplets: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                AssociativeRelation relation = (AssociativeRelation)iter.next();
                System.out.println("AssociativeRelation----------------");
                relation.output();
                System.out.println("AssociativeRelation END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize(vec.getRelease()));
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

