/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.sem.units;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.sem.units.HierSemanticRelationVector;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class HierSemanticRelation
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private boolean expanded;
    private String name;
    private String ui;
    private String treeNum;
    private String definition;
    private String abbrev;
    private boolean nonInheritable;
    private String inverse;
    private String parentUI;
    private HierSemanticRelationVector children;
    private Vector childrenUIs;
    public static final String XmlName = "semRel";

    public HierSemanticRelation() {
        this.name = "";
        this.ui = "";
        this.abbrev = "";
        this.treeNum = "";
        this.definition = "";
        this.nonInheritable = false;
        this.inverse = "";
        this.parentUI = "";
        this.children = null;
        this.childrenUIs = null;
        this.expanded = false;
    }

    public HierSemanticRelation(Element relation, Namespace namespace) throws XMLException {
        List uis;
        Element childrenEle;
        Element parentUIChild;
        Element inhChild;
        Element defChild;
        Element treeNumChild;
        Element nameChild = relation.getChild("name", namespace);
        if (nameChild == null) {
            throw new XMLException("No relation <name> found");
        }
        this.name = XMLInterpreter.extractString(nameChild);
        Element uiChild = relation.getChild("ui", namespace);
        if (uiChild == null) {
            throw new XMLException("No relation <ui> found");
        }
        this.ui = XMLInterpreter.extractString(uiChild);
        Element abbrevChild = relation.getChild("abbrev", namespace);
        if (abbrevChild != null) {
            this.abbrev = XMLInterpreter.extractString(abbrevChild);
        }
        if ((treeNumChild = relation.getChild("treeNum", namespace)) != null) {
            this.treeNum = XMLInterpreter.extractString(treeNumChild);
        }
        if ((defChild = relation.getChild("def", namespace)) != null) {
            this.definition = XMLInterpreter.extractString(defChild);
        }
        this.nonInheritable = (inhChild = relation.getChild("nonInheritable", namespace)) != null;
        Element inverseChild = relation.getChild("inverse", namespace);
        if (inverseChild != null) {
            this.inverse = XMLInterpreter.extractString(inverseChild);
        }
        if ((parentUIChild = relation.getChild("parentUI", namespace)) != null) {
            this.parentUI = XMLInterpreter.extractString(parentUIChild);
        }
        if ((childrenEle = relation.getChild("children", namespace)) == null) {
            return;
        }
        String childName = XmlName;
        this.expanded = false;
        List ids = childrenEle.getChildren(childName, namespace);
        if ((ids == null || ids.size() == 0) && (uis = childrenEle.getChildren("ui", namespace)) != null && uis.size() != 0) {
            this.children = null;
            this.childrenUIs = new Vector();
            int j = 0;
            while (j < uis.size()) {
                Element uiEle = (Element)uis.get(j);
                String ui = XMLInterpreter.extractString(uiEle);
                this.childrenUIs.add(ui);
                ++j;
            }
            return;
        }
        this.children = new HierSemanticRelationVector();
        int i = 0;
        while (i < ids.size()) {
            Element idEle = (Element)ids.get(i);
            HierSemanticRelation id = new HierSemanticRelation(idEle, namespace);
            if (id == null) {
                throw new XMLException("Invalid semantic relation definition");
            }
            this.children.add(id);
            ++i;
        }
        this.expanded = true;
    }

    public static HierSemanticRelation getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("semRel must be the name of the first element");
            }
            return new HierSemanticRelation(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public boolean getExpanded() {
        return this.expanded;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUI() {
        return this.ui;
    }

    public void setUI(String ui) {
        this.ui = ui;
    }

    public String getAbbrev() {
        return this.abbrev;
    }

    public void setAbbrev(String abbrev) {
        this.abbrev = abbrev;
    }

    public String getTreeNum() {
        return this.treeNum;
    }

    public void setTreeNum(String treeNum) {
        this.treeNum = treeNum;
    }

    public String getDef() {
        return this.definition;
    }

    public void setDef(String definition) {
        this.definition = definition;
    }

    public boolean getNonInheritable() {
        return this.nonInheritable;
    }

    public void setNonInheritable(boolean nonInheritable) {
        this.nonInheritable = nonInheritable;
    }

    public String getInverse() {
        return this.inverse;
    }

    public void setInverse(String inverse) {
        this.inverse = inverse;
    }

    public String getParentUI() {
        return this.parentUI;
    }

    public void setParentUI(String parentUI) {
        this.parentUI = parentUI;
    }

    public HierSemanticRelationVector getChildren() {
        return this.children;
    }

    public void setChildren(HierSemanticRelationVector children) {
        this.children = children;
        if (children != null) {
            this.expanded = true;
        }
    }

    public Vector getChildrenUIs() {
        if (this.children != null) {
            this.childrenUIs.clear();
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                this.childrenUIs.add((String)iter.next());
            }
        }
        return this.childrenUIs;
    }

    public void setChildrenUIs(Vector childrenUIs) {
        if (this.children == null) {
            this.childrenUIs = new Vector();
            Iterator iter = childrenUIs.iterator();
            while (iter.hasNext()) {
                this.childrenUIs.add(iter.next());
            }
        }
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            out = new PrintStream(System.out);
        }
        out.println("");
        out.println("Semantic Relation:      " + this.name);
        out.println("  UI:               " + this.ui);
        out.println("  Abbreviation:     " + this.abbrev);
        out.println("  TreeNum:          " + this.treeNum);
        out.println("  Definition:       " + this.definition);
        out.println("  Non-inheritable:  " + this.nonInheritable);
        out.println("  Inverse Rel Name: " + this.inverse);
        out.println("  Parent UI:        " + this.parentUI);
        if (this.children != null) {
            out.println("  Children:         ");
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                ((HierSemanticRelation)iter.next()).output();
            }
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(1000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        this.xmlize(xml, 0);
    }

    public void xmlize(StringBuffer xml, int indentLevel) {
        Iterator iter;
        String tab0 = "      ";
        String tab = "         ";
        int i = 0;
        while (i < indentLevel) {
            tab0 = tab0 + "    ";
            tab = tab + "    ";
            ++i;
        }
        xml.ensureCapacity(xml.length() + 100);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.ensureCapacity(xml.length() + this.name.length() + 15);
        String mname = this.name;
        if (mname == null) {
            mname = "";
        }
        xml.append(tab);
        xml.append("<name>");
        xml.append(Str.escape(mname));
        xml.append("</name>\n");
        xml.ensureCapacity(xml.length() + this.ui.length() + 15);
        String mui = this.ui;
        if (mui == null) {
            mui = "";
        }
        xml.append(tab);
        xml.append("<ui>");
        xml.append(mui);
        xml.append("</ui>\n");
        if (this.abbrev != null && !this.abbrev.equals("")) {
            xml.ensureCapacity(xml.length() + this.abbrev.length() + 20);
            String mabbrev = this.abbrev;
            if (mabbrev == null) {
                mabbrev = "";
            }
            xml.append(tab);
            xml.append("<abbrev>");
            xml.append(mabbrev);
            xml.append("</abbrev>\n");
        }
        if (this.treeNum != null && !this.treeNum.equals("")) {
            xml.ensureCapacity(xml.length() + this.treeNum.length() + 15);
            String mtreeNum = this.treeNum;
            if (mtreeNum == null) {
                mtreeNum = "";
            }
            xml.append(tab);
            xml.append("<treeNum>");
            xml.append(mtreeNum);
            xml.append("</treeNum>\n");
        }
        if (this.definition != null && !this.definition.equals("")) {
            xml.ensureCapacity(xml.length() + this.definition.length() + 15);
            String mdef = this.definition;
            if (mdef == null) {
                mdef = "";
            }
            xml.append(tab);
            xml.append("<def>");
            xml.append(Str.escape(mdef));
            xml.append("</def>\n");
        }
        xml.ensureCapacity(xml.length() + 20);
        if (this.nonInheritable) {
            xml.append(tab);
            xml.append("<nonInheritable/>\n");
        }
        if (this.inverse != null && !this.inverse.equals("")) {
            xml.ensureCapacity(xml.length() + this.inverse.length() + 20);
            String minverse = this.inverse;
            if (minverse == null) {
                minverse = "";
            }
            xml.append(tab);
            xml.append("<inverse>");
            xml.append(Str.escape(minverse));
            xml.append("</inverse>\n");
        }
        if (this.parentUI != null && !this.parentUI.equals("")) {
            xml.ensureCapacity(xml.length() + this.parentUI.length() + 20);
            String mparentUI = this.parentUI;
            if (mparentUI == null) {
                mparentUI = "";
            }
            xml.append(tab);
            xml.append("<parentUI>");
            xml.append(mparentUI);
            xml.append("</parentUI>\n");
        }
        if (this.children != null) {
            xml.ensureCapacity(xml.length() + this.parentUI.length() + 20);
            xml.append(tab);
            xml.append("<children>\n");
            iter = this.children.iterator();
            while (iter.hasNext()) {
                ((HierSemanticRelation)iter.next()).xmlize(xml, indentLevel + 1);
            }
            xml.ensureCapacity(xml.length() + this.parentUI.length() + 20);
            xml.append(tab);
            xml.append("</children>\n");
        } else if (this.childrenUIs != null) {
            xml.ensureCapacity(xml.length() + this.parentUI.length() + 20);
            xml.append(tab);
            xml.append("<children>\n");
            iter = this.childrenUIs.iterator();
            xml.ensureCapacity(xml.length() + 30 * this.childrenUIs.size());
            while (iter.hasNext()) {
                xml.append(tab);
                xml.append("   <ui>");
                xml.append((String)iter.next());
                xml.append("</ui>\n");
            }
            xml.ensureCapacity(xml.length() + this.parentUI.length() + 20);
            xml.append(tab);
            xml.append("</children>\n");
        }
        xml.ensureCapacity(xml.length() + this.parentUI.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String parentUI;
        String inverse;
        String definition;
        String treeNum;
        String abbrev;
        String ui;
        if (!(c instanceof HierSemanticRelation)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        HierSemanticRelation comp = (HierSemanticRelation)c;
        boolean ret = true;
        String name = this.getName();
        if (!Str.compareStr(name, comp.getName())) {
            if (out != null) {
                out.println("this->Name='" + name + "' is different from '" + comp.getName() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(ui = this.getUI(), comp.getUI())) {
            if (out != null) {
                out.println("this->UI='" + ui + "' is different from '" + comp.getUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(abbrev = this.getAbbrev(), comp.getAbbrev())) {
            if (out != null) {
                out.println("this->Abbrev='" + abbrev + "' is different from '" + comp.getAbbrev() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(treeNum = this.getTreeNum(), comp.getTreeNum())) {
            if (out != null) {
                out.println("this->TreeNum='" + treeNum + "' is different from '" + comp.getTreeNum() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(definition = this.getDef(), comp.getDef())) {
            if (out != null) {
                out.println("this->Def='" + definition + "' is different from '" + comp.getDef() + "'");
            }
            ret = false;
        }
        if (this.nonInheritable != comp.getNonInheritable()) {
            if (out != null) {
                out.println("this->nonInheritable='" + this.nonInheritable + "' is different from '" + comp.getNonInheritable() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(inverse = this.getInverse(), comp.getInverse())) {
            if (out != null) {
                out.println("this->Inverse='" + inverse + "' is different from '" + comp.getInverse() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(parentUI = this.getParentUI(), comp.getParentUI())) {
            if (out != null) {
                out.println("this->ParentUI='" + parentUI + "' is different from '" + comp.getParentUI() + "'");
            }
            ret = false;
        }
        HierSemanticRelationVector cchildren = comp.getChildren();
        if (this.children != null && cchildren == null || this.children == null && cchildren != null) {
            return false;
        }
        if (this.children == null && cchildren == null) {
            if (ret) {
                return true;
            }
            return ret;
        }
        if (equalsFlag) {
            if (!this.children.equals(cchildren)) {
                ret = false;
            }
        } else if (!this.children.equivalent(cchildren)) {
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.ui;
    }
}

