/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.sem.units;

import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.sem.units.SemNetId;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class SemNetIdVector
extends KSVector {
    public static final String XmlName = "SemNetIdCollection";
    public static final String XmlStructure = "1.0";

    public SemNetIdVector(Vector ids) {
        super(ids, XmlName, XmlStructure);
    }

    public SemNetIdVector(SemNetIdVector ids) {
        super(ids, XmlName, XmlStructure);
    }

    public SemNetIdVector() {
        super(XmlName, XmlStructure);
    }

    public SemNetIdVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        String childName = "semnetId";
        List types = root.getChildren(childName, namespace);
        if (types == null || types.size() == 0) {
            return;
        }
        int i = 0;
        while (i < types.size()) {
            Element id = (Element)types.get(i);
            SemNetId semnetid = new SemNetId(id, namespace);
            if (semnetid == null) {
                throw new XMLException("Invalid semantic network id definition");
            }
            this.add(semnetid);
            ++i;
        }
    }

    public static SemNetIdVector getInstance(String xml) {
        SemNetIdVector aev = null;
        try {
            aev = new SemNetIdVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    public String xmlize(String release) {
        String oldRel = this.getRelease();
        this.setRelease(release);
        String xml = this.xmlize();
        this.setRelease(oldRel);
        return xml;
    }

    public void output() {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            SemNetId id = (SemNetId)iter.next();
            id.output();
            System.out.println();
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.sem.units.SemNetIdVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            SemNetIdVector vec = SemNetIdVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No semantic types read");
                return;
            }
            System.out.println("Number of identifiers: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                SemNetId id = (SemNetId)iter.next();
                System.out.println("SemNetId----------------");
                id.output();
                System.out.println("SemNetId END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize(vec.getRelease()));
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

