/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.jdom.Element;
import org.jdom.Namespace;

public abstract class Executor {
    protected String kssServerName;
    protected KSSRetrieverV5_0 retriever;

    public Executor() {
        this.kssServerName = "";
        this.retriever = null;
    }

    public Executor(String kssServerName) throws DatabaseException {
        this.kssServerName = kssServerName;
        try {
            this.retriever = (KSSRetrieverV5_0)Naming.lookup(kssServerName);
        }
        catch (RemoteException ex) {
            System.err.println("RemoteException: " + ex.getMessage());
            throw new DatabaseException("Unable to connect: " + ex.getMessage());
        }
        catch (NotBoundException ex) {
            System.err.println("NotBoundException: " + ex.getMessage());
            throw new DatabaseException("Unable to connect: " + ex.getMessage());
        }
        catch (MalformedURLException ex) {
            System.err.println("MalformedURLException: " + ex.getMessage());
            throw new DatabaseException("Unable to connect: " + ex.getMessage());
        }
    }

    public Executor(KSSRetrieverV5_0 server) {
        this.retriever = server;
    }

    public void setServer(KSSRetrieverV5_0 server) {
        this.retriever = server;
    }

    public void setServerName(String kssServerName) throws DatabaseException {
        this.kssServerName = kssServerName;
        try {
            this.retriever = (KSSRetrieverV5_0)Naming.lookup(kssServerName);
        }
        catch (RemoteException ex) {
            System.err.println("RemoteException: " + ex.getMessage());
            throw new DatabaseException("Unable to connect: " + ex.getMessage());
        }
        catch (NotBoundException ex) {
            System.err.println("NotBoundException: " + ex.getMessage());
            throw new DatabaseException("Unable to connect: " + ex.getMessage());
        }
        catch (MalformedURLException ex) {
            System.err.println("MalformedURLException: " + ex.getMessage());
            throw new DatabaseException("Unable to connect: " + ex.getMessage());
        }
    }

    public abstract char[] request(Element var1, Namespace var2) throws XMLException, DatabaseException;
}

