/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.Executor;
import gov.nih.nlm.kss.query.lex.LexicalRecordsExecutor;
import gov.nih.nlm.kss.query.meta.AssocExprsExecutor;
import gov.nih.nlm.kss.query.meta.BasicConceptPropsExecutor;
import gov.nih.nlm.kss.query.meta.CUIExecutor;
import gov.nih.nlm.kss.query.meta.ConceptAttrsExecutor;
import gov.nih.nlm.kss.query.meta.ConceptNameExecutor;
import gov.nih.nlm.kss.query.meta.ConceptPropsExecutor;
import gov.nih.nlm.kss.query.meta.ContextExecutor;
import gov.nih.nlm.kss.query.meta.CooccurrencesExecutor;
import gov.nih.nlm.kss.query.meta.DefinitionExecutor;
import gov.nih.nlm.kss.query.meta.DescribeCurrentExecutor;
import gov.nih.nlm.kss.query.meta.DescribeSrcExecutor;
import gov.nih.nlm.kss.query.meta.DescribeVersionsExecutor;
import gov.nih.nlm.kss.query.meta.FindBasicConceptExecutor;
import gov.nih.nlm.kss.query.meta.FindConceptExecutor;
import gov.nih.nlm.kss.query.meta.GetAUIDetailsExecutor;
import gov.nih.nlm.kss.query.meta.LUIExecutor;
import gov.nih.nlm.kss.query.meta.ListCooccurrenceTypesExecutor;
import gov.nih.nlm.kss.query.meta.ListDictsExecutor;
import gov.nih.nlm.kss.query.meta.ListDocEntryTypesExecutor;
import gov.nih.nlm.kss.query.meta.ListMeSHQualsExecutor;
import gov.nih.nlm.kss.query.meta.ListMetaTableNamesExecutor;
import gov.nih.nlm.kss.query.meta.ListRelationTypesExecutor;
import gov.nih.nlm.kss.query.meta.ListSrcExecutor;
import gov.nih.nlm.kss.query.meta.ListStrAttrsExecutor;
import gov.nih.nlm.kss.query.meta.ListStringTypesExecutor;
import gov.nih.nlm.kss.query.meta.ListTermTypesExecutor;
import gov.nih.nlm.kss.query.meta.LocatorExecutor;
import gov.nih.nlm.kss.query.meta.MeSHEntriesExecutor;
import gov.nih.nlm.kss.query.meta.MeSHInfoExecutor;
import gov.nih.nlm.kss.query.meta.RawRecordsExecutor;
import gov.nih.nlm.kss.query.meta.RelationsExecutor;
import gov.nih.nlm.kss.query.meta.RelationshipAttrsExecutor;
import gov.nih.nlm.kss.query.meta.SUIExecutor;
import gov.nih.nlm.kss.query.meta.SemTypeExecutor;
import gov.nih.nlm.kss.query.meta.SoftwareExecutor;
import gov.nih.nlm.kss.query.meta.SpellingExecutor;
import gov.nih.nlm.kss.query.meta.StringAttrsExecutor;
import gov.nih.nlm.kss.query.meta.StringsForSUIExecutor;
import gov.nih.nlm.kss.query.meta.TerminologyExecutor;
import gov.nih.nlm.kss.query.meta.TermsExecutor;
import gov.nih.nlm.kss.query.meta.TermsForLUIExecutor;
import gov.nih.nlm.kss.query.meta.UMLSReleaseChangesExecutor;
import gov.nih.nlm.kss.query.meta.UMLSVersionExecutor;
import gov.nih.nlm.kss.query.meta.UMLSVersionsExecutor;
import gov.nih.nlm.kss.query.sem.ExistsAssocRelExecutor;
import gov.nih.nlm.kss.query.sem.ExistsHierRelExecutor;
import gov.nih.nlm.kss.query.sem.FindBasicSemRelExecutor;
import gov.nih.nlm.kss.query.sem.FindBasicSemTypeExecutor;
import gov.nih.nlm.kss.query.sem.FindSemRelExecutor;
import gov.nih.nlm.kss.query.sem.FindSemTypeExecutor;
import gov.nih.nlm.kss.query.sem.GetAssocRelExecutor;
import gov.nih.nlm.kss.query.sem.GetBasicAssocRelExecutor;
import gov.nih.nlm.kss.query.sem.ListSemGroupsExecutor;
import gov.nih.nlm.kss.query.sem.ListSemNetTableNamesExecutor;
import gov.nih.nlm.kss.query.sem.ListSemRelIdsExecutor;
import gov.nih.nlm.kss.query.sem.ListSemTypeForGroupExecutor;
import gov.nih.nlm.kss.query.sem.ListSemTypeIdsExecutor;
import gov.nih.nlm.kss.query.sem.SemGroupExecutor;
import gov.nih.nlm.kss.query.sem.SemNetASCIIExecutor;
import gov.nih.nlm.kss.query.sem.SemRelAncsExecutor;
import gov.nih.nlm.kss.query.sem.SemRelPropsExecutor;
import gov.nih.nlm.kss.query.sem.SemTypeAncsExecutor;
import gov.nih.nlm.kss.query.sem.SemTypePropsExecutor;
import gov.nih.nlm.kss.query.sem.SemTypeSibsExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.rmi.Naming;
import java.rmi.RemoteException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class StandardQueryExecutor {
    private String kssServerName;
    private KSSRetrieverV5_0 retriever;
    private KSSRetrieverV5_0 queryRetriever;
    private static final int CURRENT_UMLS_VERSION = 1;
    private static final int UMLS_VERSIONS = 2;
    private static final int SOFTWARE_VERSION = 3;
    private static final int CONCEPT_NAME = 4;
    private static final int FIND_CUI = 5;
    private static final int CONCEPT_PROPERTIES = 6;
    private static final int FIND_CONCEPT = 7;
    private static final int BASIC_PROPERTIES = 8;
    private static final int FIND_BASIC = 9;
    private static final int TERMINOLOGY = 10;
    private static final int TERMS = 11;
    private static final int DEFINITION = 14;
    private static final int SEMANTIC_TYPE = 15;
    private static final int CONTEXT = 16;
    private static final int ASSOC_EXPRS = 17;
    private static final int COOCCURRENCES = 18;
    private static final int RELATIONS = 19;
    private static final int STRING_ATTRIBUTES = 20;
    private static final int LOCATOR = 21;
    private static final int MESH_ENTRIES = 22;
    private static final int MESH_INFO = 23;
    private static final int RAW_RECORDS = 24;
    private static final int DESCRIBE_SOURCE = 25;
    private static final int LIST_SOURCES = 26;
    private static final int QUERY = 27;
    private static final int LIST_MESH_QUALS = 28;
    private static final int LIST_STR_ATTRS = 29;
    private static final int LUI = 30;
    private static final int TERMS_FOR_LUI = 31;
    private static final int SUI = 32;
    private static final int STRINGS_FOR_SUI = 33;
    private static final int LIST_TERM_TYPES = 34;
    private static final int SPELLING = 35;
    private static final int LIST_DICTIONARIES = 36;
    private static final int DESCRIBE_CHANGES = 37;
    private static final int LIST_COOCCURRENCE_TYPES = 38;
    private static final int LIST_RELATION_TYPES = 39;
    private static final int LIST_STRING_TYPES = 40;
    private static final int DESCRIBE_CURRENT_UMLS_VERSION = 41;
    private static final int DESCRIBE_UMLS_VERSIONS = 42;
    private static final int FIND_SEMTYPE = 43;
    private static final int GET_SEMTYPE_PROPS = 44;
    private static final int GET_SEMTYPE_ANCS = 45;
    private static final int GET_SEMTYPE_SIBS = 46;
    private static final int LIST_SEMTYPE_IDS = 47;
    private static final int FIND_SEMREL = 48;
    private static final int GET_SEMREL_PROPS = 49;
    private static final int GET_SEMREL_ANCS = 50;
    private static final int LIST_SEMREL_IDS = 51;
    private static final int EXISTS_ASSOC_REL = 52;
    private static final int GET_ASSOC_REL = 53;
    private static final int EXISTS_HIER_REL = 54;
    private static final int LIST_SEM_GROUPS = 55;
    private static final int LIST_SEMTYPES_FOR_GROUP = 56;
    private static final int GET_SEMNET_ASCII = 57;
    private static final int GET_SEM_GROUP = 58;
    private static final int BASIC_ASSOCIATIVE_RELATIONS = 59;
    private static final int FIND_BASIC_SEM_RELATION = 60;
    private static final int FIND_BASIC_SEM_TYPE = 61;
    private static final int GET_LEXICAL_RECORDS = 62;
    private static final int LIST_META_TABLE_NAMES = 63;
    private static final int LIST_SEMNET_TABLE_NAMES = 64;
    private static final int LIST_DOC_ENTRY_TYPES = 65;
    private static final int GET_AUI_STRING = 66;
    private static final int CONCEPT_ATTRIBUTES = 67;
    private static final int RELATIONSHIP_ATTRIBUTES = 68;

    public StandardQueryExecutor() {
    }

    public StandardQueryExecutor(String serverName) {
        this.kssServerName = serverName;
        this.retriever = null;
    }

    public StandardQueryExecutor(KSSRetrieverV5_0 server) {
        this.retriever = server;
    }

    private int determineRoot(Element root, Namespace namespace) throws XMLException {
        if (root.getName().equals("getCurrentUMLSVersion")) {
            return 1;
        }
        if (root.getName().equals("getUMLSVersions")) {
            return 2;
        }
        if (root.getName().equals("getSWVersion")) {
            return 3;
        }
        if (root.getName().equals("getConceptName")) {
            return 4;
        }
        if (root.getName().equals("findCUI")) {
            return 5;
        }
        if (root.getName().equals("getConceptProperties")) {
            return 6;
        }
        if (root.getName().equals("findConcept")) {
            return 7;
        }
        if (root.getName().equals("getBasicConceptProperties")) {
            return 8;
        }
        if (root.getName().equals("findBasicConcept")) {
            return 9;
        }
        if (root.getName().equals("getTerminology")) {
            return 10;
        }
        if (root.getName().equals("getTerms") || root.getName().equals("findTerms")) {
            return 11;
        }
        if (root.getName().equals("getDefinition")) {
            return 14;
        }
        if (root.getName().equals("getSemanticType")) {
            return 15;
        }
        if (root.getName().equals("getContext")) {
            return 16;
        }
        if (root.getName().equals("getAssocExprs")) {
            return 17;
        }
        if (root.getName().equals("getCooccurrences")) {
            return 18;
        }
        if (root.getName().equals("getRelations")) {
            return 19;
        }
        if (root.getName().equals("getStringAttributes")) {
            return 20;
        }
        if (root.getName().equals("getLocator") || root.getName().equals("getLocators")) {
            return 21;
        }
        if (root.getName().equals("getMeSHEntries")) {
            return 22;
        }
        if (root.getName().equals("getMeSHInfo")) {
            return 23;
        }
        if (root.getName().equals("getRawRecords")) {
            return 24;
        }
        if (root.getName().equals("describeSource")) {
            return 25;
        }
        if (root.getName().equals("listSources")) {
            return 26;
        }
        if (root.getName().equals("query")) {
            return 27;
        }
        if (root.getName().equals("listMeSHQuals")) {
            return 28;
        }
        if (root.getName().equals("listStrAttrs")) {
            return 29;
        }
        if (root.getName().equals("findLUI")) {
            return 30;
        }
        if (root.getName().equals("getTermsForLUI")) {
            return 31;
        }
        if (root.getName().equals("findSUI")) {
            return 32;
        }
        if (root.getName().equals("getStringsForSUI")) {
            return 33;
        }
        if (root.getName().equals("listTermTypes")) {
            return 34;
        }
        if (root.getName().equals("suggestSpelling")) {
            return 35;
        }
        if (root.getName().equals("listDictionaries")) {
            return 36;
        }
        if (root.getName().equals("describeUMLSChanges")) {
            return 37;
        }
        if (root.getName().equals("listCooccurrenceTypes")) {
            return 38;
        }
        if (root.getName().equals("listRelationTypes")) {
            return 39;
        }
        if (root.getName().equals("listStringTypes")) {
            return 40;
        }
        if (root.getName().equals("describeCurrentUMLSVersion")) {
            return 41;
        }
        if (root.getName().equals("describeUMLSVersions")) {
            return 42;
        }
        if (root.getName().equals("findSemType")) {
            return 43;
        }
        if (root.getName().equals("getSemTypeProperties")) {
            return 44;
        }
        if (root.getName().equals("getSemTypeAncestors")) {
            return 45;
        }
        if (root.getName().equals("getSemTypeSiblings")) {
            return 46;
        }
        if (root.getName().equals("listSemTypeIds")) {
            return 47;
        }
        if (root.getName().equals("findSemRelation")) {
            return 48;
        }
        if (root.getName().equals("getSemRelationProperties")) {
            return 49;
        }
        if (root.getName().equals("getSemRelationAncestors")) {
            return 50;
        }
        if (root.getName().equals("listSemRelationIds")) {
            return 51;
        }
        if (root.getName().equals("existsAssociativeRelation")) {
            return 52;
        }
        if (root.getName().equals("getAssociativeRelations")) {
            return 53;
        }
        if (root.getName().equals("existsHierRelRelation")) {
            return 54;
        }
        if (root.getName().equals("listSemGroups")) {
            return 55;
        }
        if (root.getName().equals("listSemTypes")) {
            return 56;
        }
        if (root.getName().equals("getSemNetASCIIRecords")) {
            return 57;
        }
        if (root.getName().equals("getSemGroup")) {
            return 58;
        }
        if (root.getName().equals("listMetaTableNames")) {
            return 63;
        }
        if (root.getName().equals("listSemNetTableNames")) {
            return 64;
        }
        if (root.getName().equals("findBasicSemType")) {
            return 61;
        }
        if (root.getName().equals("findBasicSemRelation")) {
            return 60;
        }
        if (root.getName().equals("getBasicAssociativeRelations")) {
            return 59;
        }
        if (root.getName().equals("getLexicalRecords")) {
            return 62;
        }
        if (root.getName().equals("listDocEntryTypes")) {
            return 65;
        }
        if (root.getName().equals("getAUIDetails")) {
            return 66;
        }
        if (root.getName().equals("getConceptAttributes")) {
            return 67;
        }
        if (root.getName().equals("getRelationshipAttributes")) {
            return 68;
        }
        return -1;
    }

    private char[] buildAPI(Element root, Namespace namespace) throws XMLException, DatabaseException {
        Executor executor;
        block137: {
            int cmdOpt = this.determineRoot(root, namespace);
            executor = null;
            try {
                if (this.retriever == null) {
                    switch (cmdOpt) {
                        case 1: {
                            executor = new UMLSVersionExecutor(this.kssServerName);
                            break block137;
                        }
                        case 2: {
                            executor = new UMLSVersionsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 3: {
                            executor = new SoftwareExecutor(this.kssServerName);
                            break block137;
                        }
                        case 4: {
                            executor = new ConceptNameExecutor(this.kssServerName);
                            break block137;
                        }
                        case 5: {
                            executor = new CUIExecutor(this.kssServerName);
                            break block137;
                        }
                        case 6: {
                            executor = new ConceptPropsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 7: {
                            executor = new FindConceptExecutor(this.kssServerName);
                            break block137;
                        }
                        case 8: {
                            executor = new BasicConceptPropsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 9: {
                            executor = new FindBasicConceptExecutor(this.kssServerName);
                            break block137;
                        }
                        case 10: {
                            executor = new TerminologyExecutor(this.kssServerName);
                            break block137;
                        }
                        case 11: {
                            executor = new TermsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 14: {
                            executor = new DefinitionExecutor(this.kssServerName);
                            break block137;
                        }
                        case 15: {
                            executor = new SemTypeExecutor(this.kssServerName);
                            break block137;
                        }
                        case 16: {
                            executor = new ContextExecutor(this.kssServerName);
                            break block137;
                        }
                        case 17: {
                            executor = new AssocExprsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 18: {
                            executor = new CooccurrencesExecutor(this.kssServerName);
                            break block137;
                        }
                        case 19: {
                            executor = new RelationsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 20: {
                            executor = new StringAttrsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 21: {
                            executor = new LocatorExecutor(this.kssServerName);
                            break block137;
                        }
                        case 22: {
                            executor = new MeSHEntriesExecutor(this.kssServerName);
                            break block137;
                        }
                        case 23: {
                            executor = new MeSHInfoExecutor(this.kssServerName);
                            break block137;
                        }
                        case 24: {
                            executor = new RawRecordsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 25: {
                            executor = new DescribeSrcExecutor(this.kssServerName);
                            break block137;
                        }
                        case 26: {
                            executor = new ListSrcExecutor(this.kssServerName);
                            break block137;
                        }
                        case 28: {
                            executor = new ListMeSHQualsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 29: {
                            executor = new ListStrAttrsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 30: {
                            executor = new LUIExecutor(this.kssServerName);
                            break block137;
                        }
                        case 31: {
                            executor = new TermsForLUIExecutor(this.kssServerName);
                            break block137;
                        }
                        case 32: {
                            executor = new SUIExecutor(this.kssServerName);
                            break block137;
                        }
                        case 33: {
                            executor = new StringsForSUIExecutor(this.kssServerName);
                            break block137;
                        }
                        case 34: {
                            executor = new ListTermTypesExecutor(this.kssServerName);
                            break block137;
                        }
                        case 35: {
                            executor = new SpellingExecutor(this.kssServerName);
                            break block137;
                        }
                        case 36: {
                            executor = new ListDictsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 37: {
                            executor = new UMLSReleaseChangesExecutor(this.kssServerName);
                            break block137;
                        }
                        case 38: {
                            executor = new ListCooccurrenceTypesExecutor(this.kssServerName);
                            break block137;
                        }
                        case 39: {
                            executor = new ListRelationTypesExecutor(this.kssServerName);
                            break block137;
                        }
                        case 40: {
                            executor = new ListStringTypesExecutor(this.kssServerName);
                            break block137;
                        }
                        case 41: {
                            executor = new DescribeCurrentExecutor(this.kssServerName);
                            break block137;
                        }
                        case 42: {
                            executor = new DescribeVersionsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 43: {
                            executor = new FindSemTypeExecutor(this.kssServerName);
                            break block137;
                        }
                        case 44: {
                            executor = new SemTypePropsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 45: {
                            executor = new SemTypeAncsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 46: {
                            executor = new SemTypeSibsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 47: {
                            executor = new ListSemTypeIdsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 48: {
                            executor = new FindSemRelExecutor(this.kssServerName);
                            break block137;
                        }
                        case 49: {
                            executor = new SemRelPropsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 50: {
                            executor = new SemRelAncsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 51: {
                            executor = new ListSemRelIdsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 52: {
                            executor = new ExistsAssocRelExecutor(this.kssServerName);
                            break block137;
                        }
                        case 53: {
                            executor = new GetAssocRelExecutor(this.kssServerName);
                            break block137;
                        }
                        case 54: {
                            executor = new ExistsHierRelExecutor(this.kssServerName);
                            break block137;
                        }
                        case 55: {
                            executor = new ListSemGroupsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 56: {
                            executor = new ListSemTypeForGroupExecutor(this.kssServerName);
                            break block137;
                        }
                        case 57: {
                            executor = new SemNetASCIIExecutor(this.kssServerName);
                            break block137;
                        }
                        case 58: {
                            executor = new SemGroupExecutor(this.kssServerName);
                            break block137;
                        }
                        case 59: {
                            executor = new GetBasicAssocRelExecutor(this.kssServerName);
                            break block137;
                        }
                        case 60: {
                            executor = new FindBasicSemRelExecutor(this.kssServerName);
                            break block137;
                        }
                        case 61: {
                            executor = new FindBasicSemTypeExecutor(this.kssServerName);
                            break block137;
                        }
                        case 62: {
                            executor = new LexicalRecordsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 64: {
                            executor = new ListSemNetTableNamesExecutor(this.kssServerName);
                            break block137;
                        }
                        case 63: {
                            executor = new ListMetaTableNamesExecutor(this.kssServerName);
                            break block137;
                        }
                        case 65: {
                            executor = new ListDocEntryTypesExecutor(this.kssServerName);
                            break block137;
                        }
                        case 66: {
                            executor = new GetAUIDetailsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 67: {
                            executor = new ConceptAttrsExecutor(this.kssServerName);
                            break block137;
                        }
                        case 68: {
                            executor = new RelationshipAttrsExecutor(this.kssServerName);
                            break block137;
                        }
                        default: {
                            throw new XMLException("Unknown query type submitted");
                        }
                    }
                }
                switch (cmdOpt) {
                    case 1: {
                        executor = new UMLSVersionExecutor(this.retriever);
                        break;
                    }
                    case 2: {
                        executor = new UMLSVersionsExecutor(this.retriever);
                        break;
                    }
                    case 3: {
                        executor = new SoftwareExecutor(this.retriever);
                        break;
                    }
                    case 4: {
                        executor = new ConceptNameExecutor(this.retriever);
                        break;
                    }
                    case 5: {
                        executor = new CUIExecutor(this.retriever);
                        break;
                    }
                    case 6: {
                        executor = new ConceptPropsExecutor(this.retriever);
                        break;
                    }
                    case 7: {
                        executor = new FindConceptExecutor(this.retriever);
                        break;
                    }
                    case 8: {
                        executor = new BasicConceptPropsExecutor(this.retriever);
                        break;
                    }
                    case 9: {
                        executor = new FindBasicConceptExecutor(this.retriever);
                        break;
                    }
                    case 10: {
                        executor = new TerminologyExecutor(this.retriever);
                        break;
                    }
                    case 11: {
                        executor = new TermsExecutor(this.retriever);
                        break;
                    }
                    case 14: {
                        executor = new DefinitionExecutor(this.retriever);
                        break;
                    }
                    case 15: {
                        executor = new SemTypeExecutor(this.retriever);
                        break;
                    }
                    case 16: {
                        executor = new ContextExecutor(this.retriever);
                        break;
                    }
                    case 17: {
                        executor = new AssocExprsExecutor(this.retriever);
                        break;
                    }
                    case 18: {
                        executor = new CooccurrencesExecutor(this.retriever);
                        break;
                    }
                    case 19: {
                        executor = new RelationsExecutor(this.retriever);
                        break;
                    }
                    case 20: {
                        executor = new StringAttrsExecutor(this.retriever);
                        break;
                    }
                    case 21: {
                        executor = new LocatorExecutor(this.retriever);
                        break;
                    }
                    case 22: {
                        executor = new MeSHEntriesExecutor(this.retriever);
                        break;
                    }
                    case 23: {
                        executor = new MeSHInfoExecutor(this.retriever);
                        break;
                    }
                    case 24: {
                        executor = new RawRecordsExecutor(this.retriever);
                        break;
                    }
                    case 25: {
                        executor = new DescribeSrcExecutor(this.retriever);
                        break;
                    }
                    case 26: {
                        executor = new ListSrcExecutor(this.retriever);
                        break;
                    }
                    case 28: {
                        executor = new ListMeSHQualsExecutor(this.retriever);
                        break;
                    }
                    case 29: {
                        executor = new ListStrAttrsExecutor(this.retriever);
                        break;
                    }
                    case 30: {
                        executor = new LUIExecutor(this.retriever);
                        break;
                    }
                    case 31: {
                        executor = new TermsForLUIExecutor(this.retriever);
                        break;
                    }
                    case 32: {
                        executor = new SUIExecutor(this.retriever);
                        break;
                    }
                    case 33: {
                        executor = new StringsForSUIExecutor(this.retriever);
                        break;
                    }
                    case 34: {
                        executor = new ListTermTypesExecutor(this.retriever);
                        break;
                    }
                    case 35: {
                        executor = new SpellingExecutor(this.retriever);
                        break;
                    }
                    case 36: {
                        executor = new ListDictsExecutor(this.retriever);
                        break;
                    }
                    case 37: {
                        executor = new UMLSReleaseChangesExecutor(this.retriever);
                        break;
                    }
                    case 38: {
                        executor = new ListCooccurrenceTypesExecutor(this.retriever);
                        break;
                    }
                    case 39: {
                        executor = new ListRelationTypesExecutor(this.retriever);
                        break;
                    }
                    case 40: {
                        executor = new ListStringTypesExecutor(this.retriever);
                        break;
                    }
                    case 41: {
                        executor = new DescribeCurrentExecutor(this.retriever);
                        break;
                    }
                    case 42: {
                        executor = new DescribeVersionsExecutor(this.retriever);
                        break;
                    }
                    case 43: {
                        executor = new FindSemTypeExecutor(this.retriever);
                        break;
                    }
                    case 44: {
                        executor = new SemTypePropsExecutor(this.retriever);
                        break;
                    }
                    case 45: {
                        executor = new SemTypeAncsExecutor(this.retriever);
                        break;
                    }
                    case 46: {
                        executor = new SemTypeSibsExecutor(this.retriever);
                        break;
                    }
                    case 47: {
                        executor = new ListSemTypeIdsExecutor(this.retriever);
                        break;
                    }
                    case 48: {
                        executor = new FindSemRelExecutor(this.retriever);
                        break;
                    }
                    case 49: {
                        executor = new SemRelPropsExecutor(this.retriever);
                        break;
                    }
                    case 50: {
                        executor = new SemRelAncsExecutor(this.retriever);
                        break;
                    }
                    case 51: {
                        executor = new ListSemRelIdsExecutor(this.retriever);
                        break;
                    }
                    case 52: {
                        executor = new ExistsAssocRelExecutor(this.retriever);
                        break;
                    }
                    case 53: {
                        executor = new GetAssocRelExecutor(this.retriever);
                        break;
                    }
                    case 54: {
                        executor = new ExistsHierRelExecutor(this.retriever);
                        break;
                    }
                    case 55: {
                        executor = new ListSemGroupsExecutor(this.retriever);
                        break;
                    }
                    case 56: {
                        executor = new ListSemTypeForGroupExecutor(this.retriever);
                        break;
                    }
                    case 57: {
                        executor = new SemNetASCIIExecutor(this.retriever);
                        break;
                    }
                    case 58: {
                        executor = new SemGroupExecutor(this.retriever);
                        break;
                    }
                    case 59: {
                        executor = new GetBasicAssocRelExecutor(this.retriever);
                        break;
                    }
                    case 60: {
                        executor = new FindBasicSemRelExecutor(this.retriever);
                        break;
                    }
                    case 61: {
                        executor = new FindBasicSemTypeExecutor(this.retriever);
                        break;
                    }
                    case 62: {
                        executor = new LexicalRecordsExecutor(this.retriever);
                        break;
                    }
                    case 64: {
                        executor = new ListSemNetTableNamesExecutor(this.retriever);
                        break;
                    }
                    case 63: {
                        executor = new ListMetaTableNamesExecutor(this.retriever);
                        break;
                    }
                    case 65: {
                        executor = new ListDocEntryTypesExecutor(this.retriever);
                        break;
                    }
                    case 66: {
                        executor = new GetAUIDetailsExecutor(this.retriever);
                        break;
                    }
                    case 67: {
                        executor = new ConceptAttrsExecutor(this.retriever);
                        break;
                    }
                    case 68: {
                        executor = new RelationshipAttrsExecutor(this.retriever);
                        break;
                    }
                    default: {
                        throw new XMLException("Unknown query type submitted");
                    }
                }
            }
            catch (DatabaseException ex) {
                System.err.println("DatabaseException: " + ex.getMessage());
                return null;
            }
        }
        char[] retVal = executor.request(root, namespace);
        executor = null;
        return retVal;
    }

    public char[] request(char[] xml) throws XMLException, DatabaseException {
        String x = new String(xml);
        return this.request(x);
    }

    public char[] request(String xml) throws XMLException, DatabaseException {
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namesp = Namespace.getNamespace("", "");
            char[] result = null;
            if (root.getName().equals("query")) {
                if (this.queryRetriever == null) {
                    if (this.retriever != null) {
                        this.queryRetriever = this.retriever;
                    } else {
                        try {
                            this.queryRetriever = this.retriever = (KSSRetrieverV5_0)Naming.lookup(this.kssServerName);
                        }
                        catch (Exception ex) {
                            throw new DatabaseException("Unable to connect: " + ex.getMessage());
                        }
                    }
                }
                try {
                    Element dbreleaseele = root.getChild("dbyear", namesp);
                    String dbrelease = "";
                    if (dbreleaseele != null) {
                        dbrelease = XMLInterpreter.extractString(dbreleaseele);
                    } else {
                        dbreleaseele = root.getChild("release", namesp);
                        if (dbreleaseele != null) {
                            dbrelease = XMLInterpreter.extractString(dbreleaseele);
                        }
                    }
                    result = this.queryRetriever.query(dbrelease, xml);
                }
                catch (RemoteException ex) {
                    throw new DatabaseException("Unable to connect: " + ex.getMessage());
                }
            }
            result = this.buildAPI(root, namesp);
            return result;
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
        catch (Exception ex) {
            throw new DatabaseException("Unable to execute: " + ex.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Usage: java gov.nih.nlm.kss.query.StandardQueryExecutor <UMLSKS_machine> <serviceName> <XML_URI> ");
            return;
        }
        String machine = args[0];
        String service = args[1];
        String filename = args[2];
        String serviceName = "//" + machine + "/" + service;
        StandardQueryExecutor parser = new StandardQueryExecutor(serviceName);
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            char[] request = parser.request(xml.toString());
            out.println(request);
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (DatabaseException ex) {
            System.out.println("DatabaseException:\n" + ex.getMessage());
            ex.printStackTrace();
        }
        catch (XMLException ex) {
            System.out.println("Unable to parse the XML:\n" + ex.getMessage());
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

