/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.rmi.RemoteException;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class AssocExprsExecutor
extends QueryExecutor {
    public AssocExprsExecutor() {
    }

    public AssocExprsExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public AssocExprsExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("getAssocExprs")) {
            throw new XMLException("AssocExprsExecutor:Query is not a 'getAssocExprs' query");
        }
        try {
            try {
                String dbyear = this.getRelease(root, namespace);
                String cui = this.getCUI(root, namespace);
                String sab = this.getSAB(root, namespace, false);
                return this.retriever.getAssocExprs(dbyear, cui, sab);
            }
            catch (XMLException ex) {
                try {
                    String dbyear = this.getRelease(root, namespace);
                    String cui = this.getCUI(root, namespace);
                    Vector sabs = this.getSABS(root, namespace, false);
                    return this.retriever.getAssocExprs(dbyear, cui, sabs);
                }
                catch (XMLException ex2) {
                    throw new XMLException("Either <sab> must be defined or " + ex2.getMessage());
                }
            }
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }
}

