/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.rmi.RemoteException;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class LUIExecutor
extends QueryExecutor {
    public LUIExecutor() {
    }

    public LUIExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public LUIExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("findLUI")) {
            throw new XMLException("LUIExecutor:Query is not a 'findLUI' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            String termName = this.getTN(root, namespace);
            Vector sabs = this.getSABS(root, namespace, false);
            String lat = this.getLAT(root, namespace, false);
            boolean incSupps = this.getIncSuppressibles(root, namespace);
            char[] result = this.retriever.findLUI(dbyear, termName, sabs, lat, incSupps);
            return result;
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }
}

