/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.Executor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public abstract class QueryExecutor
extends Executor {
    public QueryExecutor() {
    }

    public QueryExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public QueryExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public abstract char[] request(Element var1, Namespace var2) throws XMLException, DatabaseException;

    protected String getDBYear(Element element, Namespace namespace) throws XMLException {
        return this.getRelease(element, namespace);
    }

    protected String getRelease(Element element, Namespace namespace) throws XMLException {
        Element dbyear = element.getChild("dbyear", namespace);
        if (dbyear == null && (dbyear = element.getChild("release", namespace)) == null) {
            return "";
        }
        try {
            return XMLInterpreter.extractString(dbyear);
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    protected Vector getYears(Element element, Namespace namespace) throws XMLException {
        return this.getReleases(element, namespace);
    }

    protected Vector getReleases(Element element, Namespace namespace) throws XMLException {
        List releases = element.getChildren("release", namespace);
        if (releases == null) {
            return null;
        }
        Vector<String> retreleases = new Vector<String>();
        try {
            int i = 0;
            while (i < releases.size()) {
                Element yrele = (Element)releases.get(i);
                String release = XMLInterpreter.extractString(yrele);
                if (release != null && !release.equals("")) {
                    retreleases.add(release);
                }
                ++i;
            }
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
        return retreleases;
    }

    protected Vector getCUIs(Element element, Namespace namespace) throws XMLException {
        List cuis = element.getChildren("cui", namespace);
        if (cuis == null) {
            return null;
        }
        Vector<String> retcuis = new Vector<String>();
        try {
            int i = 0;
            while (i < cuis.size()) {
                Element cuiele = (Element)cuis.get(i);
                String cui = XMLInterpreter.extractString(cuiele);
                if (cui != null && !cui.equals("")) {
                    retcuis.add(cui);
                }
                ++i;
            }
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
        return retcuis;
    }

    protected String getUMLSRelease(Element element, Namespace namespace) throws XMLException {
        return this.getElement(element, namespace, "umlsRelease", true);
    }

    protected String getCUI(Element element, Namespace namespace) throws XMLException {
        return this.getElement(element, namespace, "cui", true);
    }

    protected String getCUI(Element element, Namespace namespace, boolean requiredFlag) throws XMLException {
        return this.getElement(element, namespace, "cui", requiredFlag);
    }

    protected String getCN(Element element, Namespace namespace) throws XMLException {
        return this.getElement(element, namespace, "conceptName", true);
    }

    protected String getLAT(Element element, Namespace namespace, boolean requiredFlag) throws XMLException {
        return this.getElement(element, namespace, "language", requiredFlag);
    }

    protected String getSemType(Element element, Namespace namespace, boolean requiredFlag) throws XMLException {
        return this.getElement(element, namespace, "semtype", requiredFlag);
    }

    protected String getSAB(Element element, Namespace namespace, boolean requiredFlag) throws XMLException {
        return this.getElement(element, namespace, "sab", requiredFlag);
    }

    protected Vector getSABS(Element element, Namespace namespace, boolean requiredFlag) throws XMLException {
        Vector<String> sabs = new Vector<String>();
        Element sablistGroup = element.getChild("sablist", namespace);
        if (sablistGroup == null) {
            if (requiredFlag) {
                throw new XMLException("<sablist> with at least one <sab> element must be present");
            }
            return sabs;
        }
        List sablist = sablistGroup.getChildren("sab", namespace);
        if (sablist == null) {
            if (requiredFlag) {
                throw new XMLException("<sablist> with at least one <sab> element must be present");
            }
            return sabs;
        }
        try {
            int i = 0;
            while (i < sablist.size()) {
                Element sab = (Element)sablist.get(i);
                String sabname = XMLInterpreter.extractString(sab);
                if (sabname != null && !sabname.equals("")) {
                    sabs.add(sabname);
                }
                ++i;
            }
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
        return sabs;
    }

    protected int getManip(Element element, Namespace namespace) throws XMLException {
        Element man = element.getChild("normStr", namespace);
        if (man != null) {
            return 2;
        }
        man = element.getChild("normWord", namespace);
        if (man != null) {
            return 3;
        }
        man = element.getChild("word", namespace);
        if (man != null) {
            return 4;
        }
        man = element.getChild("exact", namespace);
        if (man != null) {
            return 1;
        }
        man = element.getChild("truncRight", namespace);
        if (man != null) {
            return 5;
        }
        man = element.getChild("truncLeft", namespace);
        if (man != null) {
            return 6;
        }
        man = element.getChild("approx", namespace);
        if (man != null) {
            return 7;
        }
        return 1;
    }

    protected String getTN(Element element, Namespace namespace) throws XMLException {
        return this.getElement(element, namespace, "term", true);
    }

    protected String getTN(Element element, Namespace namespace, boolean requiredFlag) throws XMLException {
        return this.getElement(element, namespace, "term", requiredFlag);
    }

    protected String getLUI(Element element, Namespace namespace) throws XMLException {
        return this.getElement(element, namespace, "lui", true);
    }

    protected String getSUI(Element element, Namespace namespace) throws XMLException {
        return this.getElement(element, namespace, "sui", true);
    }

    protected String getSCD(Element element, Namespace namespace) throws XMLException {
        return this.getElement(element, namespace, "scd", true);
    }

    protected boolean getIncSuppressibles(Element element, Namespace namespace) throws XMLException {
        Element supps = element.getChild("noSuppressibles", namespace);
        return supps == null;
    }

    protected String getString(Element element, Namespace namespace) throws XMLException {
        return this.getElement(element, namespace, "string", true);
    }

    protected String getType(Element element, Namespace namespace) throws XMLException {
        return this.getElement(element, namespace, "docEntryType", false);
    }

    protected String getSubtype(Element element, Namespace namespace) throws XMLException {
        return this.getElement(element, namespace, "docEntrySubtype", false);
    }

    private String getElement(Element element, Namespace namespace, String elementName, boolean required) throws XMLException {
        Element str = element.getChild(elementName, namespace);
        if (str == null) {
            if (required) {
                throw new XMLException(elementName + " is a required field");
            }
            return "";
        }
        try {
            String val = XMLInterpreter.extractString(str);
            if (required && (val == null || val.equals(""))) {
                throw new XMLException(elementName + " is a required field");
            }
            return val;
        }
        catch (XMLException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    protected String getAUI(Element element, Namespace namespace, boolean requiredFlag) throws XMLException {
        return this.getElement(element, namespace, "aui", requiredFlag);
    }
}

