/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.rmi.RemoteException;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class RelationshipAttrsExecutor
extends QueryExecutor {
    public RelationshipAttrsExecutor() {
    }

    public RelationshipAttrsExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public RelationshipAttrsExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("getRelationshipAttributes")) {
            throw new XMLException("RelationshipAttrsExecutor:Query is not a 'getRelationshipAttributes' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            String cui = this.getCUI(root, namespace);
            Vector sabs = this.getSABS(root, namespace, false);
            char[] result = this.retriever.getRelationshipAttributes(dbyear, cui, sabs);
            return result;
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }
}

