/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.rmi.RemoteException;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class StringsForSUIExecutor
extends QueryExecutor {
    public StringsForSUIExecutor() {
    }

    public StringsForSUIExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public StringsForSUIExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("getStringsForSUI")) {
            throw new XMLException("StringsForSUIExecutor:Query is not a 'getStringsForSUI' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            String sui = this.getSUI(root, namespace);
            Vector sabs = this.getSABS(root, namespace, false);
            String lat = this.getLAT(root, namespace, false);
            return this.retriever.getStringsForSUI(dbyear, sui, sabs, lat);
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }
}

