/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.rmi.RemoteException;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class TermsForLUIExecutor
extends QueryExecutor {
    public TermsForLUIExecutor() {
    }

    public TermsForLUIExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public TermsForLUIExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("getTermsForLUI")) {
            throw new XMLException("TermsForLUIExecutor:Query is not a 'getTermsForLUI' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            String lui = this.getLUI(root, namespace);
            Vector sabs = this.getSABS(root, namespace, false);
            String lat = this.getLAT(root, namespace, false);
            boolean incSupps = this.getIncSuppressibles(root, namespace);
            return this.retriever.getTermsForLUI(dbyear, lui, sabs, lat, incSupps);
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }
}

