/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.meta;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.meta.QueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.rmi.RemoteException;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class UMLSReleaseChangesExecutor
extends QueryExecutor {
    public UMLSReleaseChangesExecutor() {
    }

    public UMLSReleaseChangesExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public UMLSReleaseChangesExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("describeUMLSChanges")) {
            throw new XMLException("UMLSReleaseChangesExecutor:Query is not a 'describeUMLSChanges' query");
        }
        try {
            String release = this.getUMLSRelease(root, namespace);
            Vector releases = this.getReleases(root, namespace);
            Vector cuis = this.getCUIs(root, namespace);
            char[] result = this.retriever.describeUMLSChanges(release, releases, cuis);
            return result;
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }
}

