/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.sem;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.sem.SemQueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.rmi.RemoteException;
import org.jdom.Element;
import org.jdom.Namespace;

public class ExistsHierRelExecutor
extends SemQueryExecutor {
    public ExistsHierRelExecutor() {
    }

    public ExistsHierRelExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public ExistsHierRelExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("existsHierRelRelation")) {
            throw new XMLException("ExistsHierRelExecutor:Query is not a 'existsHierRelRelation' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            if (dbyear == null || dbyear.equals("")) {
                dbyear = this.retriever.getCurrentUMLSVersion();
            }
            String lhssemtype = this.getLHSSemRelation(root, namespace, true);
            String relation = this.getSemRelation(root, namespace, true);
            String rhssemtype = this.getRHSSemRelation(root, namespace, true);
            char[] result = this.retriever.existsHierRelRelation(dbyear, lhssemtype, relation, rhssemtype);
            return result;
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }
}

