/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.sem;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.sem.SemQueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.rmi.RemoteException;
import org.jdom.Element;
import org.jdom.Namespace;

public class GetBasicAssocRelExecutor
extends SemQueryExecutor {
    public GetBasicAssocRelExecutor() {
    }

    public GetBasicAssocRelExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public GetBasicAssocRelExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("getBasicAssociativeRelations")) {
            throw new XMLException("GetBasicAssocRelExecutor:Query is not a 'getBasicAssociativeRelations' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            if (dbyear == null || dbyear.equals("")) {
                dbyear = this.retriever.getCurrentUMLSVersion();
            }
            String lhssemtype = this.getLHSSemType(root, namespace, false);
            String relation = this.getSemRelation(root, namespace, false);
            String rhssemtype = this.getRHSSemType(root, namespace, false);
            boolean expandTree = this.getTreeExpansion(root, namespace);
            char[] result = this.retriever.getBasicAssociativeRelations(dbyear, lhssemtype, relation, rhssemtype, expandTree);
            return result;
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }
}

