/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.query.sem;

import gov.nih.nlm.kss.api.KSSRetrieverV5_0;
import gov.nih.nlm.kss.query.sem.SemQueryExecutor;
import gov.nih.nlm.kss.util.DatabaseException;
import gov.nih.nlm.kss.util.XMLException;
import java.rmi.RemoteException;
import org.jdom.Element;
import org.jdom.Namespace;

public class SemTypeSibsExecutor
extends SemQueryExecutor {
    public SemTypeSibsExecutor() {
    }

    public SemTypeSibsExecutor(String kssServerName) throws DatabaseException {
        super(kssServerName);
    }

    public SemTypeSibsExecutor(KSSRetrieverV5_0 server) {
        super(server);
    }

    public char[] request(Element root, Namespace namespace) throws XMLException, DatabaseException {
        if (!root.getName().equals("getSemTypeSiblings")) {
            throw new XMLException("SemTypeSibsExecutor:Query is not a 'getSemTypeSiblings' query");
        }
        try {
            String dbyear = this.getRelease(root, namespace);
            if (dbyear == null || dbyear.equals("")) {
                dbyear = this.retriever.getCurrentUMLSVersion();
            }
            String semtype = this.getSemType(root, namespace);
            boolean expandTree = this.getTreeExpansion(root, namespace);
            char[] result = this.retriever.getSemTypeSiblings(dbyear, semtype, expandTree);
            return result;
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            throw new DatabaseException("Unable to connect: " + rex.getMessage());
        }
    }
}

