/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.torque;

import gov.nih.nlm.kss.gui.utils.Utils;
import gov.nih.nlm.kss.server.logging.AccessLogger;
import gov.nih.nlm.kss.torque.BaseKssIpaddressesPeer;
import gov.nih.nlm.kss.torque.KssIpaddresses;
import gov.nih.nlm.kss.torque.KssUsers;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

public class KssIpaddressesPeer
extends BaseKssIpaddressesPeer {
    public static List doSelectAll() throws Exception {
        Criteria crit = new Criteria();
        return BaseKssIpaddressesPeer.doSelect(crit);
    }

    public static List doSelectForUsername(String username) throws Exception {
        Criteria crit = new Criteria();
        crit.add(BaseKssIpaddressesPeer.USERNAME, (Object)username);
        return BaseKssIpaddressesPeer.doSelect(crit);
    }

    public static void update(KssUsers kssu, String ipList) {
        StringTokenizer ip = new StringTokenizer(ipList, "\n");
        String ipAddress = null;
        List lst = null;
        boolean _found = false;
        Iterator iter = null;
        KssIpaddresses kssIp = null;
        try {
            lst = KssIpaddressesPeer.doSelectForUsername(kssu.getUsername());
        }
        catch (Exception e) {
            BasePeer.log.error((Object)e.getMessage());
        }
        try {
            String logHost = Utils.getString((String)"kss.loggerHost");
            String logName = Utils.getString((String)"kss.logger");
            String name = "//" + logHost + "/" + logName;
            AccessLogger logger = (AccessLogger)Naming.lookup(name);
            iter = lst.iterator();
            while (iter.hasNext()) {
                kssIp = (KssIpaddresses)((Object)iter.next());
                try {
                    BaseKssIpaddressesPeer.doDelete(kssIp);
                    logger.removeUser(kssIp.getIp());
                }
                catch (Exception e) {
                    BasePeer.log.error((Object)e.getMessage());
                }
            }
            while (ip.hasMoreTokens()) {
                ipAddress = ip.nextToken().trim();
                if (ipAddress != null && ipAddress.length() < 2) continue;
                try {
                    kssIp = new KssIpaddresses();
                    kssIp.setUsername(kssu.getUsername());
                    kssIp.setIp(ipAddress);
                    kssIp.setStatus(kssu.getStatus());
                    kssIp.save();
                    logger.addUser(ipAddress);
                }
                catch (Exception e) {
                    BasePeer.log.error((Object)e.getMessage());
                }
            }
        }
        catch (RemoteException rex) {
            BasePeer.log.error((Object)("insertIP: RemoteException: " + rex.getMessage()));
        }
        catch (NotBoundException nbex) {
            BasePeer.log.error((Object)("insertIP: NotBoundException: " + nbex.getMessage()));
        }
        catch (MalformedURLException mfurl) {
            BasePeer.log.error((Object)("insertIP: MalformedURLException: " + mfurl.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

