/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class CompareUtil {
    static Hashtable sabMappings = new Hashtable();
    static Hashtable cxsMappings = new Hashtable();
    static boolean initialized = false;

    public static String logicalEquivSAB(String sab) {
        String found;
        if (sab == null) {
            return null;
        }
        if (!initialized) {
            CompareUtil.init();
        }
        if ((found = (String)sabMappings.get(sab)) != null) {
            return found;
        }
        return sab;
    }

    public static String logicalEquivCXS(String cxs) {
        String found;
        if (cxs == null) {
            return null;
        }
        if (!initialized) {
            CompareUtil.init();
        }
        if ((found = (String)cxsMappings.get(cxs)) != null) {
            return found;
        }
        return cxs;
    }

    private static void init() {
        if (initialized) {
            return;
        }
        CompareUtil.initEquivs("SABEquivalents", sabMappings);
        CompareUtil.initEquivs("CXSEquivalents", cxsMappings);
        initialized = true;
    }

    private static void initEquivs(String propName, Hashtable mappings) {
        String fileName = System.getProperty(propName);
        if (fileName == null) {
            System.err.println("Unable to initialize " + propName + " from file '" + fileName + "'");
            return;
        }
        Properties props = new Properties();
        try {
            FileInputStream is = new FileInputStream(fileName);
            props.load(is);
            is.close();
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Unable to initialize " + propName + " from file '" + fileName + "'");
            return;
        }
        catch (Exception e) {
            System.err.println("Unable to initialize " + propName + " from file '" + fileName + "'");
            return;
        }
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String val = props.getProperty(key);
            key = key.replace('*', ' ');
            mappings.put(key, val);
        }
        Object var3_3 = null;
    }

    public static String logicalEquivATV(String atn, String atv) {
        String atvn = atv;
        if (atn.equals("MN")) {
            StringBuffer buf = new StringBuffer(100);
            buf.append(atv.substring(0, 1));
            buf.append("0");
            buf.append(buf.substring(2));
            atvn = buf.toString();
        }
        return atvn;
    }

    public static String logicalEquivCN(String cn) {
        if (cn == null) {
            return "Non-existent";
        }
        String ccn = cn;
        if (cn.equals("null")) {
            ccn = "Non-existent";
        }
        return ccn;
    }
}

