/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Properties;

public class ConstantSettings {
    private static String MeSHQualifierFileProp = "KssMeshQualifierFile";
    private static String SourceFileProp = "KssSourceFile";
    private static String StringAttributesFileProp = "KssStringAttributesFile";
    private static String DatabaseFormatProp = "DatabaseFormat";
    static boolean initialized = false;

    protected ConstantSettings() {
    }

    public static String getMeSHQualifierFileName() {
        String mqfn = System.getProperty(MeSHQualifierFileProp);
        if (mqfn == null) {
            return "";
        }
        return mqfn;
    }

    public static String getSourceFileName() {
        String sfn = System.getProperty(SourceFileProp);
        if (sfn == null) {
            return "";
        }
        return sfn;
    }

    public static String getStringAttributeFileName() {
        String sa = System.getProperty(StringAttributesFileProp);
        if (sa == null) {
            return "";
        }
        return sa;
    }

    public static String getDatabaseFormat() {
        String sa = System.getProperty(DatabaseFormatProp);
        if (sa == null) {
            return "";
        }
        return sa;
    }

    protected static void initializeProps() {
        if (initialized) {
            return;
        }
        initialized = true;
        Properties props = System.getProperties();
        Properties kssprops = new Properties();
        try {
            FileInputStream is = new FileInputStream("./kss.properties");
            kssprops.load(is);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Can't read the KSS properties file. Make sure 'kss.properties' is in the CLASSPATH");
            return;
        }
        catch (Exception e) {
            System.err.println("Can't read the KSS properties file. Make sure 'kss.properties' is in the CLASSPATH");
            return;
        }
        Enumeration<?> propNames = kssprops.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propVal = kssprops.getProperty(propName);
            props.setProperty(propName, propVal);
        }
        System.setProperties(props);
    }

    public static void main(String[] args) {
        ConstantSettings.initializeProps();
        System.out.println("MeSH Qualifier Filename = '" + ConstantSettings.getMeSHQualifierFileName() + "'");
        System.out.println("Sources Filename = '" + ConstantSettings.getSourceFileName() + "'");
        System.out.println("String Attributes Filename = '" + ConstantSettings.getStringAttributeFileName() + "'");
    }
}

