/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.util;

import gov.nih.nlm.kss.util.XMLException;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class XMLInterpreter {
    public static String extractString(Element elem) throws XMLException {
        List content = elem.getContent();
        if (content == null) {
            String msg = "Error getting content from '" + elem.getName() + "'";
            throw new XMLException(msg);
        }
        String value = null;
        Iterator contentIter = content.iterator();
        if (contentIter.hasNext()) {
            Object str = contentIter.next();
            String className = str.getClass().getName();
            if (!className.equals("java.lang.String")) {
                String msg = "Content not of type java.lang.String";
                throw new XMLException(msg);
            }
            value = (String)str;
            if (contentIter.hasNext()) {
                String msg = "Content should only contain a java.lang.String";
                throw new XMLException(msg);
            }
        }
        return value;
    }
}

