/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Api;

import gov.nih.nlm.nls.lexCheck.Api.ApiOutput;
import gov.nih.nlm.nls.lexCheck.Gram.CheckGrammer;
import gov.nih.nlm.nls.lexCheck.Lib.CheckSt;
import gov.nih.nlm.nls.lexCheck.Lib.Convert;
import gov.nih.nlm.nls.lexCheck.Lib.InflectionalVars;
import gov.nih.nlm.nls.lexCheck.Lib.LineObject;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToXmlApi {
    public static ApiOutput ToXmlFromFile(String string) {
        Object object;
        CheckSt checkSt = new CheckSt();
        CheckSt checkSt2 = new CheckSt(40);
        LineObject lineObject = new LineObject();
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-16\"?>\n");
        stringBuffer.append("<lexRecords>\n");
        int n = 0;
        try {
            object = new BufferedReader(new FileReader(string));
            while (lineObject != null) {
                if (lineObject.IsGoToNext()) {
                    lineObject.SetLine(((BufferedReader)object).readLine());
                    lineObject.IncreaseLineNum();
                }
                if (lineObject.GetLine() == null) break;
                n = ToXmlApi.CheckLine(checkSt, checkSt2, lineObject, stringBuffer, n);
            }
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        stringBuffer.append("</lexRecords>\n");
        object = new ApiOutput(stringBuffer.toString(), n);
        return object;
    }

    public static ApiOutput ToXmlFromText(String string) {
        CheckSt checkSt = new CheckSt();
        CheckSt checkSt2 = new CheckSt(40);
        LineObject lineObject = new LineObject();
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-16\"?>\n");
        stringBuffer.append("<lexRecords>\n");
        int n = 0;
        String string2 = Convert.ToUnixLineSeparator(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        while (lineObject != null) {
            if (lineObject.IsGoToNext()) {
                if (!stringTokenizer.hasMoreTokens()) break;
                lineObject.SetLine(stringTokenizer.nextToken());
                lineObject.IncreaseLineNum();
            }
            n = ToXmlApi.CheckLine(checkSt, checkSt2, lineObject, stringBuffer, n);
        }
        stringBuffer.append("</lexRecords>\n");
        ApiOutput apiOutput = new ApiOutput(stringBuffer.toString(), n);
        return apiOutput;
    }

    public static Vector GetInflVars(String string) {
        CheckSt checkSt = new CheckSt();
        CheckSt checkSt2 = new CheckSt(40);
        LineObject lineObject = new LineObject();
        Vector vector = new Vector();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while (lineObject != null) {
                if (lineObject.IsGoToNext()) {
                    lineObject.SetLine(bufferedReader.readLine());
                    lineObject.IncreaseLineNum();
                }
                if (lineObject.GetLine() == null) break;
                boolean bl = CheckGrammer.Check(lineObject, true, checkSt, checkSt2, false);
                if (checkSt.GetCurState() != 10 || !bl) continue;
                InflectionalVars inflectionalVars = new InflectionalVars(CheckGrammer.GetLexRecord());
                vector.addAll(inflectionalVars.GetInflValues());
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        String string = "{base=bat\nentry=E0012112\n\tcat=noun\n\tvariants=reg\nsignature=vanni\n}";
        String string2 = "{base=molt\nspelling_variant=moult\nentry=E0040723\n\tcat=noun\n\tvariants=reg\nsignature=vanni\n}\n{base=molt\nspelling_variant=moult\nentry=E0040724\n\tcat=verb\n\tvariants=reg\n\tintran\n\ttran=np\n\tnominalization=molting|noun|E0412675\nsignature=vanni\n}";
        String string3 = "molt";
        System.out.print(ToXmlApi.ToXmlFromFile(string3).GetXml());
        System.out.println("---- Record Num: " + ToXmlApi.ToXmlFromFile(string3).GetRecordNum());
    }

    private static int CheckLine(CheckSt checkSt, CheckSt checkSt2, LineObject lineObject, StringBuffer stringBuffer, int n) {
        boolean bl = false;
        boolean bl2 = true;
        bl = CheckGrammer.Check(lineObject, bl2, checkSt, checkSt2, false);
        if (checkSt.GetCurState() == 10 && bl) {
            stringBuffer.append(CheckGrammer.GetLexRecord().GetXml());
            ++n;
        }
        return n;
    }
}

