/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.CkLib;

import gov.nih.nlm.nls.lexCheck.CkLib.CheckObject;
import gov.nih.nlm.nls.lexCheck.CkLib.LineCheck;
import gov.nih.nlm.nls.lexCheck.Lib.CheckSt;
import gov.nih.nlm.nls.lexCheck.Lib.ErrMsg;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import gov.nih.nlm.nls.lexCheck.Lib.LineObject;
import gov.nih.nlm.nls.lexCheck.Lib.TokenObject;
import gov.nih.nlm.nls.lexCheck.Lib.UpdateLex;

public class CheckCode {
    public static final int FQ_ONE = 1;
    public static final int FQ_ZERO_ONE = 2;
    public static final int FQ_ZERO_MANY = 3;
    public static final int FQ_ONE_MANY = 4;
    public static final int FQ_ONE_WHOLE_LINE = 5;
    public static final int FQ_ZERO_ONE_WHOLE_LINE = 6;

    public static boolean Check(LineObject lineObject, boolean bl, CheckSt checkSt, LexRecord lexRecord, CheckObject checkObject, UpdateLex updateLex, int n, boolean bl2) {
        boolean bl3 = false;
        switch (n) {
            case 1: {
                bl3 = CheckCode.CheckOne(lineObject, bl, checkSt, lexRecord, checkObject, updateLex, bl2, true);
                break;
            }
            case 2: {
                bl3 = CheckCode.CheckZeroOne(lineObject, bl, checkSt, lexRecord, checkObject, updateLex, bl2);
                break;
            }
            case 3: {
                bl3 = CheckCode.CheckZeroMany(lineObject, bl, checkSt, lexRecord, checkObject, updateLex, bl2);
                break;
            }
            case 4: {
                bl3 = CheckCode.CheckOneMany(lineObject, bl, checkSt, lexRecord, checkObject, updateLex, bl2);
                break;
            }
            case 5: {
                bl3 = CheckCode.CheckOneWholeLine(lineObject, bl, checkSt, lexRecord, checkObject, updateLex);
                break;
            }
            case 6: {
                bl3 = CheckCode.CheckZeroOneWholeLine(lineObject, bl, checkSt, lexRecord, checkObject, updateLex);
            }
        }
        return bl3;
    }

    private static boolean CheckOne(LineObject lineObject, boolean bl, CheckSt checkSt, LexRecord lexRecord, CheckObject checkObject, UpdateLex updateLex, boolean bl2, boolean bl3) {
        TokenObject tokenObject;
        lineObject.SetGoToNext(true);
        boolean bl4 = LineCheck.CheckStartStr(lineObject, bl, checkObject);
        checkSt.UpdateLastState();
        if (bl4 && (bl4 = LineCheck.CheckSlotFiller(lineObject, bl, checkObject, tokenObject = new TokenObject(), bl2))) {
            if (bl3) {
                checkSt.UpdateCurState(checkObject.GetNextState());
            }
            if (updateLex != null) {
                updateLex.Update(lexRecord, tokenObject.GetToken());
            }
        }
        return bl4;
    }

    private static boolean CheckZeroOne(LineObject lineObject, boolean bl, CheckSt checkSt, LexRecord lexRecord, CheckObject checkObject, UpdateLex updateLex, boolean bl2) {
        String string = lineObject.GetLine();
        boolean bl3 = checkObject.IsNextStartStr(string);
        if (bl3) {
            checkSt.UpdateCurState(checkObject.GetNextState());
            lineObject.SetGoToNext(false);
            return bl3;
        }
        if (checkSt.GetCurState() != checkSt.GetLastState()) {
            checkSt.UpdateLastState();
            bl3 = CheckCode.CheckOne(lineObject, bl, checkSt, lexRecord, checkObject, updateLex, bl2, false);
        } else {
            ErrMsg.PrintErrMsg(bl, 82, lineObject, string, 0, string.length(), checkObject.IsTab());
            checkSt.UpdateLastState();
            bl3 = false;
        }
        return bl3;
    }

    private static boolean CheckZeroMany(LineObject lineObject, boolean bl, CheckSt checkSt, LexRecord lexRecord, CheckObject checkObject, UpdateLex updateLex, boolean bl2) {
        TokenObject tokenObject;
        lineObject.SetGoToNext(true);
        checkSt.UpdateLastState();
        boolean bl3 = checkObject.IsNextStartStr(lineObject.GetLine());
        if (bl3) {
            checkSt.UpdateCurState(checkObject.GetNextState());
            lineObject.SetGoToNext(false);
            return bl3;
        }
        bl3 = LineCheck.CheckStartStr(lineObject, bl, checkObject);
        if (bl3 && (bl3 = LineCheck.CheckSlotFiller(lineObject, bl, checkObject, tokenObject = new TokenObject(), bl2))) {
            updateLex.Update(lexRecord, tokenObject.GetToken());
        }
        return bl3;
    }

    private static boolean CheckOneMany(LineObject lineObject, boolean bl, CheckSt checkSt, LexRecord lexRecord, CheckObject checkObject, UpdateLex updateLex, boolean bl2) {
        boolean bl3 = false;
        if (checkSt.GetCurState() != checkSt.GetLastState()) {
            checkSt.UpdateLastState();
            bl3 = CheckCode.CheckOne(lineObject, bl, checkSt, lexRecord, checkObject, updateLex, bl2, false);
        } else {
            checkSt.UpdateLastState();
            bl3 = CheckCode.CheckZeroMany(lineObject, bl, checkSt, lexRecord, checkObject, updateLex, bl2);
        }
        return bl3;
    }

    private static boolean CheckOneWholeLine(LineObject lineObject, boolean bl, CheckSt checkSt, LexRecord lexRecord, CheckObject checkObject, UpdateLex updateLex) {
        lineObject.SetGoToNext(true);
        boolean bl2 = LineCheck.CheckWholeLine(lineObject, bl, checkObject);
        if (bl2) {
            checkSt.UpdateCurState(checkObject.GetNextState());
            checkSt.UpdateLastState();
            if (updateLex != null) {
                updateLex.Update(lexRecord, lineObject.GetLine());
            }
        }
        return bl2;
    }

    private static boolean CheckZeroOneWholeLine(LineObject lineObject, boolean bl, CheckSt checkSt, LexRecord lexRecord, CheckObject checkObject, UpdateLex updateLex) {
        boolean bl2 = checkObject.IsNextStartStr(lineObject.GetLine());
        if (bl2) {
            checkSt.UpdateCurState(checkObject.GetNextState());
            lineObject.SetGoToNext(false);
            return bl2;
        }
        if (checkSt.GetCurState() != checkSt.GetLastState()) {
            checkSt.UpdateLastState();
            bl2 = CheckCode.CheckOneWholeLine(lineObject, bl, checkSt, lexRecord, checkObject, updateLex);
        } else {
            String string = lineObject.GetLine();
            checkSt.UpdateLastState();
            ErrMsg.PrintErrMsg(bl, 82, lineObject, string, 0, string.length(), checkObject.IsTab());
        }
        return bl2;
    }
}

