/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Lib;

import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import java.util.Vector;

public class AdjEntry {
    private Vector variants_ = new Vector();
    private Vector position_ = new Vector();
    private Vector compl_ = new Vector();
    private boolean stative_ = false;
    private Vector nominalization_ = new Vector();

    public AdjEntry() {
        this.variants_ = new Vector();
        this.position_ = new Vector();
        this.compl_ = new Vector();
        this.nominalization_ = new Vector();
    }

    public Vector GetVariants() {
        return this.variants_;
    }

    public Vector GetPosition() {
        return this.position_;
    }

    public Vector GetCompl() {
        return this.compl_;
    }

    public Vector GetNominalization() {
        return this.nominalization_;
    }

    public boolean IsStative() {
        return this.stative_;
    }

    public void AddVariant(String string) {
        this.variants_.add(string);
    }

    public void SetVariants(Vector vector) {
        this.variants_ = vector;
    }

    public void AddPosition(String string) {
        this.position_.add(string);
    }

    public void SetPosition(Vector vector) {
        this.position_ = vector;
    }

    public void AddCompl(String string) {
        this.compl_.add(string);
    }

    public void SetCompl(Vector vector) {
        this.compl_ = vector;
    }

    public void AddNominalization(String string) {
        this.nominalization_.add(string);
    }

    public void SetNominalization(Vector vector) {
        this.nominalization_ = vector;
    }

    public void SetStative(boolean bl) {
        this.stative_ = bl;
    }

    public String GetText() {
        String string = new String();
        string = LexRecord.AddToText(string, "\tvariants=", this.variants_);
        string = LexRecord.AddToText(string, "\tposition=", this.position_);
        string = LexRecord.AddToText(string, "\tcompl=", this.compl_);
        string = LexRecord.AddToText(string, "\tstative", this.stative_);
        string = LexRecord.AddToText(string, "\tnominalization=", this.nominalization_);
        return string;
    }

    public String GetXml() {
        String string = new String();
        string = LexRecord.AddToXml(string, "\t<adjEntry>\n");
        string = LexRecord.AddToXml(string, "\t\t<variants>", "</variants>\n", this.variants_);
        if (this.position_ != null) {
            int n = 0;
            while (n < this.position_.size()) {
                String string2 = "\t\t<position type=\"" + (String)this.position_.elementAt(n) + "\"></position>\n";
                string = LexRecord.AddToXml(string, string2);
                ++n;
            }
        }
        string = LexRecord.AddToXml(string, "\t\t<compl>", "</compl>\n", this.compl_);
        string = LexRecord.AddToXml(string, "\t\t<stative/>\n", this.stative_);
        string = LexRecord.AddToXml(string, "\t\t<nominalization>", "</nominalization>\n", this.nominalization_);
        string = LexRecord.AddToXml(string, "\t</adjEntry>\n");
        return string;
    }
}

