/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Lib;

public class Convert {
    public static final String UNIX_LINE_SEP = "\n";
    public static final String PC_LINE_SEP = "^M\n";
    private static final String[][] ENTITY_LIST = new String[][]{{"&#038;", "&amp;", "&"}, {"&#034;", "&quot;", "\""}, {"&#060;", "&lt;", "<"}, {"&#062;", "&gt;", ">"}, {"&#160;", "&nbsp;", "\u00a0"}};

    public static void main(String[] stringArray) {
        String string = "ASCII: A-Z,a-z.\n&,<,>,\",  .\nSpace Test";
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        System.out.println("-- in: " + string);
        System.out.println("-- Name:" + Convert.ToNamedEntity(string));
        System.out.println("-- Numeric:" + Convert.ToNumericEntity(string));
        System.out.println("-- ToHtml:" + Convert.AsciiToHtml(string));
    }

    public static String ToNumericEntity(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < ENTITY_LIST.length) {
            int n3 = ENTITY_LIST[n2][2].length();
            while ((n = string.indexOf(ENTITY_LIST[n2][2], n + 1)) >= 0) {
                string = string.substring(0, n) + ENTITY_LIST[n2][0] + string.substring(n + n3);
            }
            ++n2;
        }
        return string;
    }

    public static String ToNamedEntity(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < ENTITY_LIST.length) {
            int n3 = ENTITY_LIST[n2][2].length();
            while ((n = string.indexOf(ENTITY_LIST[n2][2], n + 1)) >= 0) {
                string = string.substring(0, n) + ENTITY_LIST[n2][1] + string.substring(n + n3);
            }
            ++n2;
        }
        return string;
    }

    public static String AsciiToHtml(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < ENTITY_LIST.length) {
            int n3 = ENTITY_LIST[n2][2].length();
            while ((n = string.indexOf(ENTITY_LIST[n2][2], n + 1)) >= 0) {
                string = string.substring(0, n) + ENTITY_LIST[n2][0] + string.substring(n + n3);
            }
            ++n2;
        }
        while ((n = string.indexOf(" ")) >= 0) {
            string = string.substring(0, n) + "&nbsp;" + string.substring(n + 1);
        }
        while ((n = string.indexOf(UNIX_LINE_SEP)) >= 0) {
            string = string.substring(0, n) + "&#010;" + string.substring(n + 1);
        }
        while ((n = string.indexOf("\t")) >= 0) {
            string = string.substring(0, n) + "&#009;" + string.substring(n + 1);
        }
        return string;
    }

    public static String HtmlToAscii(String string) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = string.indexOf("&#");
        while (n4 >= n3) {
            n2 = n4 + 2;
            while (n2 < string.length() && Character.isDigit(string.charAt(n2))) {
                ++n2;
            }
            if (n2 >= string.length() || string.charAt(n2) != ';') {
                n4 += 2;
            } else {
                n = -1;
                try {
                    n = Integer.parseInt(string.substring(n4 + 2, n2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string = string.substring(0, n4) + (char)n + string.substring(n2 + 1);
            }
            n3 = n4;
            n4 += string.substring(n4).indexOf("&#");
        }
        n2 = 0;
        while (n2 < ENTITY_LIST.length) {
            n = ENTITY_LIST[n2][0].length();
            while ((n4 = string.indexOf(ENTITY_LIST[n2][0])) >= 0) {
                string = string.substring(0, n4) + ENTITY_LIST[n2][2] + string.substring(n4 + n);
            }
            ++n2;
        }
        while ((n4 = string.indexOf(" ")) >= 0) {
            string = string.substring(0, n4) + string.substring(n4 + 1);
        }
        return string;
    }

    public static String ToUnixLineSeparator(String string) {
        String string2 = string;
        String string3 = UNIX_LINE_SEP;
        String string4 = UNIX_LINE_SEP;
        int n = string4.length();
        int n2 = string3.length();
        int n3 = string2.indexOf(string3);
        while (n3 >= 0) {
            char c = string2.charAt(n3 - 1);
            if (Character.getType(c) == 15) {
                string2 = string2.substring(0, n3 - 1) + string4 + string2.substring(n3 + 1);
                n3 = string2.indexOf(string3, n3);
                continue;
            }
            n3 = string2.indexOf(string3, n3 + 1);
        }
        return string2;
    }

    public static String ToPcLineSeparator(String string) {
        String string2 = Convert.ToUnixLineSeparator(string);
        String string3 = Convert.Replace(string2, UNIX_LINE_SEP, PC_LINE_SEP);
        return string3;
    }

    public static String Replace(String string, String string2, String string3) {
        String string4 = string;
        int n = string3.length();
        int n2 = string2.length();
        int n3 = string4.indexOf(string2);
        while (n3 >= 0) {
            string4 = string4.substring(0, n3) + string3 + string4.substring(n3 + n2);
            n3 = string4.indexOf(string2, n3 + n);
        }
        return string4;
    }
}

