/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Api;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToStripDiacritics;
import gov.nih.nlm.nls.lvg.Flows.ToStripStopWords;
import gov.nih.nlm.nls.lvg.Flows.ToSyntacticUninvert;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class LvgApi {
    private int outRecordNum_ = -1;
    private BufferedReader inReader_ = null;
    private BufferedWriter outWriter_ = null;
    private Connection conn_ = null;
    private RamTrie ramTrieI_ = null;
    private RamTrie ramTrieD_ = null;
    private String configFile_ = null;
    private int maxTerm_ = -1;
    private int maxCodeLength_ = -1;
    private Vector stopWords_ = null;
    private Vector nonInfoWords_ = null;
    private Vector conjunctionWords_ = null;
    private Hashtable diacriticMap_ = null;

    public LvgApi() {
        this.Init();
    }

    public LvgApi(String string) {
        this.configFile_ = string;
        this.Init();
    }

    public LvgApi(String string, Hashtable hashtable) {
        this.configFile_ = string;
        this.Init(hashtable);
    }

    public Connection GetConnection() {
        return this.conn_;
    }

    public void CloseConnection(Connection connection) {
        if (connection != null) {
            try {
                DbBase.CloseConnection(connection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public RamTrie GetInflectionTrie() {
        return this.ramTrieI_;
    }

    public RamTrie GetDerivationTrie() {
        return this.ramTrieD_;
    }

    public void CleanUp() {
        try {
            this.Close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int GetMaxTerm() {
        return this.maxTerm_;
    }

    public int GetMaxCodeLength() {
        return this.maxCodeLength_;
    }

    public Vector GetStopWords() {
        return this.stopWords_;
    }

    public Vector GetNonInfoWords() {
        return this.nonInfoWords_;
    }

    public Vector GetConjunctionWords() {
        return this.conjunctionWords_;
    }

    public Hashtable GetDiacriticMap() {
        return this.diacriticMap_;
    }

    private void Init() {
        boolean bl = false;
        if (this.configFile_ == null) {
            bl = true;
            this.configFile_ = "data.config.lvg";
        }
        Configuration configuration = new Configuration(this.configFile_, bl);
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string = configuration.GetConfiguration("LVG_DIR");
        this.outRecordNum_ = Integer.parseInt(configuration.GetConfiguration("TRUNCATED_RESULTS"));
        this.maxTerm_ = Integer.parseInt(configuration.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS"));
        this.maxCodeLength_ = Integer.parseInt(configuration.GetConfiguration("MAX_METAPHONE"));
        this.stopWords_ = ToStripStopWords.GetStopWordsFromFile(configuration);
        this.nonInfoWords_ = ToSyntacticUninvert.GetNonInfoWordsFromFile(configuration);
        this.conjunctionWords_ = ToSyntacticUninvert.GetConjunctionWordsFromFile(configuration);
        this.diacriticMap_ = ToStripDiacritics.GetDiacriticsFromFile(configuration);
        int n2 = Integer.parseInt(configuration.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        try {
            this.conn_ = DbBase.OpenConnection(configuration);
            this.ramTrieI_ = new RamTrie(true, n, string, 0);
            this.ramTrieD_ = new RamTrie(false, n, string, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void Init(Hashtable hashtable) {
        boolean bl = false;
        if (this.configFile_ == null) {
            bl = true;
            this.configFile_ = "data.config.lvg";
        }
        Configuration configuration = new Configuration(this.configFile_, bl);
        String string = Configuration.OverWriteProperty("MIN_TERM_LENGTH", configuration, hashtable);
        int n = Integer.parseInt(string);
        String string2 = Configuration.OverWriteProperty("LVG_DIR", configuration, hashtable);
        this.outRecordNum_ = Integer.parseInt(Configuration.OverWriteProperty("TRUNCATED_RESULTS", configuration, hashtable));
        this.maxTerm_ = Integer.parseInt(Configuration.OverWriteProperty("MAX_RULE_UNINFLECTED_TERMS", configuration, hashtable));
        this.maxCodeLength_ = Integer.parseInt(Configuration.OverWriteProperty("MAX_METAPHONE", configuration, hashtable));
        this.stopWords_ = ToStripStopWords.GetStopWordsFromFile(configuration);
        this.nonInfoWords_ = ToSyntacticUninvert.GetNonInfoWordsFromFile(configuration);
        this.conjunctionWords_ = ToSyntacticUninvert.GetConjunctionWordsFromFile(configuration);
        this.diacriticMap_ = ToStripDiacritics.GetDiacriticsFromFile(configuration);
        int n2 = Integer.parseInt(configuration.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        try {
            this.conn_ = DbBase.OpenConnection(configuration, hashtable);
            this.ramTrieI_ = new RamTrie(true, n, string2, 0);
            this.ramTrieD_ = new RamTrie(false, n, string2, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void Close() throws IOException, SQLException {
        if (this.outWriter_ != null) {
            this.outWriter_.close();
        }
        if (this.inReader_ != null) {
            this.inReader_.close();
        }
        if (this.conn_ != null) {
            DbBase.CloseConnection(this.conn_);
        }
    }
}

