/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Api;

import gov.nih.nlm.nls.lvg.Api.LvgHelp;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.SystemOption;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToAcronyms;
import gov.nih.nlm.nls.lvg.Flows.ToAntiNorm;
import gov.nih.nlm.nls.lvg.Flows.ToBaseSpellingVariants;
import gov.nih.nlm.nls.lvg.Flows.ToCanonicalize;
import gov.nih.nlm.nls.lvg.Flows.ToCitation;
import gov.nih.nlm.nls.lvg.Flows.ToConvertOutput;
import gov.nih.nlm.nls.lvg.Flows.ToDerivation;
import gov.nih.nlm.nls.lvg.Flows.ToDerivationByCategory;
import gov.nih.nlm.nls.lvg.Flows.ToExpansions;
import gov.nih.nlm.nls.lvg.Flows.ToFilter;
import gov.nih.nlm.nls.lvg.Flows.ToFilterAcronym;
import gov.nih.nlm.nls.lvg.Flows.ToFilterProperNoun;
import gov.nih.nlm.nls.lvg.Flows.ToFruitfulEnhanced;
import gov.nih.nlm.nls.lvg.Flows.ToFruitfulVariants;
import gov.nih.nlm.nls.lvg.Flows.ToFruitfulVariantsDb;
import gov.nih.nlm.nls.lvg.Flows.ToFruitfulVariantsLex;
import gov.nih.nlm.nls.lvg.Flows.ToInflection;
import gov.nih.nlm.nls.lvg.Flows.ToInflectionByCatInfl;
import gov.nih.nlm.nls.lvg.Flows.ToInflectionSimple;
import gov.nih.nlm.nls.lvg.Flows.ToLowerCase;
import gov.nih.nlm.nls.lvg.Flows.ToLuiNormalize;
import gov.nih.nlm.nls.lvg.Flows.ToMetaphone;
import gov.nih.nlm.nls.lvg.Flows.ToNoOperation;
import gov.nih.nlm.nls.lvg.Flows.ToNormUninflectWords;
import gov.nih.nlm.nls.lvg.Flows.ToNormalize;
import gov.nih.nlm.nls.lvg.Flows.ToRecursiveDerivations;
import gov.nih.nlm.nls.lvg.Flows.ToRecursiveSynonyms;
import gov.nih.nlm.nls.lvg.Flows.ToRemoveGenitive;
import gov.nih.nlm.nls.lvg.Flows.ToReplacePunctuationWithSpace;
import gov.nih.nlm.nls.lvg.Flows.ToRetrieveCatInfl;
import gov.nih.nlm.nls.lvg.Flows.ToRetrieveCatInflBegin;
import gov.nih.nlm.nls.lvg.Flows.ToRetrieveCatInflDb;
import gov.nih.nlm.nls.lvg.Flows.ToRetrieveEui;
import gov.nih.nlm.nls.lvg.Flows.ToSimpleInflections;
import gov.nih.nlm.nls.lvg.Flows.ToSortWordsByOrder;
import gov.nih.nlm.nls.lvg.Flows.ToSpellingVariants;
import gov.nih.nlm.nls.lvg.Flows.ToStripAmbiguityTags;
import gov.nih.nlm.nls.lvg.Flows.ToStripDiacritics;
import gov.nih.nlm.nls.lvg.Flows.ToStripNecNos;
import gov.nih.nlm.nls.lvg.Flows.ToStripPunctuation;
import gov.nih.nlm.nls.lvg.Flows.ToStripPunctuationEnhanced;
import gov.nih.nlm.nls.lvg.Flows.ToStripStopWords;
import gov.nih.nlm.nls.lvg.Flows.ToSynonyms;
import gov.nih.nlm.nls.lvg.Flows.ToSyntacticUninvert;
import gov.nih.nlm.nls.lvg.Flows.ToTokenize;
import gov.nih.nlm.nls.lvg.Flows.ToTokenizeKeepAll;
import gov.nih.nlm.nls.lvg.Flows.ToTokenizeNoHyphens;
import gov.nih.nlm.nls.lvg.Flows.ToUninflectTerm;
import gov.nih.nlm.nls.lvg.Flows.ToUninflectWords;
import gov.nih.nlm.nls.lvg.Flows.ToUninvert;
import gov.nih.nlm.nls.lvg.Flows.ToWordSize;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Flow;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.LvgFlowSpecificOption;
import gov.nih.nlm.nls.lvg.Lib.LvgOutputOption;
import gov.nih.nlm.nls.lvg.Lib.OutputFilter;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Util.Out;
import gov.nih.nlm.nls.lvg.Util.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class LvgCmdApi
extends SystemOption {
    protected Vector quitStrList_ = new Vector();
    protected boolean runFlag_ = true;
    protected BufferedReader inReader_ = null;
    private BufferedWriter outWriter_ = null;
    protected Vector flowStrs_ = new Vector();
    protected Vector flowStrsList_ = new Vector();
    private boolean dbFlag_ = false;
    private Option option_ = new Option("");
    private String promptStr_ = null;
    private String originalTerm_ = null;
    protected int termFieldNum_ = 1;
    protected int catFieldNum_ = -1;
    protected int inflFieldNum_ = -1;
    private LvgOutputOption lvgOutputOption_ = new LvgOutputOption();
    private LvgFlowSpecificOption lvgFlowSpecificOption_ = new LvgFlowSpecificOption();
    protected boolean promptFlag_ = false;
    private int wordSize_ = 2;
    private boolean detailsFlag_ = false;
    private boolean mutateFlag_ = false;
    private Vector derivationCatList_ = new Vector();
    private int curDerivationCatNum_ = 0;
    private Vector inflectionCatList_ = new Vector();
    private Vector inflectionInflList_ = new Vector();
    private int curInflectionByCatInflCount_ = 0;
    private int curInflectionByCatInflNum_ = 0;
    private int flowNum_ = 0;
    private Connection conn_ = null;
    private RamTrie ramTrieI_ = null;
    private RamTrie ramTrieD_ = null;
    private String configFile_ = null;
    private Configuration conf_ = null;
    private Vector stopWords_ = null;
    private Vector nonInfoWords_ = null;
    private Vector conjunctionWords_ = null;
    private Hashtable diacriticMap_ = null;

    public LvgCmdApi() {
        this.Init();
    }

    public LvgCmdApi(String string) {
        this.option_ = new Option(string);
        this.Init();
    }

    public LvgCmdApi(String string, String string2) {
        this.option_ = new Option(string);
        this.configFile_ = string2;
        this.Init();
    }

    public LvgCmdApi(String string, String string2, Hashtable hashtable) {
        this.option_ = new Option(string);
        this.configFile_ = string2;
        this.Init(hashtable);
    }

    public void SetPromptStr(String string) {
        this.promptStr_ = string;
    }

    public void SetQuitStrList(Vector vector) {
        this.quitStrList_ = new Vector(vector);
    }

    public boolean IsLegalOption() {
        boolean bl = SystemOption.CheckSyntax(this.option_, this.GetOption(), false, true) && this.CheckInflectionByCatInfl();
        return bl;
    }

    public void SetOption(String string) {
        this.option_ = new Option(string);
        this.PreProcess();
        this.InitDbAndTrie();
    }

    public LvgOutputOption GetLvgOutputOption() {
        return this.lvgOutputOption_;
    }

    public Connection GetConnection() {
        return this.conn_;
    }

    public void CleanUp() {
        try {
            this.Close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean ProcessLine() throws SQLException, IOException {
        if (!this.runFlag_) {
            return false;
        }
        if (this.promptFlag_) {
            this.GetPrompt();
        }
        String string = null;
        if (this.inReader_ == null) {
            this.inReader_ = new BufferedReader(new InputStreamReader(System.in));
        }
        if ((string = this.inReader_.readLine()) == null || this.quitStrList_.contains(string)) {
            return false;
        }
        this.Process(string, false);
        return true;
    }

    public static void PrintLvgHelp() {
        LvgHelp.LvgHelp();
    }

    public void Mutate(String string) {
        try {
            this.Process(string, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String MutateToString(String string) {
        Out.ResetOutString();
        try {
            this.Process(string, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return Out.GetOutString();
    }

    public LvgFlowSpecificOption GetFlowSpecificOptions() {
        return this.lvgFlowSpecificOption_;
    }

    public void SetMinTermLength(int n) {
        if (this.ramTrieI_ != null) {
            this.ramTrieI_.SetMinTermLength(n);
        }
        if (this.ramTrieD_ != null) {
            this.ramTrieD_.SetMinTermLength(n);
        }
    }

    protected void ExecuteCommand(OptionItem optionItem, Option option) {
        OptionItem optionItem2 = OptionUtility.GetItemByName(optionItem, option, false);
        Vector vector = option.GetOptionItems();
        if (SystemOption.CheckOption(optionItem2, "-C:INT")) {
            this.lvgOutputOption_.SetCaseFlag(Integer.parseInt(optionItem2.GetOptionArgument()));
        } else if (SystemOption.CheckOption(optionItem2, "-cf:INT")) {
            this.catFieldNum_ = Integer.parseInt(optionItem2.GetOptionArgument());
        } else if (SystemOption.CheckOption(optionItem2, "-if:INT")) {
            this.inflFieldNum_ = Integer.parseInt(optionItem2.GetOptionArgument());
        } else if (SystemOption.CheckOption(optionItem2, "-ccgi")) {
            this.lvgOutputOption_.SetMarkEndFlag(true);
        } else if (SystemOption.CheckOption(optionItem2, "-CR:o")) {
            this.lvgOutputOption_.SetCombineRule(1);
        } else if (SystemOption.CheckOption(optionItem2, "-CR:oc")) {
            this.lvgOutputOption_.SetCombineRule(2);
        } else if (SystemOption.CheckOption(optionItem2, "-CR:oe")) {
            this.lvgOutputOption_.SetCombineRule(4);
        } else if (SystemOption.CheckOption(optionItem2, "-CR:oi")) {
            this.lvgOutputOption_.SetCombineRule(3);
        } else if (SystemOption.CheckOption(optionItem2, "-DC:LONG")) {
            this.lvgOutputOption_.SetOutCategory(Long.parseLong(optionItem2.GetOptionArgument()));
        } else if (SystemOption.CheckOption(optionItem2, "-DI:LONG")) {
            this.lvgOutputOption_.SetOutInflection(Long.parseLong(optionItem2.GetOptionArgument()));
        } else if (SystemOption.CheckOption(optionItem2, "-EC:LONG")) {
            this.lvgOutputOption_.SetExcludeCategory(Long.parseLong(optionItem2.GetOptionArgument()));
        } else if (SystemOption.CheckOption(optionItem2, "-EI:LONG")) {
            this.lvgOutputOption_.SetExcludeInflection(Long.parseLong(optionItem2.GetOptionArgument()));
        } else if (SystemOption.CheckOption(optionItem2, "-d")) {
            this.detailsFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-h")) {
            LvgHelp.LvgHelp();
            this.runFlag_ = false;
        } else if (SystemOption.CheckOption(optionItem2, "-hs")) {
            option.PrintOptionHierachy();
            this.runFlag_ = false;
        } else if (SystemOption.CheckOption(optionItem2, "-F:INT")) {
            Integer n = new Integer(optionItem2.GetOptionArgument());
            Vector vector2 = this.lvgOutputOption_.GetOutputFieldList();
            vector2.addElement(n);
            this.lvgOutputOption_.SetOutputFieldList(vector2);
        } else if (SystemOption.CheckOption(optionItem2, "-F:h")) {
            LvgHelp.OutputFieldHelp();
            this.runFlag_ = false;
        } else if (SystemOption.CheckOption(optionItem2, "-f:0")) {
            this.flowStrs_.addElement(Flow.GetBitName(12));
        } else if (SystemOption.CheckOption(optionItem2, "-f:A")) {
            this.flowStrs_.addElement(Flow.GetBitName(16));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:An")) {
            this.flowStrs_.addElement(Flow.GetBitName(47));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:a")) {
            this.flowStrs_.addElement(Flow.GetBitName(17));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:B")) {
            this.flowStrs_.addElement(Flow.GetBitName(8));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:Bn")) {
            this.flowStrs_.addElement(Flow.GetBitName(39));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:b")) {
            this.flowStrs_.addElement(Flow.GetBitName(13));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:C")) {
            this.flowStrs_.addElement(Flow.GetBitName(10));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:Ct")) {
            this.flowStrs_.addElement(Flow.GetBitName(38));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:c")) {
            this.flowStrs_.addElement(Flow.GetBitName(21));
        } else if (SystemOption.CheckOption(optionItem2, "-f:ca")) {
            this.flowStrs_.addElement(Flow.GetBitName(43));
        } else if (SystemOption.CheckOption(optionItem2, "-f:ch")) {
            this.flowStrs_.addElement(Flow.GetBitName(22));
        } else if (SystemOption.CheckOption(optionItem2, "-f:d")) {
            this.flowStrs_.addElement(Flow.GetBitName(18));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:dc~LONG")) {
            this.flowStrs_.addElement(Flow.GetBitName(19));
            this.dbFlag_ = true;
            this.derivationCatList_.addElement(optionItem2.GetOptionArgument());
        } else if (SystemOption.CheckOption(optionItem2, "-f:e")) {
            this.flowStrs_.addElement(Flow.GetBitName(23));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:f")) {
            this.flowStrs_.addElement(Flow.GetBitName(29));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:fa")) {
            this.flowStrs_.addElement(Flow.GetBitName(31));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:fp")) {
            this.flowStrs_.addElement(Flow.GetBitName(30));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:E")) {
            this.flowStrs_.addElement(Flow.GetBitName(24));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:G")) {
            this.flowStrs_.addElement(Flow.GetBitName(42));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:Ge")) {
            this.flowStrs_.addElement(Flow.GetBitName(49));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:Gn")) {
            this.flowStrs_.addElement(Flow.GetBitName(45));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:g")) {
            this.flowStrs_.addElement(Flow.GetBitName(3));
        } else if (SystemOption.CheckOption(optionItem2, "-f:h")) {
            LvgHelp.FlowHelp();
            this.runFlag_ = false;
        } else if (SystemOption.CheckOption(optionItem2, "-f:i")) {
            this.flowStrs_.addElement(Flow.GetBitName(1));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:is")) {
            this.flowStrs_.addElement(Flow.GetBitName(51));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:ici~STR+STR")) {
            this.flowStrs_.addElement(Flow.GetBitName(20));
            this.dbFlag_ = true;
            Vector vector3 = OptionItem.GetArgumentList(optionItem2.GetOptionArgument());
            this.inflectionCatList_.addElement((String)vector3.elementAt(0));
            this.inflectionInflList_.addElement((String)vector3.elementAt(1));
            ++this.curInflectionByCatInflNum_;
        } else if (SystemOption.CheckOption(optionItem2, "-f:L")) {
            this.flowStrs_.addElement(Flow.GetBitName(25));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:Ln")) {
            this.flowStrs_.addElement(Flow.GetBitName(26));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:Lp")) {
            this.flowStrs_.addElement(Flow.GetBitName(27));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:l")) {
            this.flowStrs_.addElement(Flow.GetBitName(37));
        } else if (SystemOption.CheckOption(optionItem2, "-f:m")) {
            this.flowStrs_.addElement(Flow.GetBitName(41));
        } else if (SystemOption.CheckOption(optionItem2, "-f:N")) {
            this.flowStrs_.addElement(Flow.GetBitName(9));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:N3")) {
            this.flowStrs_.addElement(Flow.GetBitName(11));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:n")) {
            this.flowStrs_.addElement(Flow.GetBitName(15));
        } else if (SystemOption.CheckOption(optionItem2, "-f:o")) {
            this.flowStrs_.addElement(Flow.GetBitName(4));
        } else if (SystemOption.CheckOption(optionItem2, "-f:P")) {
            this.flowStrs_.addElement(Flow.GetBitName(6));
        } else if (SystemOption.CheckOption(optionItem2, "-f:p")) {
            this.flowStrs_.addElement(Flow.GetBitName(5));
        } else if (SystemOption.CheckOption(optionItem2, "-f:q")) {
            this.flowStrs_.addElement(Flow.GetBitName(40));
        } else if (SystemOption.CheckOption(optionItem2, "-f:R")) {
            this.flowStrs_.addElement(Flow.GetBitName(36));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:r")) {
            this.flowStrs_.addElement(Flow.GetBitName(35));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:S")) {
            this.flowStrs_.addElement(Flow.GetBitName(44));
        } else if (SystemOption.CheckOption(optionItem2, "-f:Si")) {
            this.flowStrs_.addElement(Flow.GetBitName(50));
        } else if (SystemOption.CheckOption(optionItem2, "-f:s")) {
            this.flowStrs_.addElement(Flow.GetBitName(14));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:T")) {
            this.flowStrs_.addElement(Flow.GetBitName(32));
        } else if (SystemOption.CheckOption(optionItem2, "-f:t")) {
            this.flowStrs_.addElement(Flow.GetBitName(2));
        } else if (SystemOption.CheckOption(optionItem2, "-f:U")) {
            this.flowStrs_.addElement(Flow.GetBitName(34));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:u")) {
            this.flowStrs_.addElement(Flow.GetBitName(33));
        } else if (SystemOption.CheckOption(optionItem2, "-f:v")) {
            this.flowStrs_.addElement(Flow.GetBitName(46));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-f:w")) {
            this.flowStrs_.addElement(Flow.GetBitName(7));
        } else if (SystemOption.CheckOption(optionItem2, "-f:ws~INT")) {
            this.flowStrs_.addElement(Flow.GetBitName(48));
            this.wordSize_ = Integer.parseInt(optionItem2.GetOptionArgument());
        } else if (SystemOption.CheckOption(optionItem2, "-f:y")) {
            this.flowStrs_.addElement(Flow.GetBitName(28));
            this.dbFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-i:STR")) {
            String string = optionItem2.GetOptionArgument();
            if (string != null) {
                try {
                    this.inReader_ = new BufferedReader(new FileReader(string));
                }
                catch (IOException iOException) {
                    this.runFlag_ = false;
                    System.err.println("**Error: problem of opening/reading file " + string);
                }
            }
        } else if (SystemOption.CheckOption(optionItem2, "-kd:INT")) {
            this.lvgFlowSpecificOption_.SetDerivationFilter(Integer.parseInt(optionItem2.GetOptionArgument()));
        } else if (SystemOption.CheckOption(optionItem2, "-ki:INT")) {
            this.lvgFlowSpecificOption_.SetInflectionFilter(Integer.parseInt(optionItem2.GetOptionArgument()));
        } else if (SystemOption.CheckOption(optionItem2, "-m")) {
            this.mutateFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-n")) {
            this.lvgOutputOption_.SetNoOutputFlag(true);
        } else if (SystemOption.CheckOption(optionItem2, "-o:STR")) {
            String string = optionItem2.GetOptionArgument();
            if (string != null) {
                try {
                    this.outWriter_ = new BufferedWriter(new FileWriter(string));
                }
                catch (IOException iOException) {
                    this.runFlag_ = false;
                    System.err.println("**Error: problem of opening/writing file " + string);
                }
            }
        } else if (SystemOption.CheckOption(optionItem2, "-p")) {
            this.promptFlag_ = true;
        } else if (SystemOption.CheckOption(optionItem2, "-R:INT")) {
            this.lvgOutputOption_.SetOutRecordNum(Integer.parseInt(optionItem2.GetOptionArgument()));
        } else if (SystemOption.CheckOption(optionItem2, "-SC")) {
            this.lvgOutputOption_.SetShowCategoryStrFlag(true);
        } else if (SystemOption.CheckOption(optionItem2, "-SI")) {
            this.lvgOutputOption_.SetShowInflectionStrFlag(true);
        } else if (SystemOption.CheckOption(optionItem2, "-St:o")) {
            this.lvgOutputOption_.SetSortFlag(1);
        } else if (SystemOption.CheckOption(optionItem2, "-St:oc")) {
            this.lvgOutputOption_.SetSortFlag(2);
        } else if (SystemOption.CheckOption(optionItem2, "-St:oci")) {
            this.lvgOutputOption_.SetSortFlag(3);
        } else if (SystemOption.CheckOption(optionItem2, "-s:STR")) {
            GlobalBehavior.SetFieldSeparator(optionItem2.GetOptionArgument());
        } else if (SystemOption.CheckOption(optionItem2, "-t:INT")) {
            this.termFieldNum_ = Integer.parseInt(optionItem2.GetOptionArgument());
        } else if (SystemOption.CheckOption(optionItem2, "-ti")) {
            this.lvgOutputOption_.SetFilterInputFlag(true);
        } else if (SystemOption.CheckOption(optionItem2, "-v")) {
            try {
                Out.Println(this.outWriter_, "lvg.2003", false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.runFlag_ = false;
        } else if (SystemOption.CheckOption(optionItem2, "-x:STR")) {
            this.configFile_ = optionItem2.GetOptionArgument();
        }
    }

    protected void DefineFlag() {
        String string = "-cf:INT -C:INT -ccgi -CR:o:oc:oe:oi -DC:LONG -DI:LONG -d -EC:LONG -EI:LONG -F:INT:h -f:0:A:An:a:B:Bn:b:C:Ct:c:ca:ch:d:dc~LONG:e:E:f:fa:fp:G::Ge:Gn:g:h:i:is:ici~STR+STR:L:Ln:Lp:l:m:N:N3:n:o:P:p:q:R:r:S:Si:s:T:t:U:u:v:w:ws~INT:y -h -hs -i:STR -if:INT -kd:INT -ki:INT -m -n -o:STR -p -R:INT -SC -SI -St:o:oc:oci -s:STR -t:INT -ti -v -x:STR";
        this.systemOption_ = new Option(string);
        this.systemOption_.SetFlagFullName("-cf:INT", "Input_category_field");
        this.systemOption_.SetFlagFullName("-C:INT", "Case_setting");
        this.systemOption_.SetFlagFullName("-ccgi", "Mark_the_end");
        this.systemOption_.SetFlagFullName("-CR:o", "Combine_By_Output_Term");
        this.systemOption_.SetFlagFullName("-CR:oc", "Combine_By_Category");
        this.systemOption_.SetFlagFullName("-CR:oe", "Combine_By_Eui");
        this.systemOption_.SetFlagFullName("-CR:oi", "Combine_By_Inflection");
        this.systemOption_.SetFlagFullName("-DC:LONG", "Specify_Categories");
        this.systemOption_.SetFlagFullName("-DI:LONG", "Specify_Inflections");
        this.systemOption_.SetFlagFullName("-d", "Detail_Operations");
        this.systemOption_.SetFlagFullName("-EC:LONG", "Exclude_Categories");
        this.systemOption_.SetFlagFullName("-EI:LONG", "Exclude_Inflections");
        this.systemOption_.SetFlagFullName("-F:INT", "Output_Field");
        this.systemOption_.SetFlagFullName("-F:h", "Output_Field_Menu");
        this.systemOption_.SetFlagFullName("-f", "Flow");
        this.systemOption_.SetFlagFullName("-f:0", "Strip_NEC_NOS");
        this.systemOption_.SetFlagFullName("-f:A", "Acronyms");
        this.systemOption_.SetFlagFullName("-f:An", "AntiNorm");
        this.systemOption_.SetFlagFullName("-f:a", "Expansions");
        this.systemOption_.SetFlagFullName("-f:B", "Uninflect_Words");
        this.systemOption_.SetFlagFullName("-f:Bn", "Normalize_Uninflect_Words");
        this.systemOption_.SetFlagFullName("-f:b", "Uninflect_Term");
        this.systemOption_.SetFlagFullName("-f:C", "Canonicalize");
        this.systemOption_.SetFlagFullName("-f:Ct", "Citation");
        this.systemOption_.SetFlagFullName("-f:c", "Tokenize");
        this.systemOption_.SetFlagFullName("-f:ca", "Tokenize_Keep_All");
        this.systemOption_.SetFlagFullName("-f:ch", "Tokenize_No_Hyphens");
        this.systemOption_.SetFlagFullName("-f:d", "Derivation");
        this.systemOption_.SetFlagFullName("-f:dc~LONG", "Derivation_By_Category");
        this.systemOption_.SetFlagFullName("-f:e", "Base_From_Spelling_Variants");
        this.systemOption_.SetFlagFullName("-f:E", "Retrieve_Eui");
        this.systemOption_.SetFlagFullName("-f:f", "Filter_Output");
        this.systemOption_.SetFlagFullName("-f:fa", "Filter_Out_Acronym");
        this.systemOption_.SetFlagFullName("-f:fp", "Filter_Out_ProperNouns");
        this.systemOption_.SetFlagFullName("-f:G", "Fruitful_Variants");
        this.systemOption_.SetFlagFullName("-f:Ge", "Fruitful_Variants_Enhanced");
        this.systemOption_.SetFlagFullName("-f:Gn", "Fruitful_Variants_Lex");
        this.systemOption_.SetFlagFullName("-f:g", "Remove_Genitive");
        this.systemOption_.SetFlagFullName("-f:h", "Flow_Help_Menu");
        this.systemOption_.SetFlagFullName("-f:i", "Inflection");
        this.systemOption_.SetFlagFullName("-f:is", "Inflection_Simple");
        this.systemOption_.SetFlagFullName("-f:ici~STR+STR", "Inflection_By_Cat_Infl");
        this.systemOption_.SetFlagFullName("-f:L", "Retrieve_Cat_Infl");
        this.systemOption_.SetFlagFullName("-f:Ln", "Retrieve_Cat_Infl_Db");
        this.systemOption_.SetFlagFullName("-f:Lp", "Retrieve_Cat_Infl_Begin");
        this.systemOption_.SetFlagFullName("-f:l", "LowerCase");
        this.systemOption_.SetFlagFullName("-f:m", "Metaphone");
        this.systemOption_.SetFlagFullName("-f:N", "Normalize");
        this.systemOption_.SetFlagFullName("-f:N3", "LuiNormalize");
        this.systemOption_.SetFlagFullName("-f:n", "No_Operation");
        this.systemOption_.SetFlagFullName("-f:o", "Replace_Punctuation_With_Space");
        this.systemOption_.SetFlagFullName("-f:P", "Strip_Punctuation_Enhanced");
        this.systemOption_.SetFlagFullName("-f:p", "Strip_Punctuation");
        this.systemOption_.SetFlagFullName("-f:q", "Strip_Diacritics");
        this.systemOption_.SetFlagFullName("-f:R", "Recursive_Derivations");
        this.systemOption_.SetFlagFullName("-f:r", "Recursive_Synonyms");
        this.systemOption_.SetFlagFullName("-f:S", "Syntactic_Uninvert");
        this.systemOption_.SetFlagFullName("-f:Si", "Simple_Inflections");
        this.systemOption_.SetFlagFullName("-f:s", "Spelling_Variants");
        this.systemOption_.SetFlagFullName("-f:T", "Strip_Ambiguity_Tags");
        this.systemOption_.SetFlagFullName("-f:t", "Strip_Stop_Words");
        this.systemOption_.SetFlagFullName("-f:U", "Convert_Output");
        this.systemOption_.SetFlagFullName("-f:u", "Uninvert");
        this.systemOption_.SetFlagFullName("-f:v", "Fruitful_Variants_Db");
        this.systemOption_.SetFlagFullName("-f:w", "Sort_By_Word_Order");
        this.systemOption_.SetFlagFullName("-f:ws~INT", "Word_Size_Filter");
        this.systemOption_.SetFlagFullName("-f:y", "Synonyms");
        this.systemOption_.SetFlagFullName("-h", "Help");
        this.systemOption_.SetFlagFullName("-hs", "Hierarchy_Struture");
        this.systemOption_.SetFlagFullName("-i:STR", "Input_File");
        this.systemOption_.SetFlagFullName("-if:INT", "Input_inflection_field");
        this.systemOption_.SetFlagFullName("-kd:INT", "Restrict_Derivations");
        this.systemOption_.SetFlagFullName("-ki:INT", "Restrict_Inflections");
        this.systemOption_.SetFlagFullName("-m", "Mutation_Information");
        this.systemOption_.SetFlagFullName("-n", "No_Output");
        this.systemOption_.SetFlagFullName("-o:STR", "Output_file");
        this.systemOption_.SetFlagFullName("-p", "Show_Prompt");
        this.systemOption_.SetFlagFullName("-R:INT", "Restrict_Out_Number");
        this.systemOption_.SetFlagFullName("-SC", "Show_Category_String");
        this.systemOption_.SetFlagFullName("-SI", "Show_Inflection_String");
        this.systemOption_.SetFlagFullName("-St:o", "Sort_By_Term");
        this.systemOption_.SetFlagFullName("-St:oc", "Sort_By_Term_Cat");
        this.systemOption_.SetFlagFullName("-St:oci", "Sort_By_Term_Cat_Infl");
        this.systemOption_.SetFlagFullName("-s:STR", "Field_Separator");
        this.systemOption_.SetFlagFullName("-t:INT", "Term_Field");
        this.systemOption_.SetFlagFullName("-ti", "Filter_Input_Term");
        this.systemOption_.SetFlagFullName("-v", "Version");
        this.systemOption_.SetFlagFullName("-x:STR", "Load_Configuration_file");
    }

    protected void GetPrompt() throws IOException {
        Out.Println(this.outWriter_, this.promptStr_, false);
    }

    protected Vector ExecuteFlow(LexItem lexItem, String string) throws SQLException {
        long l = Flow.Enumerate(string);
        Vector vector = new Vector();
        this.curDerivationCatNum_ = 0;
        this.curInflectionByCatInflCount_ = 0;
        this.curInflectionByCatInflNum_ = 0;
        if (l == Flow.GetBitValue(37)) {
            vector = ToLowerCase.Mutate(lexItem, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(2)) {
            vector = ToStripStopWords.Mutate(lexItem, this.stopWords_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(3)) {
            vector = ToRemoveGenitive.Mutate(lexItem, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(4)) {
            vector = ToReplacePunctuationWithSpace.Mutate(lexItem, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(5)) {
            vector = ToStripPunctuation.Mutate(lexItem, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(6)) {
            vector = ToStripPunctuationEnhanced.Mutate(lexItem, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(7)) {
            vector = ToSortWordsByOrder.Mutate(lexItem, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(12)) {
            vector = ToStripNecNos.Mutate(lexItem, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(15)) {
            vector = ToNoOperation.Mutate(lexItem, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(21)) {
            vector = ToTokenize.Mutate(lexItem, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(22)) {
            vector = ToTokenizeNoHyphens.Mutate(lexItem, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(13)) {
            vector = ToUninflectTerm.Mutate(lexItem, this.conn_, this.ramTrieI_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(1)) {
            vector = ToInflection.Mutate(lexItem, this.conn_, this.ramTrieI_, this.lvgFlowSpecificOption_.GetInflectionFilter(), this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(8)) {
            vector = ToUninflectWords.Mutate(lexItem, this.lvgFlowSpecificOption_.GetMaxPermuteTermNum(), this.conn_, this.ramTrieI_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(9)) {
            vector = ToNormalize.Mutate(lexItem, this.lvgFlowSpecificOption_.GetMaxPermuteTermNum(), this.stopWords_, this.conn_, this.ramTrieI_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(10)) {
            vector = ToCanonicalize.Mutate(lexItem, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(11)) {
            vector = ToLuiNormalize.Mutate(lexItem, this.lvgFlowSpecificOption_.GetMaxPermuteTermNum(), this.stopWords_, this.conn_, this.ramTrieI_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(14)) {
            vector = ToSpellingVariants.Mutate(lexItem, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(16)) {
            vector = ToAcronyms.Mutate(lexItem, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(17)) {
            vector = ToExpansions.Mutate(lexItem, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(18)) {
            vector = ToDerivation.Mutate(lexItem, this.conn_, this.ramTrieD_, this.lvgFlowSpecificOption_.GetDerivationFilter(), this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(19)) {
            long l2 = Long.parseLong((String)this.derivationCatList_.elementAt(this.curDerivationCatNum_));
            ++this.curDerivationCatNum_;
            vector = ToDerivationByCategory.Mutate(lexItem, this.conn_, this.ramTrieD_, this.lvgFlowSpecificOption_.GetDerivationFilter(), l2, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(20)) {
            long l3 = Long.parseLong((String)this.inflectionCatList_.elementAt(this.curInflectionByCatInflCount_));
            long l4 = Long.parseLong((String)this.inflectionInflList_.elementAt(this.curInflectionByCatInflCount_));
            ++this.curInflectionByCatInflCount_;
            vector = ToInflectionByCatInfl.Mutate(lexItem, this.conn_, this.ramTrieI_, this.lvgFlowSpecificOption_.GetInflectionFilter(), l3, l4, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(23)) {
            vector = ToBaseSpellingVariants.Mutate(lexItem, this.conn_, this.ramTrieI_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(24)) {
            vector = ToRetrieveEui.Mutate(lexItem, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(25)) {
            vector = ToRetrieveCatInfl.Mutate(lexItem, this.conn_, this.ramTrieI_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(26)) {
            vector = ToRetrieveCatInflDb.Mutate(lexItem, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(27)) {
            vector = ToRetrieveCatInflBegin.Mutate(lexItem, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(28)) {
            vector = ToSynonyms.Mutate(lexItem, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(29)) {
            vector = ToFilter.Mutate(lexItem, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(30)) {
            vector = ToFilterProperNoun.Mutate(lexItem, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(31)) {
            vector = ToFilterAcronym.Mutate(lexItem, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(32)) {
            vector = ToStripAmbiguityTags.Mutate(lexItem, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(33)) {
            vector = ToUninvert.Mutate(lexItem, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(34)) {
            vector = ToConvertOutput.Mutate(lexItem, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(35)) {
            vector = ToRecursiveSynonyms.Mutate(lexItem, this.conn_, this.detailsFlag_, this.mutateFlag_, false);
        } else if (l == Flow.GetBitValue(36)) {
            vector = ToRecursiveDerivations.Mutate(lexItem, this.conn_, this.ramTrieD_, this.lvgFlowSpecificOption_.GetDerivationFilter(), this.detailsFlag_, this.mutateFlag_, false);
        } else if (l == Flow.GetBitValue(38)) {
            vector = ToCitation.Mutate(lexItem, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(39)) {
            vector = ToNormUninflectWords.Mutate(lexItem, this.lvgFlowSpecificOption_.GetMaxPermuteTermNum(), this.conn_, this.ramTrieI_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(40)) {
            vector = ToStripDiacritics.Mutate(lexItem, this.diacriticMap_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(41)) {
            vector = ToMetaphone.Mutate(lexItem, this.lvgFlowSpecificOption_.GetMaxMetaphoneCodeLength(), this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(42)) {
            vector = ToFruitfulVariants.Mutate(lexItem, this.conn_, this.ramTrieI_, this.ramTrieD_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(43)) {
            vector = ToTokenizeKeepAll.Mutate(lexItem, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(44)) {
            vector = ToSyntacticUninvert.Mutate(lexItem, this.nonInfoWords_, this.conjunctionWords_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(45)) {
            vector = ToFruitfulVariantsLex.Mutate(lexItem, this.conn_, this.ramTrieI_, this.ramTrieD_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(46)) {
            vector = ToFruitfulVariantsDb.Mutate(lexItem, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(47)) {
            vector = ToAntiNorm.Mutate(lexItem, this.lvgFlowSpecificOption_.GetMaxPermuteTermNum(), this.stopWords_, this.conn_, this.ramTrieI_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(48)) {
            vector = ToWordSize.Mutate(lexItem, this.wordSize_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(49)) {
            vector = ToFruitfulEnhanced.Mutate(lexItem, this.conn_, this.ramTrieI_, this.ramTrieD_, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(50)) {
            vector = ToSimpleInflections.Mutate(lexItem, this.detailsFlag_, this.mutateFlag_);
        } else if (l == Flow.GetBitValue(51)) {
            vector = ToInflectionSimple.Mutate(lexItem, this.conn_, this.ramTrieI_, this.lvgFlowSpecificOption_.GetInflectionFilter(), this.detailsFlag_, this.mutateFlag_);
        }
        return vector;
    }

    private void Process(String string, boolean bl) throws SQLException, IOException {
        this.originalTerm_ = string;
        String string2 = GlobalBehavior.GetFieldSeparator();
        String string3 = InputFilter.GetInputTerm(string, string2, this.termFieldNum_);
        long l = InputFilter.GetInputCategory(string, string2, this.catFieldNum_);
        long l2 = InputFilter.GetInputInflection(string, string2, this.inflFieldNum_);
        int n = 0;
        while (n < this.flowStrsList_.size()) {
            Object object;
            LexItem lexItem = new LexItem(string3, l, l2);
            this.flowStrs_ = (Vector)this.flowStrsList_.elementAt(n);
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            vector.addElement(lexItem);
            int n2 = 0;
            while (n2 < this.flowStrs_.size()) {
                object = new Vector();
                int n3 = 0;
                while (n3 < vector.size()) {
                    LexItem lexItem2 = (LexItem)vector.elementAt(n3);
                    lexItem2.SetFlowNumber(n + 1);
                    Vector vector3 = this.ExecuteFlow(lexItem2, (String)this.flowStrs_.elementAt(n2));
                    ((Vector)object).addAll(vector3);
                    ++n3;
                }
                vector2.removeAllElements();
                vector2.addAll(object);
                vector = LexItem.TargetsToSources(vector2);
                ++n2;
            }
            object = OutputFilter.ExecuteOutputFilter(vector2, this.mutateFlag_, this.detailsFlag_, string2, this.originalTerm_, this.lvgOutputOption_);
            Out.Print(this.outWriter_, (String)object, bl);
            ++n;
        }
    }

    private boolean CheckInflectionByCatInfl() {
        boolean bl = true;
        int n = 0;
        while (n < this.curInflectionByCatInflNum_) {
            String string = (String)this.inflectionCatList_.elementAt(n);
            try {
                Long.parseLong(string);
            }
            catch (Exception exception) {
                if (string.equalsIgnoreCase("all")) {
                    this.inflectionCatList_.setElementAt(Long.toString(2047L), n);
                }
                System.out.println("** Error: Illegal category value (" + string + ") for -f:ici.");
                bl = false;
            }
            String string2 = (String)this.inflectionInflList_.elementAt(n);
            try {
                Long.parseLong(string2);
            }
            catch (Exception exception) {
                if (string2.equalsIgnoreCase("all")) {
                    this.inflectionInflList_.setElementAt(Long.toString(0xFFFFFFL), n);
                }
                System.out.println("** Error: Illegal inflection value (" + string2 + ") for -f:ici.");
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    private static Vector GetOptions(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }

    private void Init() {
        this.PreProcess();
        this.InitConfigVars();
        this.InitDbAndTrie();
    }

    private void Init(Hashtable hashtable) {
        this.PreProcess();
        this.InitConfigVars(hashtable);
        this.InitDbAndTrie(hashtable);
    }

    private void PreProcess() {
        int n = 0;
        Vector vector = LvgCmdApi.GetOptions(this.option_.GetOptionStr());
        this.flowStrsList_.removeAllElements();
        this.lvgOutputOption_.GetOutputFieldList().removeAllElements();
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = (String)vector.elementAt(n2);
            Option option = new Option(string);
            if (LvgCmdApi.IsNewFlow(string)) {
                ++this.flowNum_;
                this.flowStrs_ = new Vector();
            }
            this.ExecuteCommands(option, this.GetOption());
            if (this.flowNum_ > 0 && this.flowNum_ != n) {
                this.flowStrsList_.addElement(this.flowStrs_);
                n = this.flowNum_;
            }
            ++n2;
        }
    }

    private void InitDbAndTrie() {
        int n = Integer.parseInt(this.conf_.GetConfiguration("MIN_TERM_LENGTH"));
        String string = this.conf_.GetConfiguration("LVG_DIR");
        int n2 = Integer.parseInt(this.conf_.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        try {
            if (this.dbFlag_ && this.conn_ == null) {
                this.conn_ = DbBase.OpenConnection(this.conf_);
            }
            if (this.ramTrieI_ == null) {
                this.ramTrieI_ = new RamTrie(true, n, string, 0);
            }
            if (this.ramTrieD_ == null) {
                this.ramTrieD_ = new RamTrie(false, n, string, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void InitDbAndTrie(Hashtable hashtable) {
        int n = Integer.parseInt(this.conf_.GetConfiguration("MIN_TERM_LENGTH"));
        String string = this.conf_.GetConfiguration("LVG_DIR");
        int n2 = Integer.parseInt(this.conf_.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        try {
            if (this.dbFlag_ && this.conn_ == null) {
                this.conn_ = DbBase.OpenConnection(this.conf_, hashtable);
            }
            if (this.ramTrieI_ == null) {
                this.ramTrieI_ = new RamTrie(true, n, string, 0);
            }
            if (this.ramTrieD_ == null) {
                this.ramTrieD_ = new RamTrie(false, n, string, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void InitConfigVars() {
        boolean bl = false;
        if (this.configFile_ == null) {
            bl = true;
            this.configFile_ = "data.config.lvg";
        }
        this.conf_ = new Configuration(this.configFile_, bl);
        if (this.lvgOutputOption_.GetOutRecordNum() == -1) {
            this.lvgOutputOption_.SetOutRecordNum(Integer.parseInt(this.conf_.GetConfiguration("TRUNCATED_RESULTS")));
        }
        if (this.lvgOutputOption_.GetNoOutputStr() == null) {
            this.lvgOutputOption_.SetNoOutputStr(this.conf_.GetConfiguration("NO_OUTPUT"));
        }
        if (this.lvgOutputOption_.GetMarkEndStr() == null) {
            this.lvgOutputOption_.SetMarkEndStr(this.conf_.GetConfiguration("CGI_EOP"));
        }
        this.promptStr_ = Platform.IsWindow() ? "- Please input a term (type \"Ctl-z\" then \"Enter\" to quit) >" : "- Please input a term (type \"Ctl-d\" to quit) >";
        if (!this.conf_.GetConfiguration("LVG_PROMPT").equals("DEFAULT")) {
            this.promptStr_ = this.conf_.GetConfiguration("LVG_PROMPT");
        }
        if (this.lvgFlowSpecificOption_.GetMaxPermuteTermNum() == -1) {
            this.lvgFlowSpecificOption_.SetMaxPermuteTermNum(Integer.parseInt(this.conf_.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS")));
        }
        if (this.lvgFlowSpecificOption_.GetMaxMetaphoneCodeLength() == -1) {
            this.lvgFlowSpecificOption_.SetMaxMetaphoneCodeLength(Integer.parseInt(this.conf_.GetConfiguration("MAX_METAPHONE")));
        }
        if (this.stopWords_ == null) {
            this.stopWords_ = ToStripStopWords.GetStopWordsFromFile(this.conf_);
        }
        if (this.nonInfoWords_ == null) {
            this.nonInfoWords_ = ToSyntacticUninvert.GetNonInfoWordsFromFile(this.conf_);
        }
        if (this.conjunctionWords_ == null) {
            this.conjunctionWords_ = ToSyntacticUninvert.GetConjunctionWordsFromFile(this.conf_);
        }
        if (this.diacriticMap_ == null) {
            this.diacriticMap_ = ToStripDiacritics.GetDiacriticsFromFile(this.conf_);
        }
    }

    private void InitConfigVars(Hashtable hashtable) {
        boolean bl = false;
        if (this.configFile_ == null) {
            bl = true;
            this.configFile_ = "data.config.lvg";
        }
        this.conf_ = new Configuration(this.configFile_, bl);
        if (this.lvgOutputOption_.GetOutRecordNum() == -1) {
            this.lvgOutputOption_.SetOutRecordNum(Integer.parseInt(Configuration.OverWriteProperty("TRUNCATED_RESULTS", this.conf_, hashtable)));
        }
        if (this.lvgOutputOption_.GetNoOutputStr() == null) {
            this.lvgOutputOption_.SetNoOutputStr(Configuration.OverWriteProperty("NO_OUTPUT", this.conf_, hashtable));
        }
        if (this.lvgOutputOption_.GetMarkEndStr() == null) {
            this.lvgOutputOption_.SetMarkEndStr(Configuration.OverWriteProperty("CGI_EOP", this.conf_, hashtable));
        }
        this.promptStr_ = Platform.IsWindow() ? "- Please input a term (type \"Ctl-z\" then \"Enter\" to quit) >" : "- Please input a term (type \"Ctl-d\" to quit) >";
        if (!Configuration.OverWriteProperty("LVG_PROMPT", this.conf_, hashtable).equals("DEFAULT")) {
            this.promptStr_ = Configuration.OverWriteProperty("LVG_PROMPT", this.conf_, hashtable);
        }
        if (this.lvgFlowSpecificOption_.GetMaxPermuteTermNum() == -1) {
            this.lvgFlowSpecificOption_.SetMaxPermuteTermNum(Integer.parseInt(Configuration.OverWriteProperty("MAX_RULE_UNINFLECTED_TERMS", this.conf_, hashtable)));
        }
        if (this.lvgFlowSpecificOption_.GetMaxMetaphoneCodeLength() == -1) {
            this.lvgFlowSpecificOption_.SetMaxMetaphoneCodeLength(Integer.parseInt(Configuration.OverWriteProperty("MAX_METAPHONE", this.conf_, hashtable)));
        }
        if (this.stopWords_ == null) {
            this.stopWords_ = ToStripStopWords.GetStopWordsFromFile(this.conf_);
        }
        if (this.nonInfoWords_ == null) {
            this.nonInfoWords_ = ToSyntacticUninvert.GetNonInfoWordsFromFile(this.conf_);
        }
        if (this.conjunctionWords_ == null) {
            this.conjunctionWords_ = ToSyntacticUninvert.GetConjunctionWordsFromFile(this.conf_);
        }
        if (this.diacriticMap_ == null) {
            this.diacriticMap_ = ToStripDiacritics.GetDiacriticsFromFile(this.conf_);
        }
    }

    private void Close() throws IOException, SQLException {
        if (this.outWriter_ != null) {
            this.outWriter_.close();
        }
        if (this.inReader_ != null) {
            this.inReader_.close();
        }
        if (this.conn_ != null) {
            DbBase.CloseConnection(this.conn_);
        }
    }

    private static boolean IsNewFlow(String string) {
        boolean bl = false;
        if (string.length() >= 3 && string.substring(0, 3).equals("-f:")) {
            bl = true;
        }
        return bl;
    }
}

