/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Api;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToNormalize;
import gov.nih.nlm.nls.lvg.Flows.ToStripStopWords;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class NormApi {
    private String configFile_ = null;
    private Connection conn_ = null;
    private RamTrie ramTrieI_ = null;
    private int maxTerm_ = -1;
    private Vector stopWords_ = null;

    public NormApi() {
        this.Init();
    }

    public NormApi(String string) {
        this.configFile_ = string;
        this.Init();
    }

    public NormApi(String string, Hashtable hashtable) {
        this.configFile_ = string;
        this.Init(hashtable);
    }

    public NormApi(Connection connection, RamTrie ramTrie) {
        this.conn_ = connection;
        this.ramTrieI_ = ramTrie;
    }

    public Vector Mutate(LexItem lexItem) {
        Vector vector = new Vector();
        try {
            vector = ToNormalize.Mutate(lexItem, this.maxTerm_, this.stopWords_, this.conn_, this.ramTrieI_, false, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    public Vector Mutate(String string) {
        LexItem lexItem = new LexItem(string);
        Vector vector = this.Mutate(lexItem);
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        while (n < vector.size()) {
            LexItem lexItem2 = (LexItem)vector.elementAt(n);
            vector2.addElement(lexItem2.GetTargetTerm());
            ++n;
        }
        return vector2;
    }

    public Vector Mutate(String string, boolean bl) {
        LexItem lexItem = new LexItem(string);
        Vector vector = new Vector();
        try {
            vector = ToNormalize.Mutate(lexItem, this.maxTerm_, this.stopWords_, this.conn_, this.ramTrieI_, bl, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    public void CleanUp() {
        try {
            this.Close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Connection GetConnection() {
        return this.conn_;
    }

    public RamTrie GetTrie() {
        return this.ramTrieI_;
    }

    private void Init() {
        boolean bl = false;
        if (this.configFile_ == null) {
            bl = true;
            this.configFile_ = "data.config.lvg";
        }
        Configuration configuration = new Configuration(this.configFile_, bl);
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string = configuration.GetConfiguration("LVG_DIR");
        if (this.maxTerm_ == -1) {
            this.maxTerm_ = Integer.parseInt(configuration.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS"));
        }
        if (this.stopWords_ == null) {
            this.stopWords_ = ToStripStopWords.GetStopWordsFromFile(configuration);
        }
        try {
            if (this.conn_ == null) {
                this.conn_ = DbBase.OpenConnection(configuration);
            }
            if (this.ramTrieI_ == null) {
                this.ramTrieI_ = new RamTrie(true, n, string, 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void Init(Hashtable hashtable) {
        boolean bl = false;
        if (this.configFile_ == null) {
            bl = true;
            this.configFile_ = "data.config.lvg";
        }
        Configuration configuration = new Configuration(this.configFile_, bl);
        String string = Configuration.OverWriteProperty("MIN_TERM_LENGTH", configuration, hashtable);
        int n = Integer.parseInt(string);
        String string2 = Configuration.OverWriteProperty("LVG_DIR", configuration, hashtable);
        if (this.maxTerm_ == -1) {
            String string3 = Configuration.OverWriteProperty("MAX_RULE_UNINFLECTED_TERMS", configuration, hashtable);
            this.maxTerm_ = Integer.parseInt(string3);
        }
        if (this.stopWords_ == null) {
            this.stopWords_ = ToStripStopWords.GetStopWordsFromFile(configuration);
        }
        try {
            if (this.conn_ == null) {
                this.conn_ = DbBase.OpenConnection(configuration, hashtable);
            }
            if (this.ramTrieI_ == null) {
                this.ramTrieI_ = new RamTrie(true, n, string2, 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void Close() throws IOException, SQLException {
        if (this.conn_ != null) {
            DbBase.CloseConnection(this.conn_);
        }
    }
}

