/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.CmdLineSyntax;

import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionFlag;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionList;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class Option {
    public static final int MAX_LEVEL = 5;
    public static final char ARGUMENT_SEP = '+';
    public static final char[] SEPARATOR = new char[]{'-', ':', '~', '^', '#'};
    public static final String ROOT = "Root";
    public static final String BOOLEAN_ARGUMENT = "BLN";
    public static final String STRING_ARGUMENT = "STR";
    public static final String INT_ARGUMENT = "INT";
    public static final String LONG_ARGUMENT = "LONG";
    public static final String FLOAT_ARGUMENT = "FLT";
    private static String[] parentStr_ = new String[]{"", "", "", "", ""};
    private String optionStr_ = null;
    private OptionList optionList_ = new OptionList();
    private Vector optionItems_ = new Vector(1);

    public Option(String string) {
        this.optionStr_ = string;
        this.FormOptionList(string);
        this.Init();
    }

    public Option(OptionList optionList) {
        this.optionStr_ = OptionUtility.ToOptionString(optionList);
        this.optionList_ = optionList;
        this.Init();
    }

    public void SetFlagFullName(String string, String string2) {
        OptionFlag optionFlag = this.GetOptionFlag(this.optionList_, string, 0);
        if (optionFlag != null) {
            optionFlag.SetFullName(string2);
        }
    }

    public String GetOptionStr() {
        return this.optionStr_;
    }

    public OptionList GetOptionList() {
        return this.optionList_;
    }

    public Vector GetOptionItems() {
        return this.optionItems_;
    }

    public Vector GetOptionItemStrs() {
        return this.GetOptionItem(this.optionList_);
    }

    public void PrintOptionHierachy() {
        this.PrintOptionList(this.optionList_);
    }

    public void PrintOptionLeaf() {
        this.PrintOptionItems(this.optionList_);
    }

    public static void main(String[] stringArray) {
        Object object;
        Option option = new Option("-a:aa~123+45+78:ab~aba~12:ac:ad~ada -b:bb:bc~bca+bcb:bd:be -c");
        if (stringArray.length > 0) {
            object = "";
            int n = 0;
            while (n < stringArray.length) {
                object = (String)object + stringArray[n];
                ++n;
            }
            option = new Option((String)object);
        }
        System.out.println("------------ Option String --------------");
        System.out.println("Option String: " + option.GetOptionStr());
        System.out.println("------------ Hierachy -------------------");
        option.PrintOptionHierachy();
        System.out.println("------------ Option Leaf -------------------");
        option.PrintOptionLeaf();
        System.out.println("------------ Option String -------------------");
        System.out.println(OptionUtility.ToOptionString(option.GetOptionList()));
        object = new Option(option.GetOptionList());
        System.out.println("------------ Option1 String -------------------");
        System.out.println(((Option)object).GetOptionStr());
        System.out.println("------------ GetOptionStr() -------------------");
        System.out.println(OptionUtility.GetOptionStr(((Option)object).GetOptionItems()));
    }

    private void Init() {
        Vector vector = this.GetOptionItemStrs();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            OptionItem optionItem = new OptionItem(string);
            this.optionItems_.addElement(optionItem);
            ++n;
        }
    }

    private Vector GetOptionItem(OptionList optionList) {
        Vector<Object> vector = new Vector<Object>(1);
        ListIterator listIterator = optionList.listIterator();
        while (listIterator.hasNext()) {
            int n;
            Object object;
            OptionFlag optionFlag = (OptionFlag)listIterator.next();
            if (optionFlag.GetChild() != null) {
                Option.parentStr_[optionFlag.GetLevel()] = optionFlag.GetName();
                object = this.GetOptionItem(optionFlag.GetChild());
                n = 0;
                while (n < ((Vector)object).size()) {
                    vector.addElement(((Vector)object).elementAt(n));
                    ++n;
                }
                continue;
            }
            object = "";
            n = 0;
            while (n < optionFlag.GetLevel()) {
                object = (String)object + SEPARATOR[n] + parentStr_[n];
                ++n;
            }
            object = (String)object + SEPARATOR[optionFlag.GetLevel()] + optionFlag.GetName();
            vector.addElement(object);
        }
        return vector;
    }

    private void PrintOptionItems(OptionList optionList) {
        Vector vector = this.GetOptionItem(optionList);
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            System.out.println(string + "=> " + OptionItem.GetOptionFlag(string) + ", " + OptionItem.GetOptionArgument(string));
            ++n;
        }
    }

    private void PrintOptionList(OptionList optionList) {
        ListIterator listIterator = optionList.listIterator();
        while (listIterator.hasNext()) {
            OptionFlag optionFlag = (OptionFlag)listIterator.next();
            this.PrintLevelIndent(optionFlag.GetLevel());
            System.out.print(" " + optionFlag.GetName());
            if (optionFlag.GetFullName() == null) {
                System.out.println("");
            } else {
                System.out.println(" (" + optionFlag.GetFullName() + ")");
            }
            if (optionFlag.GetChild() == null) continue;
            this.PrintOptionList(optionFlag.GetChild());
        }
    }

    private void PrintLevelIndent(int n) {
        int n2 = n * 2 + 1;
        int n3 = 0;
        while (n3 < n2) {
            System.out.print("-");
            ++n3;
        }
    }

    private void FormOptionList(String string) {
        this.Compose(string, 0);
    }

    private void Compose(String string, int n) {
        if (n < 5) {
            String string2 = " " + SEPARATOR[n];
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                this.AddCurFlag(string3, n);
                String string4 = this.GetNextLevelItemStr(string3, n);
                if (string4 != null) {
                    this.Compose(string4, n + 1);
                    continue;
                }
                if (stringTokenizer.hasMoreTokens()) continue;
                return;
            }
        } else {
            System.out.println("** Error: curLevel is too large (" + n + ").");
        }
    }

    private void AddCurFlag(String string, int n) {
        String string2 = "" + SEPARATOR[n + 1];
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string3 = stringTokenizer.nextToken();
        this.optionList_.AddOptionFlag(new OptionFlag(string3, n));
    }

    private String GetNextLevelItemStr(String string, int n) {
        String string2 = null;
        int n2 = string.indexOf(SEPARATOR[n + 1]);
        if (n2 != -1) {
            string2 = string.substring(n2);
        }
        return string2;
    }

    private OptionFlag GetOptionFlag(OptionList optionList, String string, int n) {
        OptionFlag optionFlag = null;
        ListIterator listIterator = optionList.listIterator();
        while (listIterator.hasNext()) {
            optionFlag = (OptionFlag)listIterator.next();
            if (!optionFlag.GetName().equals(OptionUtility.GetLevelFlag(string, n))) continue;
            optionList = optionFlag.GetChild();
            if (++n <= OptionUtility.GetLevelNum(string)) {
                optionFlag = this.GetOptionFlag(optionList, string, n);
            }
            return optionFlag;
        }
        System.out.println("** Error: Can't find a matched OptionFlag for '" + string + "'");
        optionFlag = null;
        return optionFlag;
    }
}

