/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.CmdLineSyntax;

import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.SystemOption;
import java.util.Vector;

public class OptionTest
extends SystemOption {
    public static void main(String[] stringArray) {
        String string = "-a:aa~123+45+1:Absolute~12:ac:ad~adb -B_Flag:bb:bc~bca:bd:be~bea_Full_Name~10.0 -C_Flag";
        Option option = new Option(string);
        if (stringArray.length > 0) {
            string = "";
            int n = 0;
            while (n < stringArray.length) {
                string = n == 0 ? stringArray[n] : string + " " + stringArray[n];
                ++n;
            }
            option = new Option(string);
        }
        OptionTest optionTest = new OptionTest();
        System.out.println("---------- input: --------------");
        System.out.println(option.GetOptionStr());
        System.out.println("---------- System: --------------");
        System.out.println(optionTest.GetOption().GetOptionStr());
        System.out.println("---------- Result: --------------");
        SystemOption.CheckSyntax(option, optionTest.GetOption(), true, true);
        System.out.println("---------- ConvertName(name): --------------");
        System.out.println(OptionUtility.ConvertName(option.GetOptionStr(), optionTest.GetOption(), false));
        System.out.println("---------- ConvertName(fullName): --------------");
        System.out.println(OptionUtility.ConvertName(option.GetOptionStr(), optionTest.GetOption(), true));
    }

    protected void ExecuteCommand(OptionItem optionItem, Option option) {
        OptionItem optionItem2 = OptionUtility.GetItemByName(optionItem, option, false);
        Vector vector = option.GetOptionItems();
        if (SystemOption.CheckOption(optionItem2, "-a:aa~INT+INT+INT")) {
            Vector vector2 = OptionItem.GetArgumentList(optionItem2.GetOptionArgument());
            int[] nArray = this.ToIntArray(vector2);
            System.out.println("=> Call '-a:aa~INT+INT+INT' flag function (" + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ")");
        } else if (SystemOption.CheckOption(optionItem2, "-a:ab~aba")) {
            System.out.println("=> Call '-a:ab~aba' flag function");
        } else if (SystemOption.CheckOption(optionItem2, "-a:ab~INT")) {
            int n = Integer.parseInt(optionItem2.GetOptionArgument());
            System.out.println("=> Call '-a:ab~INT' flag function (" + n + ")");
        } else if (SystemOption.CheckOption(optionItem2, "-a:ac")) {
            System.out.println("=> Call '-a:ac' flag function");
        } else if (SystemOption.CheckOption(optionItem2, "-a:ad:ada")) {
            System.out.println("=> Call '-a:ad:ada' flag function");
        } else if (SystemOption.CheckOption(optionItem2, "-a:ad~adb")) {
            System.out.println("=> Call '-a:ad~adb' flag function");
        } else if (SystemOption.CheckOption(optionItem2, "-a:ad~adc")) {
            System.out.println("=> Call '-a:ad~adc' flag function");
        } else if (SystemOption.CheckOption(optionItem2, "-b:bb")) {
            System.out.println("=> Call '-b:bb' flag function");
        } else if (SystemOption.CheckOption(optionItem2, "-b:bc~bca")) {
            System.out.println("=> Call '-b:bc~bca' flag function");
        } else if (SystemOption.CheckOption(optionItem2, "-b:bc~bcb")) {
            System.out.println("=> Call '-b:bc~bcb' flag function");
        } else if (SystemOption.CheckOption(optionItem2, "-b:bc~bcc")) {
            System.out.println("=> Call '-b:bc~bcc' flag function");
        } else if (SystemOption.CheckOption(optionItem2, "-b:bd")) {
            System.out.println("=> Call '-b:bd' flag function");
        } else if (SystemOption.CheckOption(optionItem2, "-b:be~INT")) {
            int n = Integer.parseInt(optionItem2.GetOptionArgument());
            System.out.println("=> Call '-b:be~INT' flag function (" + n + ")");
        } else if (SystemOption.CheckOption(optionItem2, "-b:be~bea")) {
            System.out.println("=> Call '-b:be~bea' flag function");
        } else if (SystemOption.CheckOption(optionItem2, "-b:be~BLN")) {
            boolean bl = this.ToBoolean(optionItem2.GetOptionArgument());
            System.out.println("=> Call '-b:be~BLN' flag function (" + bl + ")");
        } else if (SystemOption.CheckOption(optionItem2, "-b:be~FLT")) {
            float f = Float.parseFloat(optionItem2.GetOptionArgument());
            System.out.println("=> Call '-b:be~FLT' flag function (" + f + ")");
        } else if (SystemOption.CheckOption(optionItem2, "-b:be~STR")) {
            String string = optionItem2.GetOptionArgument();
            System.out.println("=> Call '-b:be~STR' flag function (" + string + ")");
        } else if (SystemOption.CheckOption(optionItem2, "-c")) {
            System.out.println("=> call '-c' flag function");
        }
    }

    protected void DefineFlag() {
        String string = "-a:aa~INT+INT+INT:ab~aba~INT:ac:ad~ada~adb~adc -b:bb:bc~bca~bcb~bcc:bd:be~INT~bea~BLN~FLT~STR -c";
        this.systemOption_ = new Option(string);
        this.systemOption_.SetFlagFullName("-a:ab", "Absolute");
        this.systemOption_.SetFlagFullName("-a:ab~aba", "abaFullName");
        this.systemOption_.SetFlagFullName("-b", "B_Flag");
        this.systemOption_.SetFlagFullName("-b:be~bea", "bea_Full_Name");
        this.systemOption_.SetFlagFullName("-c", "C_Flag");
    }
}

