/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.CmdLineSyntax;

import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import java.util.Iterator;
import java.util.Vector;

public abstract class SystemOption {
    protected Option systemOption_ = null;

    public SystemOption() {
        this.DefineFlag();
    }

    public Option GetOption() {
        return this.systemOption_;
    }

    public static boolean CheckSyntax(Option option, Option option2, boolean bl, boolean bl2) {
        boolean bl3 = true;
        Vector vector = option.GetOptionItems();
        int n = 0;
        while (n < vector.size()) {
            OptionItem optionItem = (OptionItem)vector.elementAt(n);
            bl3 &= SystemOption.CheckOptionItem(optionItem, option2, bl, bl2);
            ++n;
        }
        return bl3;
    }

    public void ExecuteCommands(Option option, Option option2) {
        Vector vector = option.GetOptionItems();
        int n = 0;
        while (n < vector.size()) {
            OptionItem optionItem = (OptionItem)vector.elementAt(n);
            this.ExecuteCommand(optionItem, option2);
            ++n;
        }
    }

    protected abstract void ExecuteCommand(OptionItem var1, Option var2);

    protected abstract void DefineFlag();

    protected boolean ToBoolean(String string) {
        boolean bl = false;
        if (string.equalsIgnoreCase("t") || string.equalsIgnoreCase("true")) {
            bl = true;
        }
        return bl;
    }

    protected int[] ToIntArray(Vector vector) {
        int[] nArray = new int[vector.size()];
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            nArray[n++] = Integer.parseInt((String)iterator.next());
        }
        return nArray;
    }

    protected float[] ToFloatArray(Vector vector) {
        float[] fArray = new float[vector.size()];
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            fArray[n++] = Float.parseFloat((String)iterator.next());
        }
        return fArray;
    }

    protected String[] ToStringArray(Vector vector) {
        String[] stringArray = (String[])vector.toArray();
        return stringArray;
    }

    protected static boolean CheckOption(OptionItem optionItem, String string) {
        OptionItem optionItem2 = new OptionItem(string);
        boolean bl = SystemOption.CheckOption(optionItem, optionItem2);
        return bl;
    }

    private static boolean CheckOptionItem(OptionItem optionItem, Option option, boolean bl, boolean bl2) {
        OptionItem optionItem2 = OptionUtility.GetItemByName(optionItem, option, false);
        Vector vector = option.GetOptionItems();
        boolean bl3 = false;
        int n = 0;
        while (n < vector.size()) {
            OptionItem optionItem3 = (OptionItem)vector.elementAt(n);
            if (SystemOption.CheckOption(optionItem2, optionItem3)) {
                if (bl) {
                    System.out.println("Run: " + optionItem.GetOptionItem() + " => " + optionItem3.GetOptionFlag() + ", '" + optionItem3.GetOptionArgument() + "'.");
                }
                bl3 = true;
                break;
            }
            ++n;
        }
        if (!bl3 && bl2) {
            System.out.println("*** Syntax Error: " + optionItem.GetOptionItem() + "(" + SystemOption.GetLegalSyntax(optionItem, option) + ").");
        }
        return bl3;
    }

    private static String GetLegalSyntax(OptionItem optionItem, Option option) {
        Vector<String> vector = new Vector<String>(1);
        String string = null;
        String string2 = "";
        String string3 = "";
        Vector vector2 = option.GetOptionItems();
        String string4 = optionItem.GetOptionItem();
        String string5 = optionItem.GetOptionFlag();
        String string6 = optionItem.GetOptionArgument();
        String string7 = null;
        boolean bl = false;
        int n = 0;
        while (n < vector2.size()) {
            String string8;
            OptionItem optionItem2 = (OptionItem)vector2.elementAt(n);
            String string9 = optionItem2.GetOptionItem();
            int n2 = string9.indexOf(string4);
            if (n2 != -1 && !(string8 = SystemOption.CombineArguments(string7, string9)).equals(string7)) {
                int n3 = vector.size() - 1;
                if (n3 == -1) {
                    vector.addElement(string8);
                } else {
                    vector.setElementAt(string8, n3);
                }
                string7 = string8;
            }
            if (optionItem2.GetOptionFlag().equals(string5) && !SystemOption.CheckArguments(string6, optionItem2.GetOptionArgument())) {
                string2 = optionItem2.GetOptionFlag();
                if (string2.equals("Root")) {
                    string2 = "";
                }
                string3 = string3 + OptionItem.GetSeparator(string2, 1) + optionItem2.GetOptionArgument();
                bl = true;
            }
            ++n;
        }
        if (bl) {
            vector.addElement(string2 + string3);
        }
        if (vector.size() == 0) {
            string = "Illegal option arguments; Too many levels!";
        } else {
            string = (String)vector.elementAt(0);
            int n4 = 1;
            while (n4 < vector.size()) {
                string = string + "; " + (String)vector.elementAt(n4);
                ++n4;
            }
        }
        return string;
    }

    private static String CombineArguments(String string, String string2) {
        if (string == null) {
            return string2;
        }
        Option option = new Option(string);
        Vector vector = option.GetOptionItems();
        OptionItem optionItem = new OptionItem(string2);
        vector.addElement(optionItem);
        String string3 = OptionUtility.GetOptionStr(vector);
        return string3;
    }

    private static boolean CheckOption(OptionItem optionItem, OptionItem optionItem2) {
        String string = optionItem.GetOptionFlag();
        String string2 = optionItem.GetOptionArgument();
        boolean bl = optionItem2.GetOptionFlag().equals(string) && SystemOption.CheckArguments(string2, optionItem2.GetOptionArgument());
        return bl;
    }

    private static boolean CheckArguments(String string, String string2) {
        boolean bl = false;
        int n = string2.indexOf(43);
        bl = n == -1 ? SystemOption.IsLegalArgument(string, string2) : SystemOption.IsLegalArguments(string, string2);
        return bl;
    }

    private static boolean IsLegalArguments(String string, String string2) {
        boolean bl = false;
        Vector vector = OptionItem.GetArgumentList(string2);
        Vector vector2 = OptionItem.GetArgumentList(string);
        if (vector.size() == vector2.size()) {
            int n = 0;
            while (n < vector2.size()) {
                bl = SystemOption.IsLegalArgument((String)vector2.elementAt(n), (String)vector.elementAt(n));
                if (!bl) break;
                ++n;
            }
        }
        return bl;
    }

    private static boolean IsLegalArgument(String string, String string2) {
        boolean bl = false;
        if (string2.equals("STR")) {
            bl = true;
        } else if (string2.equals(string)) {
            bl = true;
        } else if (string2.equals("INT")) {
            try {
                Integer.parseInt(string);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string2.equals("LONG")) {
            try {
                Long.parseLong(string);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string2.equals("FLT")) {
            try {
                Float.parseFloat(string);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string2.equals("BLN") && (string.equalsIgnoreCase("t") || string.equalsIgnoreCase("f") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false"))) {
            bl = true;
        }
        return bl;
    }
}

