/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.AntiNormRecord;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DbAntiNorm {
    public static Vector GetAntiNorms(String string, Connection connection) throws SQLException {
        String string2 = "SELECT * FROM AntiNorm WHERE normTerm = '" + DbBase.FormatSqlStr(string) + "'";
        Vector<AntiNormRecord> vector = new Vector<AntiNormRecord>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        while (resultSet.next()) {
            AntiNormRecord antiNormRecord = new AntiNormRecord();
            antiNormRecord.SetNormalizedTerm(resultSet.getString("normTerm"));
            antiNormRecord.SetInflectedTerm(resultSet.getString("inflTerm"));
            antiNormRecord.SetCategory(resultSet.getInt("termCat"));
            antiNormRecord.SetInflection(resultSet.getLong("termInfl"));
            antiNormRecord.SetEui(resultSet.getString("eui"));
            vector.addElement(antiNormRecord);
        }
        resultSet.close();
        statement.close();
        return vector;
    }

    public static void main(String[] stringArray) {
        String string = "disease osler rendu";
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        Configuration configuration = new Configuration("data.config.lvg", true);
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection != null) {
                Vector vector = DbAntiNorm.GetAntiNorms(string, connection);
                System.out.println("----- Total antiNorm forms found: " + vector.size());
                int n = 0;
                while (n < vector.size()) {
                    AntiNormRecord antiNormRecord = (AntiNormRecord)vector.elementAt(n);
                    System.out.println("=== Found AntiNorm ===");
                    System.out.println(antiNormRecord.GetNormalizedTerm() + "|" + antiNormRecord.GetInflectedTerm() + "|" + antiNormRecord.GetCategory() + "|" + antiNormRecord.GetInflection() + "|" + antiNormRecord.GetEui());
                    ++n;
                }
                DbBase.CloseConnection(connection);
            }
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

