/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.CanonRecord;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DbCanon {
    public static Vector GetCanons(String string, Connection connection) throws SQLException {
        String string2 = "SELECT * FROM Canonical WHERE unTerm = '" + DbBase.FormatSqlStr(string) + "'";
        Vector<CanonRecord> vector = new Vector<CanonRecord>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        while (resultSet.next()) {
            CanonRecord canonRecord = new CanonRecord();
            canonRecord.SetUnInflectedTerm(resultSet.getString("unTerm"));
            canonRecord.SetCanonicalizedTerm(resultSet.getString("canTerm"));
            canonRecord.SetCanonicalId(resultSet.getInt("canonId"));
            vector.addElement(canonRecord);
        }
        resultSet.close();
        statement.close();
        return vector;
    }

    public static void main(String[] stringArray) {
        String string = "left";
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        Configuration configuration = new Configuration("data.config.lvg", true);
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection != null) {
                Vector vector = DbCanon.GetCanons(string, connection);
                System.out.println("----- Total canonicalized forms found: " + vector.size());
                int n = 0;
                while (n < vector.size()) {
                    CanonRecord canonRecord = (CanonRecord)vector.elementAt(n);
                    System.out.println("=== Found Canonicalized Term ===");
                    System.out.println(canonRecord.GetUninflectedTerm() + "|" + canonRecord.GetCanonicalizedTerm() + "|" + canonRecord.GetCanonicalId());
                    ++n;
                }
                DbBase.CloseConnection(connection);
            }
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

