/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DerivationRecord;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DbDerivation {
    public static Vector GetDerivations(String string, Connection connection) throws SQLException {
        DerivationRecord derivationRecord;
        Vector<DerivationRecord> vector = new Vector<DerivationRecord>();
        String string2 = "SELECT * FROM Derivation WHERE termLc1= '" + DbBase.FormatSqlStr(string.toLowerCase()) + "'";
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        while (resultSet.next()) {
            derivationRecord = new DerivationRecord(resultSet.getString("term1"), resultSet.getInt("cat1"), resultSet.getString("term2"), resultSet.getInt("cat2"));
            vector.addElement(derivationRecord);
        }
        resultSet.close();
        statement.close();
        string2 = "SELECT * FROM Derivation WHERE termLc2= '" + DbBase.FormatSqlStr(string.toLowerCase()) + "'";
        statement = connection.createStatement();
        resultSet = statement.executeQuery(string2);
        while (resultSet.next()) {
            derivationRecord = new DerivationRecord(resultSet.getString("term2"), resultSet.getInt("cat2"), resultSet.getString("term1"), resultSet.getInt("cat1"));
            vector.addElement(derivationRecord);
        }
        resultSet.close();
        statement.close();
        return vector;
    }

    public static void main(String[] stringArray) {
        String string = "multiple";
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        Configuration configuration = new Configuration("data.config.lvg", true);
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection != null) {
                Vector vector = DbDerivation.GetDerivations(string, connection);
                System.out.println("----- Total Derivations found: " + vector.size());
                int n = 0;
                while (n < vector.size()) {
                    if (n == 0) {
                        System.out.println("=== Found Derivations ===");
                    }
                    DerivationRecord derivationRecord = (DerivationRecord)vector.elementAt(n);
                    System.out.println(derivationRecord.GetSource() + "|" + derivationRecord.GetSourceCat() + "|" + derivationRecord.GetTarget() + "|" + derivationRecord.GetTargetCat());
                    ++n;
                }
                DbBase.CloseConnection(connection);
            }
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

