/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbInflectionUtil;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class DbSpellingVariants {
    public static Vector GetSpellingVariants(String string, Connection connection) throws SQLException {
        Vector vector = DbInflectionUtil.GetRecordsByIfTerm(string, connection, false);
        Vector vector2 = DbSpellingVariants.EliminateDuplicateRecords(vector);
        Vector vector3 = DbSpellingVariants.GetInflectionsByEuiCatInf(vector2, connection);
        return vector3;
    }

    private static Vector EliminateDuplicateRecords(Vector vector) {
        Vector<InflectionRecord> vector2 = new Vector<InflectionRecord>();
        int n = 0;
        while (n < vector.size()) {
            InflectionRecord inflectionRecord = (InflectionRecord)vector.elementAt(n);
            if (!DbSpellingVariants.IsContainRecord(vector2, inflectionRecord)) {
                vector2.addElement(inflectionRecord);
            }
            ++n;
        }
        return vector2;
    }

    private static boolean IsContainRecord(Vector vector, InflectionRecord inflectionRecord) {
        if (inflectionRecord == null) {
            return false;
        }
        int n = 0;
        while (n < vector.size()) {
            InflectionRecord inflectionRecord2 = (InflectionRecord)vector.elementAt(n);
            if (inflectionRecord.GetEui().equals(inflectionRecord2.GetEui()) && inflectionRecord.GetCategory() == inflectionRecord2.GetCategory() && inflectionRecord.GetInflection() == inflectionRecord2.GetInflection()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static Vector GetInflectionsByEuiCatInf(Vector vector, Connection connection) throws SQLException {
        Vector vector2 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            InflectionRecord inflectionRecord = (InflectionRecord)vector.elementAt(n);
            Vector vector3 = DbSpellingVariants.GetInflectionsByEuiCatInf(inflectionRecord, connection);
            vector2.addAll(vector3);
            ++n;
        }
        return vector2;
    }

    private static Vector GetInflectionsByEuiCatInf(InflectionRecord inflectionRecord, Connection connection) throws SQLException {
        String string = "SELECT * FROM Inflection WHERE eui = '" + inflectionRecord.GetEui() + "' AND termCat = '" + inflectionRecord.GetCategory() + "' AND termInfl = '" + inflectionRecord.GetInflection() + "'";
        string = string.trim();
        Vector vector = DbInflectionUtil.GetRecords(string, connection, false);
        return vector;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = "color";
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection != null) {
                Vector vector = DbSpellingVariants.GetSpellingVariants(string, connection);
                System.out.println("----- Total records found: " + vector.size());
                int n = 0;
                while (n < vector.size()) {
                    InflectionRecord inflectionRecord = (InflectionRecord)vector.elementAt(n);
                    System.out.println(inflectionRecord.GetInflectedTerm() + "|" + inflectionRecord.GetUninflectedTerm() + "|" + inflectionRecord.GetCitationTerm() + "|" + inflectionRecord.GetEui() + "|" + inflectionRecord.GetCategory() + "|" + inflectionRecord.GetInflection());
                    ++n;
                }
                DbBase.CloseConnection(connection);
            }
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

