/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.AntiNormRecord;
import gov.nih.nlm.nls.lvg.Db.DbAntiNorm;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToNormalize;
import gov.nih.nlm.nls.lvg.Flows.ToStripStopWords;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToAntiNorm
extends Transformation {
    private static final String INFO = "AntiNorm";

    public static Vector Mutate(LexItem lexItem, int n, Vector vector, Connection connection, RamTrie ramTrie, boolean bl, boolean bl2) throws SQLException {
        Vector vector2 = ToNormalize.Mutate(lexItem, n, vector, connection, ramTrie, bl, bl2);
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        int n2 = 0;
        while (n2 < vector2.size()) {
            LexItem lexItem2 = (LexItem)vector2.elementAt(n2);
            String string = lexItem2.GetTargetTerm();
            Vector vector5 = DbAntiNorm.GetAntiNorms(string, connection);
            int n3 = 0;
            while (n3 < vector5.size()) {
                AntiNormRecord antiNormRecord = (AntiNormRecord)vector5.elementAt(n3);
                String string2 = null;
                String string3 = null;
                if (bl) {
                    string2 = INFO;
                }
                if (bl2) {
                    string3 = antiNormRecord.GetEui() + GlobalBehavior.GetFieldSeparator();
                }
                String string4 = antiNormRecord.GetInflectedTerm();
                int n4 = antiNormRecord.GetCategory();
                long l = antiNormRecord.GetInflection();
                LexItem lexItem3 = Transformation.UpdateLexItem(lexItem, string4, 47, n4, l, string2, string3);
                vector4 = ToAntiNorm.AddToAntiNormOutput(vector4, lexItem3);
                ++n3;
            }
            ++n2;
        }
        return vector4;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "Rendu-Osler disease");
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string2 = configuration.GetConfiguration("LVG_DIR");
        int n2 = Integer.parseInt(configuration.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS"));
        Vector vector = ToStripStopWords.GetStopWordsFromFile(configuration);
        LexItem lexItem = new LexItem(string);
        Vector vector2 = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            boolean bl = true;
            RamTrie ramTrie = new RamTrie(bl, n, string2, 0);
            if (connection != null) {
                vector2 = ToAntiNorm.Mutate(lexItem, n2, vector, connection, ramTrie, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector2);
    }

    private static Vector AddToAntiNormOutput(Vector vector, LexItem lexItem) {
        boolean bl = false;
        Vector<LexItem> vector2 = new Vector<LexItem>(vector);
        int n = 0;
        while (n < vector.size()) {
            LexItem lexItem2 = (LexItem)vector.elementAt(n);
            if (lexItem2.GetTargetTerm().equals(lexItem.GetTargetTerm()) && lexItem2.GetTargetCategory().GetValue() == lexItem.GetTargetCategory().GetValue() && lexItem2.GetTargetInflection().GetValue() == lexItem.GetTargetInflection().GetValue()) {
                if (lexItem2.GetMutateInformation() == null || lexItem.GetMutateInformation() == null) {
                    bl = true;
                    break;
                }
                if (lexItem2.GetMutateInformation().equals(lexItem.GetMutateInformation())) {
                    bl = true;
                    break;
                }
            }
            ++n;
        }
        if (!bl) {
            vector2.addElement(lexItem);
        }
        return vector2;
    }
}

