/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbEui;
import gov.nih.nlm.nls.lvg.Db.DbUninflection;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.ToSpellingVariants;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToBaseSpellingVariants
extends Transformation
implements Cloneable {
    private static final String INFO = "Base Spelling Variants";

    public static Vector Mutate(LexItem lexItem, Connection connection, RamTrie ramTrie, boolean bl, boolean bl2) throws SQLException {
        Vector vector = new Vector();
        long l = lexItem.GetSourceCategory().GetValue();
        Vector vector2 = ToSpellingVariants.SpellingVariant(lexItem.GetSourceTerm(), connection);
        int n = 0;
        while (n < vector2.size()) {
            InflectionRecord inflectionRecord = (InflectionRecord)vector2.elementAt(n);
            String string = inflectionRecord.GetInflectedTerm();
            long l2 = inflectionRecord.GetCategory();
            long l3 = inflectionRecord.GetInflection();
            if (InputFilter.IsLegal(l, l2)) {
                LexItem lexItem2 = new LexItem(lexItem, false);
                lexItem2.SetSourceTerm(string);
                lexItem2.SetSourceCategory(l2);
                lexItem2.SetSourceInflection(l3);
                Vector vector3 = ToBaseSpellingVariants.UninflectTerm(lexItem2, connection, ramTrie);
                int n2 = 0;
                while (n2 < vector3.size()) {
                    Object object;
                    InflectionRecord inflectionRecord2 = (InflectionRecord)vector3.elementAt(n2);
                    String string2 = inflectionRecord2.GetUninflectedTerm();
                    lexItem.SetSourceCategory(inflectionRecord2.GetCategory());
                    lexItem.SetSourceInflection(inflectionRecord2.GetInflection());
                    String string3 = null;
                    String string4 = null;
                    if (bl) {
                        string3 = INFO;
                    }
                    if (bl2) {
                        object = DbEui.GetEuisByUnflectedTermCat(string2, inflectionRecord2.GetCategory(), connection);
                        string4 = (String)object + GlobalBehavior.GetFieldSeparator();
                    }
                    object = Transformation.UpdateLexItem(lexItem, string2, 23, inflectionRecord2.GetCategory(), Inflection.GetBitValue(0), string3, string4);
                    ToBaseSpellingVariants.AddCurToOut(vector, (LexItem)object);
                    ++n2;
                }
            }
            ++n;
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "color");
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string2 = configuration.GetConfiguration("LVG_DIR");
        LexItem lexItem = new LexItem(string, 2047L, 0xFFFFFFL);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            boolean bl = true;
            RamTrie ramTrie = new RamTrie(bl, n, string2, 0);
            if (connection != null) {
                vector = ToBaseSpellingVariants.Mutate(lexItem, connection, ramTrie, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    private static Vector UninflectTerm(LexItem lexItem, Connection connection, RamTrie ramTrie) {
        String string = lexItem.GetSourceTerm();
        Vector vector = new Vector();
        try {
            vector = DbUninflection.GetUninflections(string, connection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    private static void AddCurToOut(Vector vector, LexItem lexItem) {
        if (vector.size() == 0) {
            vector.addElement(lexItem);
        } else {
            boolean bl = false;
            int n = 0;
            while (n < vector.size()) {
                LexItem lexItem2 = (LexItem)vector.elementAt(n);
                if (lexItem2.GetTargetTerm().equals(lexItem.GetTargetTerm()) && lexItem2.GetTargetCategory().GetValue() == lexItem.GetTargetCategory().GetValue()) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                vector.addElement(lexItem);
            }
        }
    }
}

