/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.AcronymRecord;
import gov.nih.nlm.nls.lvg.Db.DbAcronym;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToStripPunctuation;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.Tag;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToExpansions
extends Transformation
implements Cloneable {
    private static final String INFO = "Generate Acronym Expansions";

    public static Vector Mutate(LexItem lexItem, Connection connection, boolean bl, boolean bl2) {
        Vector vector = ToExpansions.GetExpansions(lexItem.GetSourceTerm(), connection);
        Vector<LexItem> vector2 = new Vector<LexItem>();
        int n = vector.size();
        boolean bl3 = n == 1;
        Tag tag = new Tag(lexItem.GetTag());
        tag.SetBitFlag(1, bl3);
        String string = bl3 ? "Unique" : "NotUnique";
        lexItem.SetTag(tag.GetValue());
        int n2 = 0;
        while (n2 < n) {
            AcronymRecord acronymRecord = (AcronymRecord)vector.elementAt(n2);
            String string2 = acronymRecord.GetExpansion();
            String string3 = null;
            String string4 = null;
            if (bl) {
                string3 = "Generate Acronym Expansions (" + acronymRecord.GetType() + ")";
            }
            if (bl2) {
                string4 = acronymRecord.GetType() + GlobalBehavior.GetFieldSeparator() + string + GlobalBehavior.GetFieldSeparator();
            }
            LexItem lexItem2 = Transformation.UpdateLexItem(lexItem, string2, 17, -1L, Inflection.GetBitValue(0), string3, string4);
            vector2.addElement(lexItem2);
            ++n2;
        }
        return vector2;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "ER");
        LexItem lexItem = new LexItem(string);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection != null) {
                vector = ToExpansions.Mutate(lexItem, connection, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    private static Vector GetExpansions(String string, Connection connection) {
        String string2 = ToStripPunctuation.StripPunctuation(string);
        String string3 = string2.toLowerCase();
        Vector vector = new Vector();
        try {
            vector = DbAcronym.GetExpansions(string3, connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return vector;
    }
}

