/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToFruitfulVariants;
import gov.nih.nlm.nls.lvg.Flows.ToFruitfulVariantsDb;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Flow;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToFruitfulEnhanced
extends Transformation
implements Cloneable {
    private static final String INFO = "Fruitful Variants, Enhanced";

    public static Vector Mutate(LexItem lexItem, Connection connection, RamTrie ramTrie, RamTrie ramTrie2, boolean bl, boolean bl2) throws SQLException {
        Vector vector = ToFruitfulVariantsDb.Mutate(lexItem, connection, bl, bl2);
        if (vector.size() == 0) {
            vector = ToFruitfulVariants.Mutate(lexItem, connection, ramTrie, ramTrie2, bl, bl2);
        }
        int n = 0;
        while (n < vector.size()) {
            LexItem lexItem2 = (LexItem)vector.elementAt(n);
            lexItem2.SetFlowHistory(Flow.GetBitName(49, 1));
            ++n;
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "neurological");
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string2 = configuration.GetConfiguration("LVG_DIR");
        int n2 = Integer.parseInt(configuration.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        LexItem lexItem = new LexItem(string);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            RamTrie ramTrie = new RamTrie(true, n, string2, 0);
            RamTrie ramTrie2 = new RamTrie(false, n, string2, n2);
            if (connection != null) {
                vector = ToFruitfulEnhanced.Mutate(lexItem, connection, ramTrie, ramTrie2, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }
}

