/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbInflection;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.ToAcronyms;
import gov.nih.nlm.nls.lvg.Flows.ToExpansions;
import gov.nih.nlm.nls.lvg.Flows.ToInflection;
import gov.nih.nlm.nls.lvg.Flows.ToRecursiveDerivations;
import gov.nih.nlm.nls.lvg.Flows.ToRecursiveSynonyms;
import gov.nih.nlm.nls.lvg.Flows.ToSpellingVariants;
import gov.nih.nlm.nls.lvg.Flows.ToUninflectTerm;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.CatInfl;
import gov.nih.nlm.nls.lvg.Lib.CatInflKey;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.CombineRecords;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Flow;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.OutputFilter;
import gov.nih.nlm.nls.lvg.Lib.TermCatCatKey;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToFruitfulVariants
extends Transformation
implements Cloneable {
    private static final String INFO = "Generate Fruitful Variants";

    public static Vector Mutate(LexItem lexItem, Connection connection, RamTrie ramTrie, RamTrie ramTrie2, boolean bl, boolean bl2) throws SQLException {
        Vector vector = ToFruitfulVariants.GetNoOperationSet(lexItem, connection, ramTrie, bl, false);
        Vector vector2 = ToFruitfulVariants.GetVariantSet(lexItem, connection, ramTrie, ramTrie2, bl);
        Vector vector3 = ToFruitfulVariants.GetSpellingAndInflections(vector2, connection, ramTrie, bl, 2);
        vector = ToFruitfulVariants.AddToVariantList(vector, vector3);
        String string = Flow.GetBitName(42, 1);
        Vector vector4 = ToFruitfulVariants.GetFinalSet(vector, string, bl2);
        return vector4;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "neurological");
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string2 = configuration.GetConfiguration("LVG_DIR");
        int n2 = Integer.parseInt(configuration.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        LexItem lexItem = new LexItem(string);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            RamTrie ramTrie = new RamTrie(true, n, string2, 0);
            RamTrie ramTrie2 = new RamTrie(false, n, string2, n2);
            if (connection != null) {
                vector = ToFruitfulVariants.Mutate(lexItem, connection, ramTrie, ramTrie2, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    static Vector GetSpellingAndInflections(Vector vector, Connection connection, RamTrie ramTrie, boolean bl, int n) {
        Vector vector2 = ToFruitfulVariants.GetSpellingVariants(vector, connection, bl);
        vector2 = ToFruitfulVariants.AddToVariantList(vector2, vector);
        Vector vector3 = ToFruitfulVariants.GetInflections(vector2, connection, ramTrie, bl, n);
        vector2 = ToFruitfulVariants.AddToVariantList(vector2, vector3);
        return vector2;
    }

    static Vector GetFinalSet(Vector vector, String string, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        int n = 0;
        while (n < vector.size()) {
            object3 = (LexItem)vector.elementAt(n);
            object2 = new TermCatCatKey(((LexItem)object3).GetTargetTerm().toLowerCase(), ToFruitfulVariants.GetFirstCategory((LexItem)object3), (int)((LexItem)object3).GetTargetCategory().GetValue());
            if (hashtable.containsKey(object2)) {
                int n2;
                object = (LexItem)hashtable.get(object2);
                int n3 = ToFruitfulVariants.CalculateDistance(((LexItem)object).GetFlowHistory());
                if (n3 > (n2 = ToFruitfulVariants.CalculateDistance(((LexItem)object3).GetFlowHistory()))) {
                    hashtable.remove(object2);
                    hashtable.put(object2, object3);
                }
            } else {
                hashtable.put(object2, object3);
            }
            ++n;
        }
        object3 = new Vector(hashtable.values());
        object2 = OutputFilter.GetEnhancedSimpleInflection((Vector)object3);
        object = ToFruitfulVariants.UpdateVariants((Vector)object2, string, bl);
        return object;
    }

    static Vector GetVariantSet(LexItem lexItem, Connection connection, RamTrie ramTrie, RamTrie ramTrie2, boolean bl) throws SQLException {
        Vector vector = ToFruitfulVariants.GetBaseSet(lexItem, connection, ramTrie, bl);
        Vector vector2 = ToFruitfulVariants.GetSpellingVariants(vector, connection, bl);
        Vector vector3 = ToFruitfulVariants.GetAcronyms(vector2, connection, bl);
        Vector vector4 = ToFruitfulVariants.GetRecursiveSynonyms(vector2, connection, bl);
        Vector vector5 = new Vector();
        vector5.addAll(vector2);
        vector5 = ToFruitfulVariants.AddToVariantList(vector5, vector3);
        vector5 = ToFruitfulVariants.AddToVariantList(vector5, vector4);
        Vector vector6 = ToFruitfulVariants.GetRecursiveDerivations(vector5, connection, ramTrie2, bl);
        Vector vector7 = ToFruitfulVariants.GetRecursiveSynonyms(vector6, connection, bl);
        Vector vector8 = ToFruitfulVariants.GetRecursiveSynonyms(vector3, connection, bl);
        Vector vector9 = ToFruitfulVariants.GetAcronyms(vector4, connection, bl);
        Vector vector10 = new Vector();
        vector10 = ToFruitfulVariants.AddToVariantList(vector10, vector5);
        vector10 = ToFruitfulVariants.AddToVariantList(vector10, vector6);
        vector10 = ToFruitfulVariants.AddToVariantList(vector10, vector7);
        vector10 = ToFruitfulVariants.AddToVariantList(vector10, vector8);
        vector10 = ToFruitfulVariants.AddToVariantList(vector10, vector9);
        return vector10;
    }

    static Vector GetNoOperationSet(LexItem lexItem, Connection connection, RamTrie ramTrie, boolean bl, boolean bl2) throws SQLException {
        Object object;
        Object object2;
        String string = lexItem.GetSourceTerm();
        String string2 = null;
        if (bl) {
            string2 = "No Operation (Retrieve Cat/Infl)";
        }
        String string3 = null;
        Vector vector = new Vector();
        vector = DbInflection.GetCatInfl(lexItem.GetSourceTerm(), connection);
        Hashtable<Object, LexItem> hashtable = new Hashtable<Object, LexItem>();
        Vector<LexItem> vector2 = new Vector<LexItem>();
        int n = 0;
        while (n < vector.size()) {
            object2 = (InflectionRecord)vector.elementAt(n);
            if (((InflectionRecord)object2).GetInflection() <= 255L || (long)((InflectionRecord)object2).GetCategory() == Category.ToValue("aux") || (long)((InflectionRecord)object2).GetCategory() == Category.ToValue("modal")) {
                string3 = Long.toString(((InflectionRecord)object2).GetCategory()) + GlobalBehavior.GetFieldSeparator() + Long.toString(((InflectionRecord)object2).GetInflection());
                LexItem lexItem2 = Transformation.UpdateLexItem(lexItem, string, 15, ((InflectionRecord)object2).GetCategory(), ((InflectionRecord)object2).GetInflection(), string2, string3);
                vector2.addElement(lexItem2);
                object = new CatInflKey((int)lexItem2.GetTargetCategory().GetValue(), lexItem2.GetTargetInflection().GetValue());
                hashtable.put(object, lexItem2);
            }
            ++n;
        }
        if (!bl2 && vector2.size() == 0) {
            object2 = ramTrie.GetCatInflsByRules(string, lexItem.GetSourceCategory().GetValue(), lexItem.GetSourceInflection().GetValue());
            int n2 = 0;
            while (n2 < ((Vector)object2).size()) {
                object = (CatInfl)((Vector)object2).elementAt(n2);
                if (((CatInfl)object).GetInflection() <= 255L) {
                    string3 = Long.toString(((CatInfl)object).GetCategory());
                    LexItem lexItem3 = Transformation.UpdateLexItem(lexItem, string, 15, ((CatInfl)object).GetCategory(), ((CatInfl)object).GetInflection(), string2, string3);
                    vector2.addElement(lexItem3);
                    CatInflKey catInflKey = new CatInflKey((int)lexItem3.GetTargetCategory().GetValue(), lexItem3.GetTargetInflection().GetValue());
                    hashtable.put(catInflKey, lexItem3);
                }
                ++n2;
            }
        }
        object2 = new Vector(hashtable.values());
        return object2;
    }

    static Vector AddToVariantList(Vector vector, Vector vector2) {
        Object object;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(vector.size() + vector2.size());
        int n = 0;
        while (n < vector.size()) {
            LexItem lexItem = (LexItem)vector.elementAt(n);
            object = new TermCatCatKey(lexItem.GetTargetTerm(), ToFruitfulVariants.GetFirstCategory(lexItem), (int)lexItem.GetTargetCategory().GetValue());
            hashtable.put(object, lexItem);
            ++n;
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            object = (LexItem)vector2.elementAt(n2);
            TermCatCatKey termCatCatKey = new TermCatCatKey(((LexItem)object).GetTargetTerm(), ToFruitfulVariants.GetFirstCategory((LexItem)object), (int)((LexItem)object).GetTargetCategory().GetValue());
            if (hashtable.containsKey(termCatCatKey)) {
                int n3;
                LexItem lexItem = (LexItem)hashtable.get(termCatCatKey);
                int n4 = ToFruitfulVariants.CalculateDistance(lexItem.GetFlowHistory());
                if (n4 > (n3 = ToFruitfulVariants.CalculateDistance(((LexItem)object).GetFlowHistory()))) {
                    hashtable.remove(termCatCatKey);
                    hashtable.put(termCatCatKey, object);
                }
            } else {
                hashtable.put(termCatCatKey, object);
            }
            ++n2;
        }
        object = new Vector(hashtable.values());
        return object;
    }

    public static int GetFirstCategory(LexItem lexItem) {
        int n = 0;
        if (lexItem.GetMutateInformation() != null) {
            try {
                String string = "|";
                StringTokenizer stringTokenizer = new StringTokenizer(lexItem.GetMutateInformation(), string);
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    private static Vector GetBaseSet(LexItem lexItem, Connection connection, RamTrie ramTrie, boolean bl) throws SQLException {
        String string = lexItem.GetSourceTerm();
        Vector vector = new Vector();
        vector = ToUninflectTerm.Mutate(lexItem, connection, ramTrie, bl, false);
        Vector vector2 = CombineRecords.Combine(vector, 2);
        String string2 = Flow.GetBitName(15, 1);
        int n = 0;
        while (n < vector2.size()) {
            LexItem lexItem2 = (LexItem)vector2.elementAt(n);
            String string3 = Long.toString(lexItem2.GetTargetCategory().GetValue());
            String string4 = Long.toString(lexItem2.GetTargetInflection().GetValue());
            String string5 = string3 + GlobalBehavior.GetFieldSeparator() + string4;
            lexItem2.SetMutateInformation(string5);
            if (string.equals(lexItem2.GetTargetTerm())) {
                lexItem2.SetFlowHistory(string2);
            }
            ++n;
        }
        return vector2;
    }

    private static int CalculateDistance(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            switch (string.charAt(n2)) {
                case 'b': 
                case 'i': {
                    ++n;
                    break;
                }
                case 'A': 
                case 'a': 
                case 'y': {
                    n += 2;
                    break;
                }
                case 'd': {
                    n += 3;
                    break;
                }
            }
            ++n2;
        }
        return n;
    }

    private static Vector UpdateVariants(Vector vector, String string, boolean bl) {
        Vector<LexItem> vector2 = new Vector<LexItem>();
        int n = 0;
        while (n < vector.size()) {
            LexItem lexItem = (LexItem)vector.elementAt(n);
            if (bl) {
                String string2 = GlobalBehavior.GetFieldSeparator();
                String string3 = lexItem.GetFlowHistory();
                String string4 = lexItem.GetMutateInformation();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string4);
                stringBuffer.append(string2);
                stringBuffer.append(string3);
                stringBuffer.append(string2);
                stringBuffer.append(ToFruitfulVariants.CalculateDistance(string3));
                stringBuffer.append(string2);
                stringBuffer.append(lexItem.GetTag());
                stringBuffer.append(string2);
                String string5 = stringBuffer.toString();
                lexItem.SetMutateInformation(string5);
            }
            lexItem.SetFlowHistory(string);
            vector2.addElement(lexItem);
            ++n;
        }
        return vector2;
    }

    private static Vector GetRecursiveDerivations(Vector vector, Connection connection, RamTrie ramTrie, boolean bl) {
        Vector vector2 = new Vector();
        Vector vector3 = LexItem.TargetsToSources(vector);
        int n = 0;
        while (n < vector3.size()) {
            LexItem lexItem = (LexItem)vector3.elementAt(n);
            Vector vector4 = ToRecursiveDerivations.Mutate(lexItem, connection, ramTrie, 1, bl, false, true);
            ToFruitfulVariants.PassCategory(vector4, lexItem.GetMutateInformation());
            vector2.addAll(vector4);
            ++n;
        }
        return vector2;
    }

    private static Vector GetAcronyms(Vector vector, Connection connection, boolean bl) {
        Vector vector2 = new Vector();
        Vector vector3 = LexItem.TargetsToSources(vector);
        int n = 0;
        while (n < vector3.size()) {
            LexItem lexItem = (LexItem)vector3.elementAt(n);
            Vector vector4 = ToAcronyms.Mutate(lexItem, connection, bl, false);
            ToFruitfulVariants.PassCategory(vector4, lexItem.GetMutateInformation());
            vector2.addAll(vector4);
            Vector vector5 = ToExpansions.Mutate(lexItem, connection, bl, false);
            ToFruitfulVariants.PassCategory(vector5, lexItem.GetMutateInformation());
            vector2.addAll(vector5);
            ++n;
        }
        return vector2;
    }

    private static void PassCategory(Vector vector, String string) {
        int n = 0;
        while (n < vector.size()) {
            LexItem lexItem = (LexItem)vector.elementAt(n);
            lexItem.SetMutateInformation(string);
            ++n;
        }
    }

    private static Vector GetRecursiveSynonyms(Vector vector, Connection connection, boolean bl) {
        Vector vector2 = new Vector();
        Vector vector3 = LexItem.TargetsToSources(vector);
        int n = 0;
        while (n < vector3.size()) {
            LexItem lexItem = (LexItem)vector3.elementAt(n);
            Vector vector4 = ToRecursiveSynonyms.Mutate(lexItem, connection, bl, false, true);
            ToFruitfulVariants.PassCategory(vector4, lexItem.GetMutateInformation());
            vector2.addAll(vector4);
            ++n;
        }
        return vector2;
    }

    private static Vector GetInflections(Vector vector, Connection connection, RamTrie ramTrie, boolean bl, int n) {
        Vector vector2 = new Vector();
        Vector vector3 = LexItem.TargetsToSources(vector);
        int n2 = 0;
        while (n2 < vector3.size()) {
            LexItem lexItem = (LexItem)vector3.elementAt(n2);
            CatInfl catInfl = CatInfl.ConvertToBase(new CatInfl(lexItem.GetSourceCategory().GetValue(), lexItem.GetSourceInflection().GetValue()));
            lexItem.SetSourceInflection(catInfl.GetInflection());
            Vector vector4 = ToInflection.Mutate(lexItem, connection, ramTrie, n, bl, false);
            ToFruitfulVariants.PassCategory(vector4, lexItem.GetMutateInformation());
            vector2.addAll(vector4);
            ++n2;
        }
        return vector2;
    }

    private static Vector GetSpellingVariants(Vector vector, Connection connection, boolean bl) {
        Object object;
        Vector vector2 = new Vector();
        Vector vector3 = LexItem.TargetsToSources(vector);
        int n = 0;
        while (n < vector3.size()) {
            LexItem lexItem = (LexItem)vector3.elementAt(n);
            object = ToSpellingVariants.Mutate(lexItem, connection, bl, false);
            ToFruitfulVariants.PassCategory((Vector)object, lexItem.GetMutateInformation());
            vector2.addAll(object);
            ++n;
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            object = (LexItem)vector2.elementAt(n2);
            if (((LexItem)object).GetSourceTerm().equalsIgnoreCase(((LexItem)object).GetTargetTerm())) {
                String string = ((LexItem)object).GetFlowHistory();
                int n3 = string.length() - 2;
                ((LexItem)object).SetFlowHistory(string.substring(0, n3));
            }
            ++n2;
        }
        return vector2;
    }
}

