/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbFruitful;
import gov.nih.nlm.nls.lvg.Db.FruitfulRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToFruitfulVariantsDb
extends Transformation
implements Cloneable {
    private static final String INFO = "Fruitful Variants Db";

    public static Vector Mutate(LexItem lexItem, Connection connection, boolean bl, boolean bl2) {
        Vector vector = ToFruitfulVariantsDb.GetFruitfulVariants(lexItem.GetSourceTerm(), connection);
        Vector<Object> vector2 = new Vector<Object>();
        int n = 0;
        while (n < vector.size()) {
            Object object;
            FruitfulRecord fruitfulRecord = (FruitfulRecord)vector.elementAt(n);
            String string = fruitfulRecord.GetVariantTerm();
            String string2 = null;
            String string3 = null;
            if (bl) {
                string2 = INFO;
            }
            if (bl2) {
                object = GlobalBehavior.GetFieldSeparator();
                string3 = fruitfulRecord.GetOriginalCategory() + (String)object + fruitfulRecord.GetOriginalInflection() + (String)object + fruitfulRecord.GetFlowHistory() + (String)object + fruitfulRecord.GetDistance() + (String)object + fruitfulRecord.GetTagInformation() + (String)object;
            }
            object = Transformation.UpdateLexItem(lexItem, string, 46, fruitfulRecord.GetCategory(), fruitfulRecord.GetInflection(), string2, string3);
            vector2.addElement(object);
            ++n;
        }
        return vector2;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "neurological");
        LexItem lexItem = new LexItem(string);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection != null) {
                vector = ToFruitfulVariantsDb.Mutate(lexItem, connection, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    private static Vector GetFruitfulVariants(String string, Connection connection) {
        String string2 = string.toLowerCase();
        Vector vector = new Vector();
        try {
            vector = DbFruitful.GetFruitfulVariants(string2, connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return vector;
    }
}

