/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToInflection;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.OutputFilter;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.util.Vector;

public class ToInflectionByCatInfl
extends Transformation
implements Cloneable {
    private static final String INFO = "InflectionByCatInfl";

    public static Vector Mutate(LexItem lexItem, Connection connection, RamTrie ramTrie, int n, long l, long l2, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(INFO);
        stringBuffer.append(" <");
        stringBuffer.append(l);
        stringBuffer.append(", ");
        stringBuffer.append(l2);
        stringBuffer.append(">");
        String string = stringBuffer.toString();
        Vector vector = ToInflection.InflectWords(lexItem, connection, ramTrie, n, string, bl, bl2, 20);
        Vector vector2 = ToInflectionByCatInfl.RestrictOutputByCatInfl(vector, l, l2);
        return vector2;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "sleep");
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string2 = configuration.GetConfiguration("LVG_DIR");
        LexItem lexItem = new LexItem(string, 2047L, 0xFFFFFFL);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            boolean bl = true;
            RamTrie ramTrie = new RamTrie(bl, n, string2, 0);
            if (connection != null) {
                vector = ToInflectionByCatInfl.Mutate(lexItem, connection, ramTrie, 2, 128L, 1L, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    private static Vector RestrictOutputByCatInfl(Vector vector, long l, long l2) {
        Vector<LexItem> vector2 = new Vector<LexItem>();
        int n = 0;
        while (n < vector.size()) {
            LexItem lexItem = (LexItem)vector.elementAt(n);
            if (OutputFilter.IsCategoryInflectionOK(lexItem, l, l2)) {
                vector2.addElement(lexItem);
            }
            ++n;
        }
        return vector2;
    }
}

