/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToInflection;
import gov.nih.nlm.nls.lvg.Flows.ToSimpleInflections;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Flow;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.TermCatInflKey;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Vector;

public class ToInflectionSimple
extends Transformation
implements Cloneable {
    private static final String INFO = "Inflection Simple";

    public static Vector Mutate(LexItem lexItem, Connection connection, RamTrie ramTrie, int n, boolean bl, boolean bl2) {
        Object object;
        Vector vector = ToInflection.Mutate(lexItem, connection, ramTrie, n, bl, bl2);
        Hashtable<TermCatInflKey, Object> hashtable = new Hashtable<TermCatInflKey, Object>(vector.size());
        String string = Flow.GetBitName(51, 1);
        int n2 = 0;
        while (n2 < vector.size()) {
            object = (LexItem)vector.elementAt(n2);
            ToSimpleInflections.GetSimpleInflectionsOnTarget((LexItem)object);
            String string2 = ((LexItem)object).GetFlowHistory();
            String string3 = string2.substring(0, string2.length() - 1) + string;
            ((LexItem)object).SetFlowHistory(string3);
            TermCatInflKey termCatInflKey = new TermCatInflKey(((LexItem)object).GetTargetTerm(), (int)((LexItem)object).GetTargetCategory().GetValue(), ((LexItem)object).GetTargetInflection().GetValue());
            hashtable.put(termCatInflKey, object);
            ++n2;
        }
        object = new Vector(hashtable.values());
        return object;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "Left");
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string2 = configuration.GetConfiguration("LVG_DIR");
        LexItem lexItem = new LexItem(string, 2047L, 0xFFFFFFL);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection == null) {
                System.out.println("** Error: Db connection problem!");
            }
            boolean bl = true;
            RamTrie ramTrie = new RamTrie(bl, n, string2, 0);
            if (connection != null) {
                vector = ToInflectionSimple.Mutate(lexItem, connection, ramTrie, 2, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }
}

