/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbDerivation;
import gov.nih.nlm.nls.lvg.Db.DerivationRecord;
import gov.nih.nlm.nls.lvg.Flows.ToDerivation;
import gov.nih.nlm.nls.lvg.Flows.ToFruitfulVariants;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Flow;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.LexItemComparator;
import gov.nih.nlm.nls.lvg.Lib.Tag;
import gov.nih.nlm.nls.lvg.Lib.TermCatCatKey;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Trie.RuleResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;

public class ToRecursiveDerivations
extends Transformation
implements Cloneable {
    private static final String INFO = "Recursive Derivation";
    private static Vector derivations_ = new Vector();
    private static Hashtable derivationHt_ = new Hashtable();
    private static String orgInputTerm_ = new String();

    public static Vector Mutate(LexItem lexItem, Connection connection, RamTrie ramTrie, int n, boolean bl, boolean bl2, boolean bl3) {
        ToRecursiveDerivations.Init(lexItem.GetSourceTerm());
        ToRecursiveDerivations.GetRecursiveDerivations(lexItem, connection, ramTrie, n, INFO, true, bl, bl2, null);
        ToRecursiveDerivations.UpdateFlowHistory(bl3);
        return ToRecursiveDerivations.GetDerivationVector();
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "medicine");
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string2 = configuration.GetConfiguration("LVG_DIR");
        int n2 = Integer.parseInt(configuration.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        LexItem lexItem = new LexItem(string, 2047L, 0xFFFFFFL);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            boolean bl = false;
            RamTrie ramTrie = new RamTrie(bl, n, string2, n2);
            if (connection != null) {
                vector = ToRecursiveDerivations.Mutate(lexItem, connection, ramTrie, 1, true, true, false);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    private static Vector GetDerivations(LexItem lexItem, Connection connection, RamTrie ramTrie, int n, String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        int n2;
        String string3;
        String string4;
        Object object;
        int n3;
        String string5 = lexItem.GetSourceTerm();
        Vector vector = new Vector();
        if (lexItem.GetSourceTerm().length() == 0) {
            return vector;
        }
        String string6 = string2;
        try {
            Object object2;
            long l = lexItem.GetSourceCategory().GetValue();
            long l2 = lexItem.GetSourceInflection().GetValue();
            Vector vector2 = DbDerivation.GetDerivations(string5, connection);
            n3 = 0;
            while (n3 < vector2.size()) {
                object = (DerivationRecord)vector2.elementAt(n3);
                String string7 = ((DerivationRecord)object).GetTarget();
                long l3 = ((DerivationRecord)object).GetSourceCat();
                if (InputFilter.IsLegal(l, l3)) {
                    string4 = null;
                    string3 = null;
                    if (bl2) {
                        string4 = string + " (FACT)";
                    }
                    if (bl3) {
                        object2 = GlobalBehavior.GetFieldSeparator();
                        string3 = "FACT" + (String)object2 + ((DerivationRecord)object).GetPureString((String)object2) + string2 + (String)object2;
                    }
                    object2 = Transformation.UpdateLexItem(lexItem, string7, string6, ((DerivationRecord)object).GetTargetCat(), Inflection.GetBitValue(0), string4, string3, false);
                    vector.addElement(object2);
                }
                ++n3;
            }
            object = ramTrie.GetDerivationsByRules(string5, l, l2, true);
            n2 = 0;
            while (n2 < ((Vector)object).size()) {
                RuleResult ruleResult = (RuleResult)((Vector)object).elementAt(n2);
                String string8 = ruleResult.GetOutTerm();
                string4 = null;
                string3 = null;
                if (bl2) {
                    string4 = string + " (RULE|" + ruleResult.GetRuleString() + ")";
                }
                if (bl3) {
                    object2 = GlobalBehavior.GetFieldSeparator();
                    string3 = "RULE" + (String)object2 + ruleResult.GetInTerm() + (String)object2 + ruleResult.GetOutTerm() + (String)object2 + ruleResult.GetRuleString() + (String)object2 + string2 + (String)object2;
                }
                object2 = Transformation.UpdateLexItem(lexItem, string8, string6, Category.ToValue(ruleResult.GetOutCategory()), Inflection.ToValue(ruleResult.GetOutInflection()), string4, string3, false);
                vector.addElement(object2);
                ++n2;
            }
            vector = ToDerivation.RestrictDerivations(vector, connection, n);
        }
        catch (SQLException sQLException) {
            System.out.println("** Error: Sql Exception in ToRecursiveDerivation Flow.");
            System.out.println(sQLException.toString());
        }
        LexItemComparator lexItemComparator = new LexItemComparator();
        lexItemComparator.SetRule(10);
        Collections.sort(vector, lexItemComparator);
        long l = Category.GetBitValue(0);
        long l4 = Category.GetBitValue(7);
        n3 = 0;
        while (n3 < vector.size()) {
            object = (LexItem)vector.elementAt(n3);
            n2 = ((LexItem)object).GetSourceCategory().Contains(l) && ((LexItem)object).GetTargetCategory().Contains(l4) || ((LexItem)object).GetSourceCategory().Contains(l4) && ((LexItem)object).GetTargetCategory().Contains(l) ? 1 : 0;
            Tag tag = new Tag(((LexItem)object).GetTag());
            boolean bl4 = n2 != 0 && tag.GetBitFlag(0);
            string4 = bl4 ? "NounAdj" : "NotNounAdj";
            tag.SetBitFlag(0, bl4);
            ((LexItem)object).SetTag(tag.GetValue());
            string3 = ((LexItem)object).GetMutateInformation() + string4 + GlobalBehavior.GetFieldSeparator();
            ((LexItem)object).SetMutateInformation(string3);
            ++n3;
        }
        return vector;
    }

    private static void GetRecursiveDerivations(LexItem lexItem, Connection connection, RamTrie ramTrie, int n, String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        ToRecursiveDerivations.CalRecursiveDerivations(lexItem, connection, ramTrie, n, string, bl, bl2, bl3, string2);
        derivations_ = new Vector(derivationHt_.values());
    }

    private static void CalRecursiveDerivations(LexItem lexItem, Connection connection, RamTrie ramTrie, int n, String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 == null) {
            object = lexItem.GetFlowHistory();
            string2 = new String();
            if (object == null) {
                object = new String();
            } else {
                stringBuffer.append((String)object);
                stringBuffer.append("+");
            }
        }
        stringBuffer.append(Flow.GetBitName(18, 1));
        string2 = string2 + stringBuffer.toString();
        object = ToRecursiveDerivations.GetDerivations(lexItem, connection, ramTrie, n, string, bl, bl2, bl3, string2);
        int n2 = 0;
        while (n2 < ((Vector)object).size()) {
            LexItem lexItem2;
            LexItem lexItem3 = (LexItem)((Vector)object).elementAt(n2);
            TermCatCatKey termCatCatKey = new TermCatCatKey(lexItem3.GetTargetTerm(), ToFruitfulVariants.GetFirstCategory(lexItem3), (int)lexItem3.GetTargetCategory().GetValue());
            if (derivationHt_.containsKey(termCatCatKey)) {
                lexItem2 = (LexItem)derivationHt_.get(termCatCatKey);
                String string3 = lexItem2.GetFlowHistory();
                String string4 = lexItem3.GetFlowHistory();
                if (string3.length() > string4.length()) {
                    derivationHt_.remove(termCatCatKey);
                    derivationHt_.put(termCatCatKey, lexItem3);
                    LexItem lexItem4 = LexItem.TargetToSource(lexItem3);
                    ToRecursiveDerivations.CalRecursiveDerivations(lexItem4, connection, ramTrie, n, string, false, bl2, bl3, string2);
                }
            } else if (!lexItem3.GetTargetTerm().equals(orgInputTerm_)) {
                derivationHt_.put(termCatCatKey, lexItem3);
                lexItem2 = LexItem.TargetToSource(lexItem3);
                ToRecursiveDerivations.CalRecursiveDerivations(lexItem2, connection, ramTrie, n, string, false, bl2, bl3, string2);
            }
            ++n2;
        }
    }

    private static void Init(String string) {
        orgInputTerm_ = string;
        derivationHt_.clear();
        derivations_.removeAllElements();
    }

    private static void UpdateFlowHistory(boolean bl) {
        if (!bl) {
            String string = Flow.GetBitName(36, 1);
            int n = 0;
            while (n < derivations_.size()) {
                LexItem lexItem = (LexItem)derivations_.elementAt(n);
                lexItem.SetFlowHistory(string);
                ++n;
            }
        }
    }

    private static Vector GetDerivationVector() {
        return derivations_;
    }
}

