/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbSynonym;
import gov.nih.nlm.nls.lvg.Db.SynonymRecord;
import gov.nih.nlm.nls.lvg.Flows.ToStripPunctuation;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Flow;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToRecursiveSynonyms
extends Transformation
implements Cloneable {
    private static final String INFO = "Recursive Synonyms";
    private static Vector synonyms_ = new Vector();

    public static Vector Mutate(LexItem lexItem, Connection connection, boolean bl, boolean bl2, boolean bl3) {
        ToRecursiveSynonyms.SetSynonymVector(lexItem);
        ToRecursiveSynonyms.GetRecursiveSynonyms(lexItem, connection, INFO, true, bl, bl2, null);
        ToRecursiveSynonyms.CleanSynonymVector(bl3);
        Vector vector = ToRecursiveSynonyms.GetSynonymVector();
        return vector;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "chest");
        LexItem lexItem = new LexItem(string, 2047L, 0xFFFFFFL);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection != null) {
                vector = ToRecursiveSynonyms.Mutate(lexItem, connection, true, true, false);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    private static void GetRecursiveSynonyms(LexItem lexItem, Connection connection, String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 == null) {
            object = lexItem.GetFlowHistory();
            string2 = new String();
            if (object == null) {
                string2 = new String();
            } else {
                stringBuffer.append((String)object);
                stringBuffer.append("+");
            }
        }
        stringBuffer.append(Flow.GetBitName(28, 1));
        string2 = string2 + stringBuffer.toString();
        object = ToRecursiveSynonyms.GetSynonyms(lexItem, connection, string, bl, bl2, bl3, string2);
        int n = 0;
        while (n < ((Vector)object).size()) {
            LexItem lexItem2;
            LexItem lexItem3 = (LexItem)((Vector)object).elementAt(n);
            boolean bl4 = false;
            int n2 = 0;
            while (n2 < synonyms_.size()) {
                lexItem2 = (LexItem)synonyms_.elementAt(n2);
                if (n2 == 0) {
                    if (lexItem2.GetTargetTerm().equals(lexItem3.GetTargetTerm())) {
                        bl4 = true;
                        break;
                    }
                } else if (lexItem2.GetTargetTerm().equals(lexItem3.GetTargetTerm()) && lexItem2.GetTargetCategory().GetValue() == lexItem3.GetTargetCategory().GetValue()) {
                    bl4 = true;
                    break;
                }
                ++n2;
            }
            if (!bl4) {
                synonyms_.addElement(lexItem3);
                lexItem2 = LexItem.TargetToSource(lexItem3);
                ToRecursiveSynonyms.GetRecursiveSynonyms(lexItem2, connection, string, false, bl2, bl3, string2);
            }
            ++n;
        }
    }

    private static void SetSynonymVector(LexItem lexItem) {
        synonyms_.removeAllElements();
        LexItem lexItem2 = new LexItem(lexItem, true);
        lexItem2.SetTargetTerm(lexItem.GetSourceTerm());
        synonyms_.addElement(lexItem2);
    }

    private static void CleanSynonymVector(boolean bl) {
        synonyms_.removeElementAt(0);
        if (!bl) {
            String string = Flow.GetBitName(35, 1);
            int n = 0;
            while (n < synonyms_.size()) {
                LexItem lexItem = (LexItem)synonyms_.elementAt(n);
                lexItem.SetFlowHistory(string);
                ++n;
            }
        }
    }

    private static Vector GetSynonymVector() {
        return synonyms_;
    }

    private static Vector GetSynonyms(LexItem lexItem, Connection connection, String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        String string3 = lexItem.GetSourceTerm();
        Vector<Object> vector = new Vector<Object>();
        String string4 = ToStripPunctuation.StripPunctuation(string3);
        String string5 = string4.toLowerCase();
        String string6 = string2;
        try {
            Vector vector2 = DbSynonym.GetSynonyms(string5, connection);
            long l = lexItem.GetSourceCategory().GetValue();
            int n = 0;
            while (n < vector2.size()) {
                SynonymRecord synonymRecord = (SynonymRecord)vector2.elementAt(n);
                String string7 = synonymRecord.GetSynonym();
                long l2 = synonymRecord.GetCat1();
                if (InputFilter.IsLegal(l, l2)) {
                    Object object;
                    String string8 = null;
                    String string9 = null;
                    if (bl2) {
                        string8 = string;
                    }
                    if (bl3) {
                        object = GlobalBehavior.GetFieldSeparator();
                        string9 = "FACT" + (String)object + synonymRecord.GetKeyForm() + (String)object + Category.ToName(synonymRecord.GetCat1()) + (String)object + synonymRecord.GetSynonym() + (String)object + Category.ToName(synonymRecord.GetCat2()) + (String)object + string2 + (String)object;
                    }
                    object = Transformation.UpdateLexItem(lexItem, string7, string6, synonymRecord.GetCat2(), Inflection.GetBitValue(0), string8, string9, false);
                    vector.addElement(object);
                }
                ++n;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return vector;
    }
}

