/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToStripDiacritics
extends Transformation
implements Cloneable {
    private static final String INFO = "Strip Diacritics";

    public static Vector Mutate(LexItem lexItem, Hashtable hashtable, boolean bl, boolean bl2) {
        String string = ToStripDiacritics.StripDiacritics(lexItem.GetSourceTerm(), hashtable);
        String string2 = null;
        String string3 = null;
        if (bl) {
            string2 = INFO;
        }
        if (bl2) {
            string3 = Transformation.NO_MUTATE_INFO;
        }
        Vector<LexItem> vector = new Vector<LexItem>();
        LexItem lexItem2 = Transformation.UpdateLexItem(lexItem, string, 40, -1L, -1L, string2, string3);
        vector.addElement(lexItem2);
        return vector;
    }

    public static Hashtable GetDiacriticsFromFile(Configuration configuration) {
        String string = configuration.GetConfiguration("LVG_DIR") + configuration.GetConfiguration("LVG_DIACRITICS_FILE");
        String string2 = null;
        Hashtable<Character, Character> hashtable = new Hashtable<Character, Character>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() <= 0 || string2.charAt(0) == '#') continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
                try {
                    while (true) {
                        int n = Integer.parseInt(stringTokenizer.nextToken());
                        Character c = new Character((char)n);
                        Character c2 = new Character(stringTokenizer.nextToken().charAt(0));
                        hashtable.put(c, c2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.toString());
            System.out.println("** Error: problem of opening/reading diacritics file: '" + string + "'.");
        }
        return hashtable;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "resum\u00e9");
        Hashtable hashtable = ToStripDiacritics.GetDiacriticsFromFile(configuration);
        LexItem lexItem = new LexItem(string);
        Vector vector = ToStripDiacritics.Mutate(lexItem, hashtable, true, true);
        Transformation.PrintResults(lexItem, vector);
    }

    private static String StripDiacritics(String string, Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            stringBuffer.append(ToStripDiacritics.NormalizeDiacritics(c, hashtable));
            ++n;
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    private static char NormalizeDiacritics(char c, Hashtable hashtable) {
        Character c2 = new Character(c);
        char c3 = c;
        if (hashtable.containsKey(c2)) {
            c3 = ((Character)hashtable.get(c2)).charValue();
        }
        return c3;
    }
}

