/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbSynonym;
import gov.nih.nlm.nls.lvg.Db.SynonymRecord;
import gov.nih.nlm.nls.lvg.Flows.ToStripPunctuation;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToSynonyms
extends Transformation
implements Cloneable {
    private static final String INFO = "Generate Synonyms";

    public static Vector Mutate(LexItem lexItem, Connection connection, boolean bl, boolean bl2) {
        Vector vector = ToSynonyms.GetSynonyms(lexItem.GetSourceTerm(), connection);
        long l = lexItem.GetSourceCategory().GetValue();
        Vector<Object> vector2 = new Vector<Object>();
        int n = 0;
        while (n < vector.size()) {
            SynonymRecord synonymRecord = (SynonymRecord)vector.elementAt(n);
            String string = synonymRecord.GetSynonym();
            long l2 = synonymRecord.GetCat1();
            if (InputFilter.IsLegal(l, l2)) {
                Object object;
                String string2 = null;
                String string3 = null;
                if (bl) {
                    string2 = INFO;
                }
                if (bl2) {
                    object = GlobalBehavior.GetFieldSeparator();
                    string3 = "FACT" + (String)object + synonymRecord.GetKeyFormNpLc() + (String)object + synonymRecord.GetKeyForm() + (String)object + Category.ToName(synonymRecord.GetCat1()) + (String)object + synonymRecord.GetSynonym() + (String)object + Category.ToName(synonymRecord.GetCat2()) + (String)object;
                }
                object = Transformation.UpdateLexItem(lexItem, string, 28, synonymRecord.GetCat2(), Inflection.GetBitValue(0), string2, string3);
                vector2.addElement(object);
            }
            ++n;
        }
        return vector2;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "aminophylline");
        LexItem lexItem = new LexItem(string, 2047L, 0xFFFFFFL);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            if (connection != null) {
                vector = ToSynonyms.Mutate(lexItem, connection, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    private static Vector GetSynonyms(String string, Connection connection) {
        String string2 = ToStripPunctuation.StripPunctuation(string);
        String string3 = string2.toLowerCase();
        Vector vector = new Vector();
        try {
            vector = DbSynonym.GetSynonyms(string3, connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return vector;
    }
}

