/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.Strip;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToSyntacticUninvert
extends Transformation
implements Cloneable {
    private static final String INFO = "Syntactic Uninvert";

    public static Vector Mutate(LexItem lexItem, Vector vector, Vector vector2, boolean bl, boolean bl2) {
        String string = lexItem.GetSourceTerm();
        String string2 = Strip.StripStrings(string, vector, false);
        String string3 = ToSyntacticUninvert.Uninvert(string2, vector2);
        String string4 = null;
        String string5 = null;
        if (bl) {
            string4 = INFO;
        }
        if (bl2) {
            string5 = Transformation.NO_MUTATE_INFO;
        }
        Vector<LexItem> vector3 = new Vector<LexItem>();
        LexItem lexItem2 = Transformation.UpdateLexItem(lexItem, string3, 44, -1L, -1L, string4, string5);
        vector3.addElement(lexItem2);
        return vector3;
    }

    public static Vector GetNonInfoWordsFromFile(Configuration configuration) {
        String string = configuration.GetConfiguration("LVG_DIR") + configuration.GetConfiguration("LVG_NONINFO_WORD_FILE");
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() <= 0 || string2.charAt(0) == '#') continue;
                vector.addElement(string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.toString());
            System.out.println("** Error: problem of opening/reading non-Info words file: '" + string + "'.");
        }
        return vector;
    }

    public static Vector GetConjunctionWordsFromFile(Configuration configuration) {
        String string = configuration.GetConfiguration("LVG_DIR") + configuration.GetConfiguration("LVG_CONJ_WORD_FILE");
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() <= 0 || string2.charAt(0) == '#') continue;
                vector.addElement(string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.toString());
            System.out.println("** Error: problem of opening/reading conjunction words file: '" + string + "'.");
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "Angioplasty, Transluminal, Percutaneous Coronary");
        Vector vector = ToSyntacticUninvert.GetNonInfoWordsFromFile(configuration);
        Vector vector2 = ToSyntacticUninvert.GetConjunctionWordsFromFile(configuration);
        LexItem lexItem = new LexItem(string);
        Vector vector3 = ToSyntacticUninvert.Mutate(lexItem, vector, vector2, true, true);
        Transformation.PrintResults(lexItem, vector3);
    }

    private static String Uninvert(String string, Vector vector) {
        String string2;
        CharSequence charSequence;
        Object object;
        String string3;
        Vector<String> vector2 = new Vector<String>();
        String string4 = ",";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string4);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            vector2.addElement(string3);
            object = ToSyntacticUninvert.GetFirstWord(string3);
            if (!vector.contains(object)) continue;
            bl = true;
        }
        string3 = new String();
        object = new Vector();
        int n = 0;
        while (n < vector2.size()) {
            charSequence = (String)vector2.elementAt(n);
            if (((String)charSequence).startsWith(" ")) {
                if (bl) {
                    string3 = string3 + ", " + ((String)charSequence).trim();
                } else {
                    ((Vector)object).addElement(string3);
                    string3 = new String(((String)charSequence).trim());
                }
            } else {
                string3 = string3.length() == 0 ? ((String)charSequence).trim() : string3 + "," + ((String)charSequence).trim();
            }
            ++n;
        }
        ((Vector)object).addElement(string3);
        charSequence = new StringBuffer();
        int n2 = ((Vector)object).size() - 1;
        while (n2 >= 0) {
            string2 = (String)((Vector)object).elementAt(n2);
            ((StringBuffer)charSequence).append(string2);
            ((StringBuffer)charSequence).append(" ");
            --n2;
        }
        string2 = ((StringBuffer)charSequence).toString();
        return string2.trim();
    }

    private static String GetFirstWord(String string) {
        String string2 = " \t";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        return stringTokenizer.nextToken();
    }
}

