/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbInflection;
import gov.nih.nlm.nls.lvg.Db.DbUninflection;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Trie.RuleResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToUninflectTerm
extends Transformation {
    private static final String INFO = "Uninflect Term";

    public static Vector Mutate(LexItem lexItem, Connection connection, RamTrie ramTrie, boolean bl, boolean bl2) throws SQLException {
        Vector vector = ToUninflectTerm.UninflectTerm(lexItem, connection, ramTrie, INFO, bl, bl2);
        return vector;
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration("data.config.lvg", true);
        String string = Transformation.GetTestStr(stringArray, "Left Data");
        int n = Integer.parseInt(configuration.GetConfiguration("MIN_TERM_LENGTH"));
        String string2 = configuration.GetConfiguration("LVG_DIR");
        LexItem lexItem = new LexItem(string, 2047L, 0xFFFFFFL);
        Vector vector = new Vector();
        try {
            Connection connection = DbBase.OpenConnection(configuration);
            boolean bl = true;
            RamTrie ramTrie = new RamTrie(bl, n, string2, 0);
            if (connection != null) {
                vector = ToUninflectTerm.Mutate(lexItem, connection, ramTrie, true, true);
            }
            DbBase.CloseConnection(connection);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Transformation.PrintResults(lexItem, vector);
    }

    protected static Vector UninflectTerm(LexItem lexItem, Connection connection, RamTrie ramTrie, String string, boolean bl, boolean bl2) {
        String string2 = lexItem.GetSourceTerm();
        long l = lexItem.GetSourceCategory().GetValue();
        long l2 = lexItem.GetSourceInflection().GetValue();
        Vector<Object> vector = new Vector<Object>();
        try {
            Object object;
            long l3;
            Object object2;
            Vector vector2 = DbUninflection.GetUninflections(string2, connection);
            int n = 0;
            while (n < vector2.size()) {
                object2 = (InflectionRecord)vector2.elementAt(n);
                String string3 = ((InflectionRecord)object2).GetUninflectedTerm();
                long l4 = ((InflectionRecord)object2).GetCategory();
                if (InputFilter.IsLegal(l, l2, l4, l3 = ((InflectionRecord)object2).GetInflection())) {
                    String string4 = null;
                    String string5 = null;
                    if (bl) {
                        string4 = string + " (FACT)";
                    }
                    if (bl2) {
                        object = GlobalBehavior.GetFieldSeparator();
                        string5 = "FACT" + (String)object + ((InflectionRecord)object2).GetInflectedTerm() + (String)object + Category.ToName(((InflectionRecord)object2).GetCategory()) + (String)object + Inflection.ToName(((InflectionRecord)object2).GetInflection()) + (String)object + string3 + (String)object + Category.ToName(((InflectionRecord)object2).GetCategory()) + (String)object + "base" + (String)object + ((InflectionRecord)object2).GetEui() + (String)object;
                    }
                    object = Transformation.UpdateLexItem(lexItem, string3, 13, l4, Inflection.GetBitValue(0), string4, string5);
                    vector.addElement(object);
                }
                ++n;
            }
            if (vector.size() == 0) {
                object2 = ramTrie.GetUninflectedTermsByRules(string2, l, l2, true);
                int n2 = 0;
                while (n2 < ((Vector)object2).size()) {
                    LexItem lexItem2;
                    RuleResult ruleResult = (RuleResult)((Vector)object2).elementAt(n2);
                    String string6 = ruleResult.GetOutTerm();
                    l3 = Category.ToValue(ruleResult.GetOutCategory());
                    long l5 = Inflection.ToValue(ruleResult.GetOutInflection());
                    object = null;
                    String string7 = null;
                    if (bl) {
                        object = string + " (RULE)";
                    }
                    if (bl2) {
                        string7 = "RULE" + GlobalBehavior.GetFieldSeparator() + ruleResult.GetRuleString();
                    }
                    if (!vector.contains(lexItem2 = Transformation.UpdateLexItem(lexItem, string6, 13, l3, l5, (String)object, string7)) && !DbInflection.IsExistInflectedTerm(string6, connection)) {
                        vector.addElement(lexItem2);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }
}

